/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.printer;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.aofeng.hybrid.activity.PreludeActivity;
import com.aofeng.hybrid.pos.printer.AfPrinter;
import com.aofeng.hybrid.util.BluetoothService;
import com.aofeng.hybrid.util.command.PrintPicture;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import zj.com.customize.sdk.Other;

@SuppressLint(value={"NewAPI"})
public class BTPrint
implements AfPrinter {
    private BluetoothAdapter mBtAdapter;
    private BluetoothService mService;
    public String bluePrefix;
    private ArrayList<BluetoothDevice> deviceArrayList = new ArrayList();
    @SuppressLint(value={"HandlerLeak"})
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
        }
    };
    private final BluetoothAdapter.LeScanCallback callback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice bluetoothDevice, int i, byte[] bytes) {
            String name = bluetoothDevice.getName();
            Log.d((String)"BTPrint", (String)("onLeScan: name = " + name + ", address = " + bluetoothDevice.getAddress()));
            if (name != null && name.contains("P") && !name.contains(" ") && !BTPrint.this.deviceArrayList.contains(bluetoothDevice)) {
                BTPrint.this.deviceArrayList.add(bluetoothDevice);
            }
        }
    };

    public static byte translate(int i) {
        switch (i) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
        }
        return 0;
    }

    public BTPrint() {
        this.mBtAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mService = new BluetoothService(PreludeActivity.context, this.mHandler);
    }

    @Override
    public boolean openPrinter() {
        if (!this.mBtAdapter.isEnabled()) {
            this.mBtAdapter.enable();
        }
        while (!this.mBtAdapter.isEnabled()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public Set<BluetoothDevice> getBondedDevices() {
        if (this.mBtAdapter != null) {
            return this.mBtAdapter.getBondedDevices();
        }
        return null;
    }

    public void connect(BluetoothDevice device) {
        this.mService.connect(device);
    }

    @Override
    public int getPrinterState() {
        int statusCode = 0;
        try {
            statusCode = this.mService.getState();
        }
        catch (Exception e) {
            return statusCode;
        }
        return statusCode;
    }

    @Override
    public int print(String msg) {
        int res = 1;
        this.openPrinter();
        Set devices = this.mBtAdapter.getBondedDevices();
        try {
            if (this.getPrinterState() != 3) {
                this.mService.start();
                block2: for (BluetoothDevice device : devices) {
                    Log.d((String)"BTPrint", (String)("print: " + device.getName() + device.getAddress()));
                    while (true) {
                        if (this.getPrinterState() != 2) {
                            this.connect(device);
                            continue block2;
                        }
                        Thread.sleep(200L);
                    }
                }
            }
            while (this.getPrinterState() == 2) {
                Thread.sleep(200L);
            }
            if (this.getPrinterState() != 3) {
                return -12;
            }
            JSONArray arry = new JSONArray(msg);
            if (arry.length() > 0) {
                byte[] tail = new byte[]{10, 13, 0};
                for (int i = 0; i < arry.length(); ++i) {
                    if (this.getPrinterState() != 3) {
                        return -12;
                    }
                    JSONObject json = arry.getJSONObject(i);
                    this.mService.write(new byte[]{27, 77, BTPrint.translate(2)});
                    if (json.getInt("type") == 1) {
                        this.mService.write(json.getString("text").getBytes("GBK"));
                        this.mService.write(new byte[]{29, 107, 65, 12});
                        continue;
                    }
                    if (json.getInt("type") == 2) {
                        byte[] QRCodeBytes = BTPrint.getBarCommand(json.getString("text"), 1, 1, 8);
                        this.mService.write(QRCodeBytes);
                        this.mService.write(new byte[]{27, 90, 3, 3, 8, 0, 0});
                        continue;
                    }
                    if (json.getInt("type") == 3) {
                        String mssssg = json.getString("text") + "\n";
                        this.mService.write(mssssg.getBytes("GBK"));
                        continue;
                    }
                    if (json.getInt("type") == 4) {
                        String unit = json.getString("unit");
                        if (unit.equals("pixel")) {
                            char n = (char)json.getInt("value");
                            this.mService.write(new byte[]{27, 74, BTPrint.translate(n)});
                            continue;
                        }
                        if (!unit.equals("line")) continue;
                        char n = (char)json.getInt("value");
                        this.mService.write(new byte[]{27, 100, BTPrint.translate(n)});
                        continue;
                    }
                    if (json.getInt("type") != 5) continue;
                    if (json.has("align")) {
                        String align = json.getString("align");
                        if (align.equals("center")) {
                            this.mService.write(new byte[]{27, 97, 1});
                        } else if (align.equals("left")) {
                            this.mService.write(new byte[]{27, 97, 0});
                        } else if (align.equals("right")) {
                            this.mService.write(new byte[]{27, 97, 2});
                        }
                    }
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = false;
                    String filePath = json.getString("url");
                    Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options).copy(Bitmap.Config.ARGB_8888, true);
                    Bitmap bmp = Other.createAppIconText((Bitmap)bitmap, (String)"", (float)25.0f, (boolean)true, (int)200);
                    this.mService.write(PrintPicture.POS_PrintBMP(bitmap, 384, 0));
                }
                this.mService.write(tail);
            }
            Thread.sleep(200L);
        }
        catch (Exception e) {
            return -11;
        }
        return res;
    }

    @Override
    public boolean closePrinter() {
        if (this.mService != null) {
            this.mService.stop();
        }
        if (this.mBtAdapter != null) {
            this.mBtAdapter.cancelDiscovery();
        }
        return true;
    }

    public static byte[] getBarCommand(String str, int nVersion, int nErrorCorrectionLevel, int nMagnification) {
        if (nVersion < 0 | nVersion > 19 | nErrorCorrectionLevel < 0 | nErrorCorrectionLevel > 3 | nMagnification < 1 | nMagnification > 8) {
            return null;
        }
        byte[] bCodeData = null;
        try {
            bCodeData = str.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        byte[] command = new byte[bCodeData.length + 7];
        command[0] = 27;
        command[1] = 90;
        command[2] = (byte)nVersion;
        command[3] = (byte)nErrorCorrectionLevel;
        command[4] = (byte)nMagnification;
        command[5] = (byte)(bCodeData.length & 0xFF);
        command[6] = (byte)((bCodeData.length & 0xFF00) >> 8);
        System.arraycopy(bCodeData, 0, command, 7, bCodeData.length);
        return command;
    }
}

