/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.device;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.aofeng.hybrid.pos.device.Device;
import com.smartpos.syncard.ISIM4442CardReaderManager;
import com.zacloud.deviceservice.aidl.IAT1604CardReader;
import com.zacloud.deviceservice.aidl.IBeeper;
import com.zacloud.deviceservice.aidl.IDeviceInfo;
import com.zacloud.deviceservice.aidl.IDeviceService;
import com.zacloud.deviceservice.aidl.IInsertCardReader;
import com.zacloud.deviceservice.aidl.ILed;
import com.zacloud.deviceservice.aidl.IMagCardReader;
import com.zacloud.deviceservice.aidl.IPBOC;
import com.zacloud.deviceservice.aidl.IPinpad;
import com.zacloud.deviceservice.aidl.IPrinter;
import com.zacloud.deviceservice.aidl.IRFCardReader;
import com.zacloud.deviceservice.aidl.ISIM4428CardReader;
import com.zacloud.deviceservice.aidl.ISIM4442CardReader;
import com.zacloud.deviceservice.aidl.IScanner;
import com.zacloud.deviceservice.aidl.ISerialPort;

public class VerifoneDevice
implements Device {
    public static IPinpad pinpad;
    public static IPBOC pboc;
    public static IBeeper beeper;
    public static ILed led;
    public static IPrinter printer;
    public static IDeviceInfo deviceInfo;
    public static IScanner scanner;
    public static IMagCardReader magCardReader;
    public static IInsertCardReader insertCardReader;
    public static IRFCardReader rfCardReader;
    public static ISerialPort serialPort;
    public static ISIM4442CardReaderManager isim4442CardReaderManager;
    private static ISIM4442CardReader sim4442CardReader;
    private static ISIM4428CardReader sim4428CardReader;
    private static IAT1604CardReader at1604CardReader;
    public final String TAG = this.getClass().getName();
    private Context context;
    public IDeviceService deviceService;
    private static int lastCameraId;
    ServiceConnection connection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            Log.e((String)VerifoneDevice.this.TAG, (String)(name.getPackageName() + " is disconnected"));
            VerifoneDevice.this.deviceService = null;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.e((String)VerifoneDevice.this.TAG, (String)("ServiceConnected() [" + name.getPackageName() + "]"));
            VerifoneDevice.this.deviceService = IDeviceService.Stub.asInterface((IBinder)service);
            Log.e((String)VerifoneDevice.this.TAG, (String)"connected");
            try {
                VerifoneDevice.reset();
                VerifoneDevice.this.initDevices(VerifoneDevice.this.context);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                Log.e((String)VerifoneDevice.this.TAG, (String)("init devices RemoteException:" + e.getMessage()));
            }
            this.linkToDeath(service);
        }

        private void linkToDeath(IBinder service) {
            try {
                service.linkToDeath(new IBinder.DeathRecipient(){

                    public void binderDied() {
                        Log.d((String)VerifoneDevice.this.TAG, (String)"binder service is dead!!!");
                        VerifoneDevice.this.deviceService = null;
                        VerifoneDevice.this.initDevice(VerifoneDevice.this.context);
                    }
                }, 0);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    public void initDevice(Context context) {
        this.context = context;
        Intent intent = new Intent();
        intent.setAction("com.zacloud.device_service");
        intent.setPackage("com.zacloud.deviceservice");
        context.bindService(intent, this.connection, 1);
    }

    @Override
    public String getSN() {
        try {
            return deviceInfo.getSerialNo();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"getSN: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getIP() {
        return null;
    }

    @Override
    public String getAddress() {
        return null;
    }

    public void initDevices(Context application) throws RemoteException {
        if (application == null) {
            Log.i((String)this.TAG, (String)"initDevices application == null");
            throw new RemoteException();
        }
        if (this.deviceService != null) {
            try {
                pinpad = this.getPinpad();
                pboc = this.getPBOC();
                printer = this.getPrinter();
                deviceInfo = this.getDeviceInfo();
                scanner = this.getScanner(1);
                magCardReader = this.getMagCardReader();
                insertCardReader = this.getInsertCardReader();
                rfCardReader = this.getRFCardReader();
                led = this.getLed();
                serialPort = this.getSerialPort();
                isim4442CardReaderManager = this.getSim4442CardReaderManager(this.context);
            }
            catch (RemoteException e) {
                Log.i((String)this.TAG, (String)"deviceService RemoteException");
                e.printStackTrace();
                throw e;
            }
        } else {
            Log.e((String)this.TAG, (String)"application.bindDeviceService()");
            this.initDevice(this.context);
            VerifoneDevice.reset();
        }
    }

    public void rebindDeviceService(Application application) {
        Log.e((String)this.TAG, (String)"rebindDeviceService");
        this.initDevice(this.context);
        VerifoneDevice.reset();
    }

    public void rebindDeviceService() {
        Log.e((String)this.TAG, (String)"rebindDeviceService");
        VerifoneDevice.reset();
    }

    public boolean checkState() throws RemoteException {
        if (this.context == null) {
            Log.e((String)this.TAG, (String)"checkState application == null");
            return false;
        }
        if (this.deviceService == null) {
            Log.e((String)this.TAG, (String)"bindDeviceService");
            this.initDevice(this.context);
            VerifoneDevice.reset();
            throw new RemoteException("\u8bbe\u5907\u670d\u52a1\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    public IPinpad getPinpad() throws RemoteException, RemoteException {
        if (pinpad == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                pinpad = IPinpad.Stub.asInterface((IBinder)this.deviceService.getPinpad(5));
                return pinpad;
            }
            catch (RemoteException e) {
                throw new RemoteException("PINPAD\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return pinpad;
    }

    public IPBOC getPBOC() throws RemoteException {
        if (pboc == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                pboc = IPBOC.Stub.asInterface((IBinder)this.deviceService.getPBOC());
                return pboc;
            }
            catch (RemoteException e) {
                throw new RemoteException("PBOC\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return pboc;
    }

    public IPrinter getPrinter() throws RemoteException {
        if (printer == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                printer = IPrinter.Stub.asInterface((IBinder)this.deviceService.getPrinter());
                return printer;
            }
            catch (RemoteException e) {
                throw new RemoteException("\u6253\u5370\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return printer;
    }

    public IDeviceInfo getDeviceInfo() throws RemoteException {
        if (deviceInfo == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                if (this.deviceService == null) {
                    return null;
                }
                deviceInfo = IDeviceInfo.Stub.asInterface((IBinder)this.deviceService.getDeviceInfo());
                return deviceInfo;
            }
            catch (RemoteException e) {
                throw new RemoteException("\u8bbe\u5907\u4fe1\u606f\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return deviceInfo;
    }

    public IRFCardReader getRFCardReader() throws RemoteException {
        if (rfCardReader == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                rfCardReader = IRFCardReader.Stub.asInterface((IBinder)this.deviceService.getRFCardReader());
                return rfCardReader;
            }
            catch (RemoteException e) {
                throw new RemoteException("\u975e\u63a5\u8bfb\u5361\u5668\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return rfCardReader;
    }

    public IInsertCardReader getInsertCardReader() throws RemoteException {
        if (insertCardReader == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                insertCardReader = IInsertCardReader.Stub.asInterface((IBinder)this.deviceService.getInsertCardReader());
                return insertCardReader;
            }
            catch (RemoteException e) {
                throw new RemoteException("\u63a5\u89e6\u5f0f\u8bfb\u5361\u5668\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return insertCardReader;
    }

    public IMagCardReader getMagCardReader() throws RemoteException {
        if (magCardReader == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                magCardReader = IMagCardReader.Stub.asInterface((IBinder)this.deviceService.getMagCardReader());
                return magCardReader;
            }
            catch (RemoteException e) {
                throw new RemoteException("\u78c1\u6761\u5361\u8bfb\u5361\u5668\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return magCardReader;
    }

    public IScanner getScanner(int cameraId) throws RemoteException {
        if (scanner == null || lastCameraId != cameraId) {
            if (!this.checkState()) {
                return null;
            }
            try {
                lastCameraId = cameraId;
                scanner = IScanner.Stub.asInterface((IBinder)this.deviceService.getScanner(cameraId));
                return scanner;
            }
            catch (RemoteException e) {
                throw new RemoteException("\u626b\u7801\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return scanner;
    }

    public IBeeper getBeeper() throws RemoteException {
        if (beeper == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                beeper = IBeeper.Stub.asInterface((IBinder)this.deviceService.getBeeper());
                return beeper;
            }
            catch (RemoteException e) {
                throw new RemoteException("\u8702\u9e23\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return beeper;
    }

    public ILed getLed() throws RemoteException {
        if (led == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                led = ILed.Stub.asInterface((IBinder)this.deviceService.getLed());
                return led;
            }
            catch (RemoteException e) {
                Log.i((String)"icbcpay", (String)("getLed(), RemoteException=" + e.getMessage()));
                throw new RemoteException("\u706f\u8bbe\u5907\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                Log.i((String)"icbcpay", (String)("getLed(), SecurityException=" + e.getMessage()));
                throw new RemoteException(e.getMessage());
            }
        }
        return led;
    }

    public ISerialPort getSerialPort() throws RemoteException {
        if (serialPort == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                serialPort = ISerialPort.Stub.asInterface((IBinder)this.deviceService.getSerialPort());
                return serialPort;
            }
            catch (RemoteException e) {
                Log.i((String)"icbcpay", (String)("getSerialPort(), RemoteException=" + e.getMessage()));
                throw new RemoteException("\u4e32\u53e3\u8bbe\u5907\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                Log.i((String)"icbcpay", (String)("getSerialPort(), SecurityException=" + e.getMessage()));
                throw new RemoteException(e.getMessage());
            }
        }
        return serialPort;
    }

    public ISIM4428CardReader getSim4428CardReader() throws RemoteException {
        if (sim4428CardReader == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                Bundle bundle = new Bundle();
                bundle.putInt("cardType", 13);
                sim4428CardReader = ISIM4428CardReader.Stub.asInterface((IBinder)this.deviceService.getSyncCardReader(bundle));
                return sim4428CardReader;
            }
            catch (RemoteException e) {
                throw new RemoteException("\u78c1\u6761\u5361\u8bfb\u5361\u5668\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return sim4428CardReader;
    }

    public ISIM4442CardReader getSim4442CardReader() throws RemoteException {
        if (sim4442CardReader == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                Bundle bundle = new Bundle();
                bundle.putInt("cardType", 14);
                sim4442CardReader = ISIM4442CardReader.Stub.asInterface((IBinder)this.deviceService.getSyncCardReader(bundle));
                return sim4442CardReader;
            }
            catch (RemoteException e) {
                throw new RemoteException("\u78c1\u6761\u5361\u8bfb\u5361\u5668\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return sim4442CardReader;
    }

    public IAT1604CardReader getAt1604CardReader(int cardType) throws RemoteException {
        if (at1604CardReader == null) {
            if (!this.checkState()) {
                return null;
            }
            try {
                Bundle bundle = new Bundle();
                bundle.putInt("cardType", cardType);
                at1604CardReader = IAT1604CardReader.Stub.asInterface((IBinder)this.deviceService.getSyncCardReader(bundle));
                return at1604CardReader;
            }
            catch (RemoteException e) {
                throw new RemoteException("\u78c1\u6761\u5361\u8bfb\u5361\u5668\u670d\u52a1\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
        }
        return at1604CardReader;
    }

    public ISIM4442CardReaderManager getSim4442CardReaderManager(Context context) {
        if (isim4442CardReaderManager == null) {
            return ISIM4442CardReaderManager.getInstance((Context)context);
        }
        return isim4442CardReaderManager;
    }

    public static void reset() {
        pinpad = null;
        pboc = null;
        beeper = null;
        led = null;
        printer = null;
        deviceInfo = null;
        scanner = null;
        magCardReader = null;
        insertCardReader = null;
        rfCardReader = null;
        serialPort = null;
        isim4442CardReaderManager = null;
    }

    static {
        lastCameraId = 1;
    }
}

