/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.device;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.aofeng.hybrid.activity.PreludeActivity;
import com.aofeng.hybrid.pos.device.Device;
import com.centerm.smartpos.util.Utility;
import tw.com.prolific.driver.pl2303.PL2303Driver;

public class EsLinkDevice
implements Device {
    private static final String TAG = EsLinkDevice.class.getName();
    private Context context;
    private static final String ACTION_USB_PERMISSION = "com.prolific.pl2303hxdsimpletest.USB_PERMISSION";
    public static PL2303Driver driver;
    public static final PL2303Driver.BaudRate CONN_BAUDRATE;
    private static final String[] permissions;

    @Override
    public void initDevice(Context context) {
        this.context = context;
        EsLinkDevice.init();
    }

    public static boolean init() {
        driver = new PL2303Driver((UsbManager)PreludeActivity.context.getSystemService("usb"), PreludeActivity.context, ACTION_USB_PERMISSION);
        if (!driver.PL2303USBFeatureSupported()) {
            driver = null;
            Log.d((String)TAG, (String)"onCreateView: No Support USB host API");
            return false;
        }
        return EsLinkDevice.conn();
    }

    public static boolean conn() {
        if (!driver.enumerate()) {
            Log.e((String)TAG, (String)"no more devices found");
            return false;
        }
        Log.e((String)TAG, (String)"\u53d1\u73b0\u8bbe\u5907");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        driver.InitByBaudRate(CONN_BAUDRATE, 700);
        return true;
    }

    public static boolean close() {
        driver.end();
        driver = null;
        return true;
    }

    @Override
    public String getSN() {
        return EsLinkDevice.getDeviceInfo(this.context);
    }

    public static String getDeviceInfo(Context context) {
        String deviceId;
        TelephonyManager telephonemanager = (TelephonyManager)context.getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 24) {
            EsLinkDevice.checkBlePermission(context);
        }
        if (Utility.isEmpty((String)(deviceId = telephonemanager.getDeviceId()))) {
            deviceId = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        return deviceId;
    }

    public static void checkBlePermission(Context context) {
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])permissions, (int)1);
        } else {
            Log.i((String)"tag", (String)"\u5df2\u7533\u8bf7\u6743\u9650");
        }
    }

    @Override
    public String getIP() {
        return null;
    }

    @Override
    public String getAddress() {
        return null;
    }

    static {
        CONN_BAUDRATE = PL2303Driver.BaudRate.B9600;
        permissions = new String[]{"android.permission.READ_PHONE_STATE"};
    }
}

