/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.plugin;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import com.aofeng.hybrid.plugin.NativeCallJS;
import com.aofeng.hybrid.util.LogUtil;
import com.google.gson.Gson;
import com.tencent.smtt.sdk.WebView;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsCallNative {
    private static final String TAG = "JsCallNative";
    private static final String RETURN_RESULT_FORMAT = "{\"code\": %d, \"data\": %s}";
    private HashMap<String, Method> mMethodsMap;
    private String mBridgeName;
    private String mInjectedJs;
    private Gson mGson;

    public JsCallNative(String bridgeName, Class<?> injectedCls) {
        try {
            if (TextUtils.isEmpty((CharSequence)bridgeName)) {
                throw new Exception("\u6ce8\u5165\u7684JS\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            this.mBridgeName = bridgeName;
            this.mMethodsMap = new HashMap();
            StringBuilder sb = new StringBuilder("javascript:(function(b){console.log(\"");
            sb.append(this.mBridgeName);
            sb.append(" initialization begin\");var a={queue:[],callback:function(){var d=Array.prototype.slice.call(arguments,0);var c=d.shift();var e=d.shift();this.queue[c].apply(this,d);if(!e){delete this.queue[c]}}};");
            while (injectedCls != null) {
                Method[] methods;
                for (Method method : methods = injectedCls.getDeclaredMethods()) {
                    String sign;
                    if (method.getModifiers() != 9 || (sign = this.genJavaMethodSign(method)) == null) continue;
                    this.mMethodsMap.put(sign, method);
                    sb.append(String.format("a.%s=", method.getName()));
                }
                injectedCls = injectedCls.getSuperclass();
            }
            sb.append("function(){var f=Array.prototype.slice.call(arguments,0);if(f.length<1){throw\"");
            sb.append(this.mBridgeName);
            sb.append(" call error, message:miss method name\"}var e=[];for(var h=1;h<f.length;h++){var c=f[h];var j=typeof c;e[e.length]=j;if(j==\"function\"){var d=a.queue.length;a.queue[d]=c;f[h]=d}}var g=JSON.parse(prompt(JSON.stringify({method:f.shift(),types:e,args:f})));");
            sb.append("console.log('native call return with load: '+JSON.stringify(g));return g};Object.getOwnPropertyNames(a).forEach(function(d){var c=a[d];if(typeof c===\"function\"&&d!==\"callback\"){a[d]=function(){return c.apply(a,[d].concat(Array.prototype.slice.call(arguments,0)))}}});b.");
            sb.append(this.mBridgeName);
            sb.append("=a;console.log(\"");
            sb.append(this.mBridgeName);
            sb.append(" initialization end\")})(window);");
            this.mInjectedJs = sb.toString();
        }
        catch (Exception e) {
            LogUtil.e(TAG, "init js error:" + e.getMessage());
        }
    }

    private String genJavaMethodSign(Method method) {
        String sign = method.getName();
        Class<?>[] argsTypes = method.getParameterTypes();
        int len = argsTypes.length;
        if (len < 1 || argsTypes[0] != WebView.class) {
            LogUtil.w(TAG, "\u65b9\u6cd5(" + sign + ") \u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u662f WebView");
            return null;
        }
        for (int k = 1; k < len; ++k) {
            Class<?> cls = argsTypes[k];
            sign = cls == String.class ? sign + "_S" : (cls == Integer.TYPE || cls == Long.TYPE || cls == Float.TYPE || cls == Double.TYPE ? sign + "_N" : (cls == Boolean.TYPE ? sign + "_B" : (cls == JSONObject.class ? sign + "_O" : (cls == NativeCallJS.class ? sign + "_F" : sign + "_P"))));
        }
        return sign;
    }

    public String getPreloadInterfaceJS() {
        return this.mInjectedJs;
    }

    public String call(WebView webView, String jsonStr) {
        if (!TextUtils.isEmpty((CharSequence)jsonStr)) {
            try {
                JSONObject callJson = new JSONObject(jsonStr);
                String methodName = callJson.getString("method");
                JSONArray argsTypes = callJson.getJSONArray("types");
                JSONArray argsVals = callJson.getJSONArray("args");
                String sign = methodName;
                int len = argsTypes.length();
                Object[] values = new Object[len + 1];
                int numIndex = 0;
                values[0] = webView;
                for (int k = 0; k < len; ++k) {
                    String currType = argsTypes.optString(k);
                    if ("string".equals(currType)) {
                        sign = sign + "_S";
                        values[k + 1] = argsVals.isNull(k) ? null : argsVals.getString(k);
                        continue;
                    }
                    if ("number".equals(currType)) {
                        sign = sign + "_N";
                        numIndex = numIndex * 10 + k + 1;
                        continue;
                    }
                    if ("boolean".equals(currType)) {
                        sign = sign + "_B";
                        values[k + 1] = argsVals.getBoolean(k);
                        continue;
                    }
                    if ("object".equals(currType)) {
                        sign = sign + "_O";
                        values[k + 1] = argsVals.isNull(k) ? null : argsVals.getJSONObject(k);
                        continue;
                    }
                    if ("function".equals(currType)) {
                        sign = sign + "_F";
                        values[k + 1] = new NativeCallJS(webView, this.mBridgeName, argsVals.getInt(k));
                        continue;
                    }
                    sign = sign + "_P";
                }
                Method currMethod = this.mMethodsMap.get(sign);
                if (currMethod == null) {
                    return "{\"code\":500,\"data\":\"Cant find method with signature:\"" + sign + "}";
                }
                if (numIndex > 0) {
                    Class<?>[] methodTypes = currMethod.getParameterTypes();
                    while (numIndex > 0) {
                        int currIndex = numIndex - numIndex / 10 * 10;
                        Class<?> currCls = methodTypes[currIndex];
                        values[currIndex] = currCls == Integer.TYPE ? (Number)argsVals.getInt(currIndex - 1) : (Number)(currCls == Long.TYPE ? (Number)Long.parseLong(argsVals.getString(currIndex - 1)) : (Number)argsVals.getDouble(currIndex - 1));
                        numIndex /= 10;
                    }
                }
                return this.getJsonResult(currMethod.invoke(null, values));
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    return "{\"code\":500,\"data\":\"method execution error:\"" + e.getCause().getMessage() + "}";
                }
                return "{\"code\":500,\"data\":\"method execution error:\"" + e.getMessage() + "}";
            }
        }
        return "{\"code\":500,\"data\":\"Bad invocation arguments.\"}";
    }

    @SuppressLint(value={"DefaultLocale"})
    private String getJsonResult(Object result) {
        String insertRes;
        if (result == null) {
            insertRes = "null";
        } else if (result instanceof String) {
            insertRes = "\"" + result + "\"";
        } else if (!(result instanceof Integer || result instanceof Long || result instanceof Boolean || result instanceof Float || result instanceof Double || result instanceof JSONObject)) {
            if (this.mGson == null) {
                this.mGson = new Gson();
            }
            insertRes = this.mGson.toJson(result);
        } else {
            insertRes = result instanceof JSONObject ? String.valueOf(result) : String.valueOf(result);
        }
        if (!(result instanceof JSONObject)) {
            insertRes = String.format(String.format(RETURN_RESULT_FORMAT, 200, insertRes), new Object[0]);
        }
        return insertRes;
    }
}

