/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.plugin;

import android.app.Activity;
import android.content.Context;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import com.aofeng.hybrid.util.LogUtil;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.export.external.interfaces.WebResourceResponse;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;

public class AFWebViewClient
extends WebViewClient {
    private static final String TAG = "AFWebViewClient";
    private Activity mActivity;

    public AFWebViewClient(Activity activity) {
        this.mActivity = activity;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        LogUtil.d(TAG, "shouldOverrideUrlLoading\uff1a" + url);
        if (ActivityCompat.checkSelfPermission((Context)view.getContext(), (String)"android.permission.READ_PHONE_STATE") != 0) {
            String[] permissions = new String[]{"android.permission.READ_PHONE_STATE"};
            ActivityCompat.requestPermissions((Activity)this.mActivity, (String[])permissions, (int)1);
        }
        String rnd = "stamp=" + new Date().getTime() + "&sn=" + ((TelephonyManager)view.getContext().getSystemService("phone")).getDeviceId();
        if (!url.contains("?")) {
            url = url + "?";
        }
        url = url + rnd;
        view.loadUrl(url);
        return false;
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        LogUtil.e(TAG, "onReceivedError = " + failingUrl);
        LogUtil.e(TAG, "errorCode = " + errorCode + " description " + description);
        super.onReceivedError(view, errorCode, description, failingUrl);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        view.clearCache(true);
        if (this.mActivity != null) {
            this.mActivity.setTitle((CharSequence)view.getTitle());
        }
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        if (url.endsWith(".wasm")) {
            try {
                String[] s = url.split("/");
                url = view.getContext().getFilesDir().getAbsolutePath() + File.separator + "www/" + s[s.length - 1];
                if (new File(url).exists()) {
                    WebResourceResponse webResourceResponse = new WebResourceResponse("application/wasm", "utf-8", (InputStream)new FileInputStream(url));
                    return webResourceResponse;
                }
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
        }
        return super.shouldInterceptRequest(view, url);
    }

    @RequiresApi(api=21)
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        String key;
        String url = request.getUrl().toString();
        if (url.contains(key = "http://newimg")) {
            String imgPath = url.replace(key, "");
            if (imgPath.contains("?")) {
                imgPath = imgPath.replace(imgPath.substring(imgPath.indexOf("?")), "");
            }
            Log.d((String)"warn", (String)("\u672c\u5730\u56fe\u7247\u8def\u5f84\uff1a" + imgPath.trim()));
            try {
                FileInputStream input = new FileInputStream(new File(imgPath.trim()));
                return new WebResourceResponse("image/jpg", "UTF-8", (InputStream)input);
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
        }
        if (url.endsWith(".wasm")) {
            try {
                String[] s = url.split("/");
                url = view.getContext().getFilesDir().getAbsolutePath() + File.separator + "www/" + s[s.length - 1];
                if (new File(url).exists()) {
                    return new WebResourceResponse("application/wasm", "utf-8", (InputStream)new FileInputStream(url));
                }
                url = view.getContext().getFilesDir().getAbsolutePath() + File.separator + "www/static/" + s[s.length - 1];
                if (new File(url).exists()) {
                    return new WebResourceResponse("application/wasm", "utf-8", (InputStream)new FileInputStream(url));
                }
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
        }
        return super.shouldInterceptRequest(view, request);
    }
}

