/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.plugin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.aofeng.hybrid.plugin.AFWebView;
import com.aofeng.hybrid.plugin.JsCallNative;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.DevConfig;
import com.aofeng.hybrid.util.LogUtil;
import com.tencent.smtt.export.external.interfaces.ConsoleMessage;
import com.tencent.smtt.export.external.interfaces.JsPromptResult;
import com.tencent.smtt.export.external.interfaces.JsResult;
import com.tencent.smtt.sdk.ValueCallback;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebView;
import java.io.File;
import java.util.UUID;

public class AFChromeClient
extends WebChromeClient {
    private final String TAG = "AFChromeClient";
    private JsCallNative mStub;
    private boolean mIsInjectedJS;
    private int logLength = 3072;
    private TextView mTvLog;
    private StringBuilder sb = new StringBuilder(512);
    public static ValueCallback<Uri[]> mFilePathCallback = null;
    public static int REQUEST_CODE_LOLIPOP = 71;
    public static String mCameraPhotoPath = "";
    private Activity activity;

    public AFChromeClient(TextView logView, String injectedName, Class<?> injectedCls, Activity activity) {
        this.mTvLog = logView;
        this.activity = activity;
        this.mStub = new JsCallNative(injectedName, injectedCls);
    }

    public AFChromeClient(String injectedName, Class<?> injectedCls, Activity activity) {
        this(null, injectedName, injectedCls, activity);
    }

    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        result.confirm();
        return true;
    }

    public void onProgressChanged(WebView view, int newProgress) {
        if (newProgress <= 25) {
            this.mIsInjectedJS = false;
        } else if (!this.mIsInjectedJS) {
            CommUtil.evaluateJavascript(view, this.mStub.getPreloadInterfaceJS());
            this.mIsInjectedJS = true;
            LogUtil.d("AFChromeClient", "\u6ce8\u5165js\u8c03\u7528\u5230\u9875\u9762\u5728\u52a0\u8f7d\u5230\uff1a" + newProgress);
        }
        if (view instanceof AFWebView) {
            AFWebView pwv = (AFWebView)view;
            ProgressBar pb = pwv.getmProgressBar();
            pb.setProgress(newProgress);
            if (newProgress >= 70) {
                pb.setVisibility(8);
            } else {
                pb.setVisibility(0);
            }
        }
        super.onProgressChanged(view, newProgress);
    }

    public boolean onJsPrompt(WebView view, String url, String json, String defaultValue, JsPromptResult result) {
        String s = this.mStub.call(view, json);
        LogUtil.d("back to the webview:", s);
        result.confirm(s);
        return true;
    }

    public void debugLog(String log) {
        if (log.length() > this.logLength) {
            LogUtil.d("onConsoleMessage", log.substring(0, this.logLength));
            log = log.substring(this.logLength);
            this.debugLog(log);
        } else {
            LogUtil.d("onConsoleMessage", log);
        }
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        if (this.mTvLog != null) {
            if (this.sb.length() > 512) {
                String tmp = this.sb.substring(256);
                this.sb.setLength(0);
                this.sb.append(tmp);
            }
            this.sb.append(consoleMessage.message());
            this.sb.append("\n");
            this.mTvLog.setText((CharSequence)this.sb);
        }
        String log = consoleMessage.message();
        if (DevConfig.isAllLog()) {
            if (log.length() > this.logLength) {
                LogUtil.d("onConsoleMessage", log.substring(0, this.logLength));
                log = log.substring(this.logLength);
                this.debugLog(log);
            } else {
                LogUtil.d("onConsoleMessage", log);
            }
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        if (mFilePathCallback != null) {
            mFilePathCallback.onReceiveValue(null);
        }
        mFilePathCallback = filePathCallback;
        String[] permissions = new String[]{"android.permission.CAMERA"};
        if (ContextCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.CAMERA") == 0) {
            Intent intent = this.gotoChooseFile();
            this.activity.startActivityForResult(intent, REQUEST_CODE_LOLIPOP);
            return true;
        }
        ActivityCompat.requestPermissions((Activity)this.activity, (String[])permissions, (int)1);
        mFilePathCallback.onReceiveValue(null);
        return true;
    }

    public void openFileChooser(ValueCallback<Uri> uploadFile, String acceptType, String capture) {
    }

    private Intent gotoChooseFile() {
        String saveName = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath() + "/" + Environment.DIRECTORY_DCIM + "/Camera/";
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.activity.getPackageManager()) != null) {
            File photoFile = null;
            photoFile = new File(saveName + this.randomFileName() + ".jpg");
            if (!photoFile.exists()) {
                mCameraPhotoPath = "file:" + photoFile.getAbsolutePath();
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)photoFile));
            } else {
                takePictureIntent = null;
            }
        }
        Intent[] takeoutArray = null;
        takeoutArray = takePictureIntent != null ? new Intent[]{takePictureIntent} : new Intent[]{};
        Intent contentSelectionIntent = new Intent("android.intent.action.GET_CONTENT");
        contentSelectionIntent.addCategory("android.intent.category.OPENABLE");
        contentSelectionIntent.setType("image/*");
        Intent chooserIntent = new Intent("android.intent.action.CHOOSER");
        chooserIntent.putExtra("android.intent.extra.INTENT", (Parcelable)contentSelectionIntent);
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])takeoutArray);
        return chooserIntent;
    }

    private String randomFileName() {
        return UUID.randomUUID().toString();
    }
}

