/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.orm;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.af.util.Pair;
import com.aofeng.hybrid.android.db.QueryExecutor;
import com.aofeng.hybrid.orm.Column;
import com.aofeng.hybrid.orm.DatabaseManager;
import com.aofeng.hybrid.service.EntityService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class SqlHelper {
    public static void run(Context context, final String sql) throws Exception {
        DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                db.execSQL(sql);
                return null;
            }
        });
    }

    public static void run(Context context, final String sql, String flag) throws Exception {
        final Context icontext = context;
        DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                String[] sqlStr = sql.trim().split("\\s+");
                if ("delete".equals(sqlStr[0])) {
                    SqlHelper.runDeleteSQL(icontext, sql);
                } else if ("update".equals(sqlStr[0])) {
                    SqlHelper.runUpdateSQL(icontext, sql);
                } else {
                    db.execSQL(sql);
                }
                return null;
            }
        });
    }

    public static void runDeleteSQL(Context context, String sql) throws Exception {
        String[] sqlStr = sql.trim().split("\\s+");
        List<String> childStr = EntityService.getChildName(sqlStr[2]);
        for (String str : childStr) {
            String sqlRes = sql.replaceFirst(sqlStr[2], str);
            SqlHelper.doCascade(context, sqlRes);
            SqlHelper.runsql(context, sqlRes);
        }
        SqlHelper.doCascade(context, sql);
        SqlHelper.runsql(context, sql);
    }

    public static void runUpdateSQL(Context context, String sql) throws Exception {
        String[] sqlStr = sql.trim().split("\\s+");
        List<String> childStr = EntityService.getChildName(sqlStr[1]);
        for (String str : childStr) {
            String sqlRes = sql.replaceFirst(sqlStr[1], str);
            SqlHelper.runsql(context, sqlRes);
        }
        SqlHelper.runsql(context, sql);
    }

    public static void doCascade(Context context, String sql) {
        sql = sql.trim();
        HashMap<String, HashMap<String, Object>> metaMap = EntityService.metaMap;
        String[] sqlStr = sql.split("\\s+");
        String idnum = (String)metaMap.get(sqlStr[2]).get("idColName");
        String resql = sql.replaceFirst(sqlStr[0], "SELECT " + idnum);
        try {
            JSONArray value = SqlHelper.list(context, resql);
            if (value.length() > 0) {
                for (int j = 0; j < value.length(); ++j) {
                    JSONObject job = value.getJSONObject(j);
                    String res = job.get(idnum).toString();
                    SqlHelper.cascadeDelete(context, sqlStr[2], res);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cascadeDelete(Context context, String tableName, String idValue) throws Exception {
        HashMap<String, HashMap<String, Object>> metaMap = EntityService.metaMap;
        String idNum = (String)metaMap.get(tableName).get("idColName");
        SqlHelper.deleteFileDB(context, tableName, idValue);
        if (metaMap.containsKey(tableName)) {
            ArrayList<String> cascadeTable = new ArrayList<String>();
            HashMap cascadMap = (HashMap)metaMap.get(tableName).get("onetoone");
            cascadMap.putAll((HashMap)metaMap.get(tableName).get("onetomany"));
            if (cascadMap != null) {
                Set keys = cascadMap.keySet();
                Iterator iter = keys.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    cascadeTable.add((String)iter.next());
                    ++i;
                }
                for (String str : cascadeTable) {
                    Pair pair = (Pair)cascadMap.get(str);
                    String tableString = (String)metaMap.get(pair.col).get("tableName");
                    String tableId = (String)metaMap.get(pair.col).get("idColName");
                    String selSql = metaMap.get(pair.col).get("idType").equals("STRING") ? "SELECT " + tableId + " FROM " + tableString + " WHERE " + pair.type + "='" + idValue + "'" : "SELECT " + tableId + " FROM " + tableString + " WHERE " + pair.type + "=" + idValue;
                    try {
                        JSONArray array = SqlHelper.list(context, selSql);
                        if (array.length() <= 0) continue;
                        for (int j = 0; j < array.length(); ++j) {
                            JSONObject job = array.getJSONObject(j);
                            String res = job.get(tableId).toString();
                            String strSql = job.get(tableId) instanceof String ? "DELETE FROM " + pair.col + " WHERE " + tableId + "='" + res + "'" : "DELETE FROM " + pair.col + " WHERE " + tableId + "=" + res;
                            SqlHelper.runDeleteSQL(context, strSql);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        String delSql = metaMap.get(tableName).get("idType").equals("STRING") ? "DELETE FROM " + tableName + " WHERE " + idNum + "= '" + idValue + "'" : "DELETE FROM " + tableName + " WHERE " + idNum + "=" + idValue;
        SqlHelper.runsql(context, delSql);
    }

    public static void runsql(Context context, final String sql) throws Exception {
        DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                db.execSQL(sql);
                return null;
            }
        });
    }

    public static void deleteFileDB(Context context, String tableName, String idValue) {
        HashMap<String, HashMap<String, Object>> metaMap = EntityService.metaMap;
        Map columns = (Map)metaMap.get(tableName).get("columns");
        if (columns.containsKey("path") && columns != null) {
            String idNum = (String)metaMap.get(tableName).get("idColName");
            String selSql = "SELECT path FROM " + tableName + " WHERE " + idNum + "=" + idValue;
            try {
                JSONArray array = SqlHelper.list(context, selSql);
                if (array.length() > 0) {
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject job = array.getJSONObject(i);
                        String filePath = job.get("path").toString();
                        if (filePath == null) continue;
                        Boolean bl = SqlHelper.deleteFile(filePath);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            Boolean succeedDelete = file.delete();
            if (succeedDelete.booleanValue()) {
                System.out.println("\u5220\u9664" + filePath + "\u6210\u529f\uff01");
                return true;
            }
            System.out.println("\u5220\u9664" + filePath + "\u5931\u8d25\uff01");
            return true;
        }
        System.out.println("\u5220\u9664" + filePath + "\u5931\u8d25\uff01");
        return false;
    }

    public static JSONArray list(Context context, String sql) throws Exception {
        return SqlHelper.pagedList(context, sql, 0, 0);
    }

    public static JSONObject singleRow(Context context, final String sql) throws Exception {
        final JSONObject row = new JSONObject();
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                try (Cursor cursor = null;){
                    cursor = db.rawQuery(sql, new String[0]);
                    if (cursor.moveToNext()) {
                        for (int i = 0; i < cursor.getColumnCount(); ++i) {
                            row.put(cursor.getColumnName(i), Column.normalizeValue(cursor, i));
                        }
                    }
                    if (cursor.moveToNext()) {
                        throw new Exception("\u8fd4\u56de\u8d85\u8fc7\u4e00\u6761\u7ed3\u679c\u3002");
                    }
                    JSONObject jSONObject = row;
                    return jSONObject;
                }
            }
        });
        return (JSONObject)obj;
    }

    public static JSONArray pagedList(Context context, final String sql, final int pageNo, final int pageSize) throws Exception {
        final JSONArray array = new JSONArray();
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                try (Cursor cursor = null;){
                    String sql1 = sql;
                    if (pageSize > 0) {
                        sql1 = sql1 + " LIMIT " + pageSize + " OFFSET " + (pageNo - 1) * pageSize;
                    }
                    cursor = db.rawQuery(sql1, new String[0]);
                    while (cursor.moveToNext()) {
                        JSONObject row = new JSONObject();
                        for (int i = 0; i < cursor.getColumnCount(); ++i) {
                            row.put(cursor.getColumnName(i), Column.normalizeValue(cursor, i));
                        }
                        array.put((Object)row);
                    }
                    JSONArray jSONArray = array;
                    return jSONArray;
                }
            }
        });
        return (JSONArray)obj;
    }
}

