/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.task;

import android.os.AsyncTask;
import android.util.Log;
import com.aofeng.hybrid.activity.HybridActivity;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.util.CommUtil;
import java.lang.reflect.Method;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CardAsyncTask
extends AsyncTask<String, String, JSONObject> {
    protected HybridActivity hybridActivity;
    protected String callback;
    protected int backresult;
    protected String method;

    public CardAsyncTask(HybridActivity hybridActivity, String method, String callback, int backresult) {
        this.hybridActivity = hybridActivity;
        this.callback = callback;
        this.method = method;
        this.backresult = backresult;
    }

    protected JSONObject doInBackground(String ... params) {
        JSONObject data = null;
        try {
            data = new JSONObject();
            JSONObject json = new JSONObject(this.method);
            JSONArray array = new JSONArray(json.getString("args"));
            Class<?> c = Class.forName("com.aofeng.hybrid.pos.reader.CardAgent");
            Class[] argsClass = new Class[array.length()];
            Object[] objs = new Object[array.length()];
            JSONObject item = null;
            for (int i = 0; i < array.length(); ++i) {
                item = array.getJSONObject(i);
                item = this.resolveMethodParam(item.getString("type"), item.getString("value"));
                argsClass[i] = (Class)item.get("type");
                objs[i] = item.get("value");
            }
            Method method = c.getMethod(json.getString("name"), argsClass);
            Object back = method.invoke((Object)AFApplication.card, objs);
            JSONObject result = new JSONObject(back.toString());
            data.put("state", (Object)"ok");
            data.put("result", (Object)result.toString());
            Log.d((String)"\u8c03\u7528\u4e1a\u52a1\u8fd4\u56de\u503c", (String)data.toString());
        }
        catch (Exception e) {
            try {
                data.put("state", (Object)"nok");
                String msg = "";
                msg = e.getMessage() == null ? msg + e.getClass() : msg + e.getMessage();
                data.put("err_msg", (Object)msg);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return data;
    }

    private JSONObject resolveMethodParam(String type, String value) throws JSONException {
        JSONObject result = new JSONObject();
        if (type == null || "".equals(type.trim())) {
            throw new RuntimeException("\u914d\u7f6e\u65b9\u6cd5type\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (value == null) {
            throw new RuntimeException("\u914d\u7f6e\u65b9\u6cd5value\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        type = type.trim();
        value = value.trim();
        if (type.equals("string") || type.equals("String")) {
            result.put("type", String.class);
            result.put("value", (Object)value);
        } else if (type.equals("int") || type.equals("Integer")) {
            result.put("type", Integer.class);
            result.put("value", Integer.parseInt(value));
        } else if (type.equals("double") || type.equals("Double")) {
            result.put("type", Double.class);
            result.put("value", Double.parseDouble(value));
        } else if (type.equals("chip") || type.equals("Chip")) {
            result.put("type", Chip.class);
            result.put("value", (Object)new Chip(Integer.parseInt(value)));
        } else if (type.equals("JSONObject") || type.contains("json")) {
            result.put("type", JSONObject.class);
            result.put("value", (Object)new JSONObject(value));
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u6355\u83b7\u7684\u53c2\u6570\u7c7b\u578b!");
        }
        return result;
    }

    public void hint(String msg) {
        this.publishProgress(new String[]{msg});
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.hybridActivity.createProgressDialog(0);
        this.hybridActivity.setTitle("\u63d0\u793a");
        this.hybridActivity.setMessage("\u6b63\u5728\u5de5\u4f5c\uff0c\u8bf7\u7b49\u5f85...");
        this.hybridActivity.showProgress();
    }

    protected void onPostExecute(JSONObject result) {
        super.onPostExecute((Object)result);
        this.hybridActivity.closeProgress();
        if (this.callback != null && result != null) {
            try {
                String js = "";
                if (this.callback.contains("()")) {
                    this.callback = this.callback.substring(0, this.callback.indexOf("("));
                }
                if (result.has("params") && this.backresult == 0) {
                    js = "javascript:" + this.callback + "(" + result.getString("params") + ");";
                }
                if (this.backresult == 1) {
                    js = "javascript:" + this.callback + "(" + result.toString() + ");";
                }
                CommUtil.evaluateJavascript(HybridActivity.mWebView, js);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void onProgressUpdate(String ... values) {
        super.onProgressUpdate((Object[])values);
        this.hybridActivity.setMessage(values[0]);
    }
}

