/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.service;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.util.Log;
import androidx.annotation.Nullable;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.activity.PreludeActivity;
import com.aofeng.hybrid.android.receiver.PhoneStatus;
import com.aofeng.hybrid.android.receiver.PhoneStatusReceiver;
import com.aofeng.hybrid.android.service.AbstractService;
import com.aofeng.hybrid.android.service.Player;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.orm.SqlHelper;
import com.aofeng.hybrid.service.LogicService;
import com.aofeng.hybrid.util.AndroidIdentification;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import com.aofeng.hybrid.util.amap.LocalPointTrajectoryProcessing;
import com.aofeng.hybrid.util.common.AndroidInfoTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TickService
extends AbstractService {
    private static final int SERVICE_ID = -1001;
    private Player player;
    private boolean shouldStop = false;
    public volatile boolean idle = false;
    private Thread theThread;
    PowerManager.WakeLock wakeLock;
    private boolean loadTimerConfig = false;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private long countn = 0L;
    private static final int PENDING_REQUEST = 0;
    private StringBuilder lastLongitude = new StringBuilder();
    private StringBuilder lastLatitude = new StringBuilder();
    String CHANNEL_ONE_ID = AndroidInfoTools.getAppProcessName(PreludeActivity.context);
    String CHANNEL_ONE_NAME = "CHANNEL_ONE";
    private NotificationManager notificationManager;

    @Override
    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        Log.d((String)"TAG", (String)"onCreate()");
        this.startForegroundService();
    }

    private void startForegroundService() {
        this.notificationManager = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(this.CHANNEL_ONE_ID, (CharSequence)this.CHANNEL_ONE_NAME, 4);
            this.notificationManager.createNotificationChannel(channel);
        }
        this.startForeground(1, this.getNotification());
    }

    private Notification getNotification() {
        Notification.Builder builder = new Notification.Builder((Context)this).setContentTitle((CharSequence)"\u5b9a\u65f6\u62c9\u53d6").setContentText((CharSequence)"\u5b9a\u65f6\u62c9\u53d6\u670d\u52a1\u6b63\u5728\u8fd0\u884c...");
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setChannelId(this.CHANNEL_ONE_ID);
        }
        Notification notification = builder.build();
        return notification;
    }

    private void startAThread(final int alarmInterval) {
        this.theThread = new Thread(new Runnable(){

            @Override
            @SuppressLint(value={"InvalidWakeLockTag"})
            public void run() {
                try {
                    PowerManager powerManager = (PowerManager)TickService.this.getSystemService("power");
                    TickService.this.wakeLock = powerManager.newWakeLock(1, "alarmLock");
                    TickService.this.wakeLock.acquire();
                    TickService.this.work(alarmInterval);
                }
                finally {
                    TickService.this.wakeLock.release();
                }
            }
        });
        this.theThread.start();
        AFApplication cfr_ignored_0 = (AFApplication)this.getApplication();
        AFApplication.service = this;
    }

    private void work(int alarmInterval) {
        Date day;
        long n = 0L;
        Date preDay = day = new Date();
        File file = new File(this.getFilesDir().toString() + "/www/static/config.json");
        File file1 = new File(this.getFilesDir().toString() + "/www/static/workflow_apply.json");
        while (true) {
            try {
                while (true) {
                    if (file != null && file.exists() && !this.loadTimerConfig) {
                        this.readTimerConfig();
                    }
                    if (file1 != null && file1.exists() && CommUtil.getSharedPreference((Context)this, "f_apply_flow_names").equals("")) {
                        this.readApplyConfig();
                    }
                    if (this.shouldStop) {
                        this.stopPlayer();
                        return;
                    }
                    boolean voiceSwitch = CommUtil.getSharedPreference((Context)this, "f_voiceSwitch").equals("true");
                    LogUtil.i("voiceSwitch", String.valueOf(voiceSwitch));
                    boolean notLoggedIn = CommUtil.getSharedPreference((Context)this, "f_repairman_id").equals("x");
                    if (CommUtil.getSharedPreference((Context)this, "posReportState").toLowerCase().equals("true") && ++n % (long)AFApplication.POS_STATUS_COUNTER == 0L && !this.shouldStop) {
                        this.reportPosStatus(day, notLoggedIn);
                    }
                    if (notLoggedIn) {
                        LogUtil.e("Not logged in yet", "stay idle......");
                    } else if (!this.idle) {
                        String str;
                        LogUtil.e("cycle " + n, "start timer task");
                        if (n % (long)AFApplication.STATUS_COUNTER == 0L && !this.shouldStop) {
                            this.checkGpsEnabled();
                            day = new Date();
                            if (day.getDay() != preDay.getDay() && this.reportDailyStatus(preDay)) {
                                preDay = day;
                            }
                            if (!CommUtil.getSharedPreference((Context)this, "stopPhoneState").toLowerCase().equals("true")) {
                                this.reportMinuteStatusToLocal(day);
                            }
                        }
                        LogUtil.e("f_role_name", CommUtil.getSharedPreference((Context)this, "f_role_name"));
                        if (n % (long)(AFApplication.STATUS_COUNTER * 24) == 0L && !this.shouldStop && CommUtil.getSharedPreference((Context)this, "f_role_name").indexOf("\u9700\u8981\u5b9a\u4f4d\u4eba\u5458") != -1) {
                            this.reportMinuteStatus();
                            if (!CommUtil.getSharedPreference((Context)this, "stopPhoneState").toLowerCase().equals("true")) {
                                JSONObject phone = PhoneStatus.getPhoneStatus((Context)this, new Date());
                                phone.put("userid", (Object)CommUtil.getSharedPreference((Context)this, "f_repairman_id"));
                                phone.put("name", (Object)CommUtil.getSharedPreference((Context)this, "f_repairman_name"));
                                phone.put("address", (Object)CommUtil.getSharedPreference((Context)this, "address"));
                                phone.put("uploadTime", (Object)this.simpleDateFormat.format(new Date()));
                                HttpPost httpPost = new HttpPost(CommUtil.getSharedPreference((Context)this, "cc_base_url") + "/rs/safePosition/savePosition");
                                httpPost.setEntity((HttpEntity)new StringEntity(String.format("%s", phone), "UTF8"));
                                DefaultHttpClient httpClient = new DefaultHttpClient();
                                HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                int code = response.getStatusLine().getStatusCode();
                                LogUtil.i("\u4e0a\u4f20\u5b9e\u65f6\u4f4d\u7f6e\u4fe1\u606f\u5230redis\u7ed3\u679c----\uff01\uff01", String.valueOf(code));
                            }
                        }
                        if (!"".equals(str = CommUtil.getSharedPreference((Context)this, "timer"))) {
                            JSONArray array = new JSONArray(str);
                            JSONObject item = null;
                            for (int i = 0; i < array.length(); ++i) {
                                int times;
                                item = array.getJSONObject(i);
                                if (!item.has("used") || !item.getString("used").trim().equals("true") || !item.has("alias") || n % (long)(times = item.has("interval") && !item.isNull("interval") && !item.getString("interval").trim().equals("") ? Integer.parseInt(item.getString("interval").trim()) : 3) != 0L || this.shouldStop) continue;
                                if (!item.isNull("hasParams") && item.getString("hasParams").equals("true") && !item.isNull("paramType") && item.getString("paramType").equals("workflow_names")) {
                                    JSONObject obj = new JSONObject();
                                    obj.put("workflow_names", (Object)CommUtil.getSharedPreference((Context)this, "f_apply_flow_names"));
                                    this.invokeKnownLogicWithParam(item.getString("alias"), obj);
                                    continue;
                                }
                                this.invokeKnownLogic(item.getString("alias"), 1, voiceSwitch);
                            }
                        } else if (n % 30L == 0L && !this.shouldStop) {
                            this.invokeKnownLogic("\u5b9a\u65f6\u63d0\u53d6", 0, voiceSwitch);
                        }
                        LogUtil.e("cycle " + n, "timer task completed");
                    }
                    Thread.sleep(alarmInterval);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.stopPlayer();
                continue;
            }
            break;
        }
    }

    private void invokeKnownLogic(String aliasName, int version, boolean voiceSwitch) {
        try {
            int a;
            LogicService logicService = new LogicService((Context)this);
            boolean dinging = false;
            if (version == 0) {
                JSONObject jo = (JSONObject)logicService.run(aliasName, null);
                CommUtil.setSharedPreference((Context)this, jo);
                if (jo.has("hasNew") && jo.getInt("hasNew") == 1) {
                    dinging |= true;
                }
                if (jo.has("hasNewMsg") && jo.getInt("hasNewMsg") == 1) {
                    dinging |= true;
                }
            } else if (version == 1 && (a = ((Integer)logicService.run(aliasName, null)).intValue()) == 1) {
                dinging |= true;
            }
            if (dinging && voiceSwitch) {
                this.player.play((Context)this, R.raw.xyz);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void invokeKnownLogicWithParam(String aliasName, JSONObject param) {
        try {
            LogicService logicService = new LogicService((Context)this);
            boolean dinging = false;
            int a = (Integer)logicService.run(aliasName, param);
            if (a == 1) {
                dinging |= true;
            }
            if (dinging) {
                this.player.play((Context)this, R.raw.xyz);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkGpsEnabled() {
        PhoneStatusReceiver.getInstance((Context)this).setupGPSReceiver(!CommUtil.getSharedPreference((Context)this, "stopPhoneState").toLowerCase().equals("true"));
    }

    private void stopPlayer() {
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
    }

    private boolean reportDailyStatus(Date yesterday) {
        return true;
    }

    private void reportMinuteStatus() {
        try {
            JSONObject object = SqlHelper.singleRow((Context)this, "select * from t_phone_state order by f_realtime asc limit 0,1");
            String chaHour = LocalPointTrajectoryProcessing.TimeDiff(object.optString("f_realtime"), this.simpleDateFormat.format(new Date()));
            LogUtil.i("\u6bd4\u8f83\u5f53\u524d\u65f6\u95f4\u4e0e\u8868\u4e2d\u6700\u65e9\u8f68\u8ff9\u65f6\u95f4", "\u5f53\u524d\u65f6\u95f4" + this.simpleDateFormat.format(new Date()) + "\u8f68\u8ff9\u6700\u65e9\u65f6\u95f4\u4e3a" + object.optString("f_realtime"));
            if (Integer.parseInt(chaHour) >= 8) {
                LogUtil.i("\u5f53\u524d\u65f6\u95f4\u4e0e\u5e93\u4e2d\u6700\u65e9\u8bb0\u5f55\u7684\u65f6\u95f4\u76f8\u5dee8\u5c0f\u65f6", "\u6267\u884c\u8f68\u8ff9\u4e0a\u4f20\u64cd\u4f5c\uff0c\u5f53\u524d\u65f6\u95f4" + this.simpleDateFormat.format(new Date()) + "\u672c\u5730\u8868\u4e2d\u6700\u65e9\u8bb0\u5f55\u65f6\u95f4\u4e3a," + object.optString("f_realtime"));
                LocalPointTrajectoryProcessing.getLocalLocationStatus((Context)this);
            }
        }
        catch (Exception e) {
            LogUtil.e("reportMinuteStatus", "\u9519\u8bef:" + e.getMessage());
        }
    }

    private void reportMinuteStatusToLocal(Date timestamp) {
        ++this.countn;
        try {
            boolean isLocation;
            JSONObject pref = CommUtil.getHybridContext((Context)this);
            if (!pref.has("f_repairman_id")) {
                return;
            }
            JSONObject jo = PhoneStatus.getPhoneStatus((Context)this, timestamp);
            if (jo.getString("f_longitude").equals("0.0")) {
                jo.put("f_longitude", (Object)"0");
            }
            if (jo.getString("f_latitude").equals("0.0")) {
                jo.put("f_latitude", (Object)"0");
            }
            if (!(isLocation = this.reportLocationStatus(jo))) {
                return;
            }
            String f_user_name = pref.getString("f_repairman_name");
            String f_subcompany = pref.getString("f_subcompany");
            String f_user_id = pref.get("f_repairman_id") + "";
            jo.put("f_user_name", (Object)f_user_name);
            jo.put("f_user_id", (Object)f_user_id);
            jo.put("f_realtime", (Object)this.simpleDateFormat.format(timestamp));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:00");
            jo.put("f_datetime", (Object)sdf.format(timestamp));
            jo.put("f_period", (Object)"\u5206");
            JSONObject config = CommUtil.getHybridContext((Context)this);
            jo.put("f_subcompany", (Object)f_subcompany);
            if (MainActivity.beginGps == "\u5f00\u59cb") {
                jo.put("f_is_start", 1);
            }
            JSONObject data = new JSONObject();
            LogicService logicService = new LogicService((Context)this);
            JSONObject result = (JSONObject)logicService.run("LocalPhoneStatus", jo);
            LogUtil.i("result\u672c\u5730\u5b58\u50a8\u4f4d\u7f6e\u4fe1\u606f====\u7b2c" + this.countn + "\u6b21=>", result + "");
            if (this.countn == 1L) {
                LocalPointTrajectoryProcessing.getLocalLocationStatus((Context)this);
            }
            if (Integer.parseInt(result.getString("code")) == 200 && MainActivity.beginGps == "\u5f00\u59cb") {
                MainActivity.beginGps = "";
            }
        }
        catch (Exception e) {
            LogUtil.e("\u672c\u5730\u5e93\uff0c\u4e0a\u4f20\u5b9e\u65f6\u72b6\u6001\u9519\u8bef", e.toString());
            LogUtil.e("\u5b89\u68c0\u5458\u72b6\u6001", "\u4e0a\u4f20\u5b9e\u65f6\u72b6\u6001\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u3002");
        }
    }

    public boolean reportLocationStatus(JSONObject jo) {
        try {
            if (this.lastLatitude.toString().isEmpty() || this.lastLongitude.toString().isEmpty()) {
                this.lastLongitude.replace(0, this.lastLongitude.length(), "0");
                this.lastLatitude.replace(0, this.lastLatitude.length(), "0");
            }
            if (jo.getString("f_longitude").equals("0") || jo.getString("f_latitude").equals("0")) {
                return false;
            }
            if (jo.getString("f_longitude").toString().equals(this.lastLongitude.toString()) && jo.getString("f_latitude").toString().equals(this.lastLatitude.toString())) {
                LogUtil.i("\u4e0e\u4e0a\u6b21\u7684\u7ecf\u7eac\u5ea6\u4e00\u81f4\uff0c\u53d6\u6d88\u672c\u6b21\u4fdd\u5b58", "\u4e0a\u6b21\u7684\u503c\u4e3a\uff1a\u7ecf\u5ea6\uff1a" + this.lastLongitude.toString() + "\uff0c\u7eac\u5ea6\uff1a" + this.lastLatitude.toString());
                LogUtil.i("\u4e0e\u4e0a\u6b21\u7684\u7ecf\u7eac\u5ea6\u4e00\u81f4\uff0c\u53d6\u6d88\u672c\u6b21\u4fdd\u5b58", "\u672c\u6b21\u7684\u503c\u4e3a\uff1a\u7ecf\u5ea6\uff1a" + jo.getString("f_longitude") + "\uff0c\u7eac\u5ea6\uff1a" + jo.getString("f_latitude"));
                return false;
            }
            this.lastLongitude.replace(0, this.lastLongitude.length(), jo.getString("f_longitude"));
            this.lastLatitude.replace(0, this.lastLatitude.length(), jo.getString("f_latitude"));
            return true;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String getSN(Context context) {
        if (!"true".equals(CommUtil.getSharedPreference(context, "pos").toLowerCase())) {
            return AndroidIdentification.getUniqueId();
        }
        if (AFApplication.device == null) {
            try {
                AFApplication.initPos(context);
            }
            catch (Exception e) {
                Log.e((String)"error", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
            }
        }
        return AFApplication.device.getSN();
    }

    private void reportPosStatus(Date day, Boolean notLoggedIn) {
        LogUtil.i("reportPosStatus", "\u51c6\u5907\u4e0a\u4f20pos\u72b6\u6001\u3002");
        try {
            JSONObject posStatus = new JSONObject();
            posStatus.put("f_terminal_number", (Object)this.getSN((Context)this));
            posStatus.put("f_battery_level", (Object)String.valueOf(PhoneStatus.getBatteryLevel((Context)this)));
            posStatus.put("f_is_login", (Object)String.valueOf(notLoggedIn == false));
            posStatus.put("f_hybrid_version", (Object)CommUtil.getSharedPreference((Context)this, "f_hybrid_version"));
            posStatus.put("f_appVer", (Object)CommUtil.getSharedPreference((Context)this, "f_appVer"));
            posStatus.put("f_report_date", (Object)this.simpleDateFormat.format(day));
            HttpPost httpPost = new HttpPost(CommUtil.getSharedPreference((Context)this, "cc_base_url") + "/rs/logic/PosStatus");
            httpPost.setEntity((HttpEntity)new StringEntity(String.format("%s", posStatus.toString()), "UTF8"));
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogUtil.e("pos\u72b6\u6001", "\u4e0a\u4f20pos\u72b6\u6001\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u3002");
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.e((String)"MyService", (String)("Received start id " + startId + ": " + intent));
        if (Build.VERSION.SDK_INT < 18) {
            this.startForeground(-1001, new Notification());
        } else {
            Intent innerIntent = new Intent((Context)this, TickShadowService.class);
            if (Build.VERSION.SDK_INT >= 26) {
                this.startForegroundService(innerIntent);
            } else {
                this.startService(innerIntent);
                this.startForeground(-1001, new Notification());
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private void readTimerConfig() throws IOException {
        LogUtil.e("\u65b0\u5efaservice\u5bf9\u8c61", "\u521b\u5efa\u670d\u52a1\u5bf9\u8c61\u5e76\u542f\u52a8\u670d\u52a1");
        try (BufferedReader reader = null;){
            File file = new File(this.getFilesDir().toString() + "/www/static/config.json");
            if (file != null && file.exists()) {
                String mLine;
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String str = "";
                while ((mLine = reader.readLine()) != null) {
                    str = str + mLine;
                }
                if (!"".equals(str)) {
                    JSONObject json = new JSONObject(str);
                    Iterator keys = json.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        Object value = json.get(key);
                        if (value instanceof String) {
                            CommUtil.setSharedPreference((Context)this, key, (String)value);
                            continue;
                        }
                        if (!(value instanceof JSONArray)) continue;
                        str = TickService.toString((JSONArray)value);
                        CommUtil.setSharedPreference((Context)this, key, str);
                    }
                }
                this.loadTimerConfig = true;
            }
        }
    }

    private void readApplyConfig() throws IOException {
        try (BufferedReader reader = null;){
            File file = new File(this.getFilesDir().toString() + "/www/static/workflow_apply.json");
            if (file != null && file.exists()) {
                String mLine;
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String str = "";
                while ((mLine = reader.readLine()) != null) {
                    str = str + mLine;
                }
                if (!"".equals(str)) {
                    JSONArray array = new JSONArray(new JSONObject(str).getString("activitys"));
                    JSONObject item = null;
                    StringBuffer sb = new StringBuffer("");
                    for (int i = 0; i < array.length(); ++i) {
                        item = array.getJSONObject(i);
                        if (item.isNull("mobile") || !"true".equals(item.getString("mobile").toLowerCase())) continue;
                        if (sb.toString().length() <= 0) {
                            sb.append("'" + item.getString("title") + "'");
                            continue;
                        }
                        sb.append(",'" + item.getString("title") + "'");
                    }
                    CommUtil.setSharedPreference((Context)this, "f_apply_flow_names", sb.toString());
                }
            }
        }
    }

    @Override
    public void onStartService() {
        LogUtil.e("\u65b0\u5efaservice\u5bf9\u8c61", "\u521b\u5efa\u670d\u52a1\u5bf9\u8c61\u5e76\u542f\u52a8\u670d\u52a1");
        this.player = new Player();
        this.startAThread(AFApplication.BASE_INTERVAL);
    }

    private static String toString(JSONArray array) {
        String result = "";
        for (int i = 0; i < array.length(); ++i) {
            if (!result.equals("")) {
                result = result + ",";
            }
            try {
                String s = array.getString(i);
                result = result + s.toString();
                continue;
            }
            catch (JSONException var4) {
                throw new RuntimeException(var4);
            }
        }
        result = "[" + result + "]";
        return result;
    }

    @Override
    public void onStopService() {
        this.stopPlayer();
        this.shouldStop = true;
        this.loadTimerConfig = false;
        AFApplication cfr_ignored_0 = (AFApplication)this.getApplication();
        AFApplication.service = null;
    }

    public void mute() {
        this.player.stop();
    }

    @Override
    public void onReceiveMessage(Message msg) {
    }

    public static class TickShadowService
    extends Service {
        String CHANNEL_ONE_ID = AndroidInfoTools.getAppProcessName(PreludeActivity.context) + "2";
        String CHANNEL_ONE_NAME = "CHANNEL_TWO";
        private NotificationManager notificationManager;

        public void onCreate() {
            super.onCreate();
            Log.d((String)"TAG", (String)"onCreate()");
            this.startForegroundService();
        }

        private void startForegroundService() {
            this.notificationManager = (NotificationManager)this.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                NotificationChannel channel = new NotificationChannel(this.CHANNEL_ONE_ID, (CharSequence)this.CHANNEL_ONE_NAME, 4);
                this.notificationManager.createNotificationChannel(channel);
            }
            this.startForeground(2, this.getNotification());
        }

        private Notification getNotification() {
            Notification.Builder builder = new Notification.Builder((Context)this).setContentTitle((CharSequence)"\u5b9a\u65f6\u62c9\u53d62").setContentText((CharSequence)"\u5b9a\u65f6\u62c9\u53d62\u670d\u52a1\u6b63\u5728\u8fd0\u884c...");
            if (Build.VERSION.SDK_INT >= 26) {
                builder.setChannelId(this.CHANNEL_ONE_ID);
            }
            Notification notification = builder.build();
            return notification;
        }

        public int onStartCommand(Intent intent, int flags, int startId) {
            this.startForeground(-1001, new Notification());
            this.stopForeground(true);
            this.stopSelf();
            return super.onStartCommand(intent, flags, startId);
        }

        @Nullable
        public IBinder onBind(Intent intent) {
            return null;
        }
    }
}

