/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.peripheral;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.android.sign.SignatureView;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.common.AndroidInfoTools;
import java.io.File;
import org.json.JSONObject;

public class SignActivity
extends Activity {
    private String fileName;
    private SignatureView signPad;
    private String callback;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String SCREEN_ORIENTATION = CommUtil.getSharedPreference((Context)this, "SCREEN_ORIENTATION");
        if (SCREEN_ORIENTATION.equals("0")) {
            this.setRequestedOrientation(6);
        } else if (SCREEN_ORIENTATION.equals("2")) {
            this.setRequestedOrientation(0);
        } else {
            this.setRequestedOrientation(1);
        }
        if (SCREEN_ORIENTATION.equals("1")) {
            this.setContentView(R.layout.signshu);
        } else {
            this.setContentView(R.layout.sign);
        }
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        try {
            Bundle bundle = intent.getExtras();
            JSONObject jo = new JSONObject(bundle.getString("param"));
            this.fileName = AndroidInfoTools.getSafecheckDirectory((Context)this) + File.separator + jo.getString("file");
            this.callback = jo.getString("callback");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.signPad = (SignatureView)this.findViewById(R.id.signPad);
        File file = new File(this.fileName);
        if (file.exists()) {
            file.delete();
        }
        Button btnClear = (Button)this.findViewById(R.id.button_clear);
        btnClear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SignActivity.this.signPad = (SignatureView)SignActivity.this.findViewById(R.id.signPad);
                SignActivity.this.signPad.setCanvasCode(0);
                SignActivity.this.signPad.reset();
                SignActivity.this.signPad.setCanvasCode(1);
                File file = new File(SignActivity.this.fileName);
                file.delete();
            }
        });
        Button btnReturn = (Button)this.findViewById(R.id.button_return);
        btnReturn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SignActivity.this.goBack();
                SignActivity.this.finish();
            }
        });
    }

    public void onBackPressed() {
        this.goBack();
        super.onBackPressed();
    }

    private void goBack() {
        this.signPad.saveBiography(this.fileName);
        File file = new File(this.fileName);
        if (file.exists()) {
            Intent intent = new Intent();
            String httpImg = CommUtil.getSharedPreference((Context)this, "httpImg");
            if ("".equals(httpImg)) {
                intent.putExtra("callback", String.format(this.callback, "file://" + this.fileName));
            } else {
                intent.putExtra("callback", String.format(this.callback, "http://newimg" + this.fileName));
            }
            this.setResult(-1, intent);
        } else {
            this.setResult(0);
        }
    }
}

