/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.peripheral;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ScrubblePane
extends View {
    float preX;
    float preY;
    public String url;
    ArrayList<Path> paths = new ArrayList();
    Path path;
    boolean dirty;
    private static final int STROKE_WIDTH = 5;
    private int w;
    private int h;

    public ScrubblePane(Context context, AttributeSet set) {
        super(context, set);
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.dirty = true;
                this.path = new Path();
                this.path.moveTo(x, y);
                this.preX = x;
                this.preY = y;
                break;
            }
            case 2: {
                this.path.quadTo(this.preX, this.preY, x, y);
                this.preX = x;
                this.preY = y;
                break;
            }
            case 1: {
                this.paths.add(this.path);
            }
        }
        this.invalidate();
        return true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.w = w;
        this.h = h;
    }

    public void onDraw(Canvas canvas) {
        Paint paint = new Paint();
        paint.setColor(-1);
        canvas.drawRect(0.0f, 0.0f, (float)this.w, (float)this.h, paint);
        paint.setColor(-16776961);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(5.0f);
        paint.setAntiAlias(true);
        paint.setDither(true);
        for (Path path : this.paths) {
            canvas.drawPath(path, paint);
        }
    }

    public Bitmap getBitmapThumbnail(String path, int width, int height) {
        Bitmap bitmap = null;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts);
        opts.inSampleSize = Math.min((int)((float)opts.outHeight / (float)height), (int)((float)opts.outWidth / (float)width));
        opts.inJustDecodeBounds = false;
        bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts);
        return bitmap;
    }

    public void clearPane() {
        this.paths.clear();
        this.url = null;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBiography(String id2) {
        if (!this.dirty) {
            return;
        }
        FileOutputStream out = null;
        File target = new File(id2);
        Bitmap bt = Bitmap.createBitmap((int)this.w, (int)this.h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas();
        canvas.setBitmap(bt);
        this.draw(canvas);
        try {
            out = new FileOutputStream(target);
            bt.compress(Bitmap.CompressFormat.PNG, 50, (OutputStream)out);
            bt.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

