/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.peripheral;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.common.AndroidInfoTools;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.json.JSONObject;

public class CameraActivity
extends Activity {
    private String callback;
    private String fileName;
    private static final int JPEG_SIZE = 500;
    private final String[] permissions = new String[]{"android.permission.CAMERA"};

    protected void onCreate(Bundle savedInstanceState) {
        Intent intent;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.camera);
        if (Build.VERSION.SDK_INT >= 23) {
            this.checkPermission();
        }
        if ((intent = this.getIntent()) == null) {
            return;
        }
        try {
            Bundle bundle = intent.getExtras();
            JSONObject jo = new JSONObject(bundle.getString("param"));
            this.fileName = AndroidInfoTools.getSafecheckDirectory((Context)this) + File.separator + jo.getString("file");
            File file = new File(this.fileName);
            Uri uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)this, (String)(AndroidInfoTools.getAppProcessName((Context)this) + ".provider"), (File)file) : Uri.fromFile((File)file);
            intent = new Intent("android.media.action.IMAGE_CAPTURE");
            intent.putExtra("output", (Parcelable)uri);
            this.callback = jo.getString("callback");
            this.startActivityForResult(intent, jo.getInt("requestCode"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkPermission() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])this.permissions, (int)1);
        } else {
            Log.i((String)"tag", (String)"\u5df2\u7533\u8bf7\u6743\u9650");
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        block0 : switch (requestCode) {
            case 1: {
                if (grantResults.length == this.permissions.length) {
                    for (int result : grantResults) {
                        if (result == 0) continue;
                        Log.d((String)"tag", (String)"onRequestPermissionsResult: \u8bf7\u6c42\u6743\u9650\u88ab\u62d2\u7edd");
                        break block0;
                    }
                    break;
                }
                Log.d((String)"TAG", (String)"onRequestPermissionsResult: \u5df2\u6388\u6743");
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            try {
                Intent intent = new Intent();
                this.touchImage(1024, 600);
                String httpImg = CommUtil.getSharedPreference((Context)this, "httpImg");
                if ("".equals(httpImg)) {
                    intent.putExtra("callback", String.format(this.callback, "file://" + this.fileName));
                } else {
                    intent.putExtra("callback", String.format(this.callback, "http://newimg" + this.fileName));
                }
                this.setResult(-1, intent);
                this.finish();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setResult(0);
                this.finish();
            }
        } else {
            this.setResult(0);
            this.finish();
        }
    }

    public void touchImage(int reqWidth, int reqHeight) throws Exception {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)this.fileName, (BitmapFactory.Options)options).copy(Bitmap.Config.ARGB_8888, true);
        this.compressImage(bitmap, 500);
    }

    public void compressImage(Bitmap image, int imageSize) throws Exception {
        int options;
        this.DrawWatermark(image);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String needCompressed = CommUtil.getSharedPreference((Context)this, "needCompressed").toLowerCase();
        image.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
        if (options != 100) {
            for (options = needCompressed.equals("") || needCompressed.equals("true") ? 30 : 100; baos.toByteArray().length / 1024 > imageSize && options > 10; options -= 5) {
                int size = baos.toByteArray().length / 1024;
                baos.reset();
                image.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
                Log.d((String)"CameraActivity", (String)("compression ratio:" + options + ", size:" + size));
            }
        }
        FileOutputStream out = new FileOutputStream(this.fileName);
        out.write(baos.toByteArray());
        out.flush();
        out.close();
        baos.close();
    }

    private void DrawWatermark(Bitmap src) throws Exception {
        int h = src.getHeight();
        int w = src.getWidth();
        int TextinitSize = 20;
        int OFFSET_TOP = h / 2;
        int OFFSET_LEFT = 0;
        float ratioWidth = (float)w / 480.0f;
        float ratioHeight = (float)h / 800.0f;
        Resources resources = this.getResources();
        float scale = resources.getDisplayMetrics().density;
        float RATIO = Math.min(ratioWidth, ratioHeight);
        int TEXT_SIZE = Math.round((float)TextinitSize * RATIO);
        Canvas canvas = new Canvas(src);
        Intent intent = this.getIntent();
        Bundle bundle = intent.getExtras();
        JSONObject jo = new JSONObject(bundle.getString("param"));
        String[] lines = jo.getString("watermark").split("\t");
        OFFSET_LEFT = TextinitSize;
        OFFSET_TOP = Math.round((float)h - (float)TextinitSize * RATIO * (float)lines.length);
        Paint paint = new Paint(1);
        paint.setColor(0);
        paint.setAlpha(50);
        paint.setTextSize((float)TEXT_SIZE);
        paint.setAntiAlias(true);
        paint.setFakeBoldText(true);
        paint.setColor(-16776961);
        for (String line : lines) {
            canvas.drawText(line, (float)OFFSET_LEFT, (float)OFFSET_TOP, paint);
            OFFSET_TOP += Math.round((float)TextinitSize * RATIO);
        }
    }

    private int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }
}

