/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.peripheral;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.hardware.Camera;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.pos.device.CTDevice;
import com.centerm.smartpos.aidl.qrscan.AidlScanCallback;
import com.centerm.smartpos.aidl.qrscan.CameraBeanZbar;
import java.util.HashMap;
import org.json.JSONObject;

public class AutoQuickScanActivity
extends Activity {
    private Camera camera;
    private boolean cameraBack;
    private boolean isBigScreen = false;
    private boolean changeScreen = false;
    private int bigSize = 9604;
    private int bestWidth = 640;
    private int bestHeight = 480;
    private int spinDegree = 90;
    private static final int bigScreenWidth = 1024;
    private static final int bigScreenHeight = 768;
    private static final int bigerScreenWidth = 1280;
    private static final int bigerScreenHeight = 800;
    private final int currentApiVersion = Build.VERSION.SDK_INT;
    private int systemVersion;
    public static String codeStr;
    private String FrontCamera = "";
    private String callback;
    private TextView message;
    private TextView authorCode;
    private int indexCamera;
    @SuppressLint(value={"HandlerLeak"})
    private final Handler myHandlers = new Handler(){

        @SuppressLint(value={"SetTextI18n"})
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (1 == msg.what) {
                Toast.makeText((Context)AutoQuickScanActivity.this, (CharSequence)msg.obj.toString(), (int)0).show();
            } else if (0 == msg.what) {
                Toast.makeText((Context)AutoQuickScanActivity.this, (CharSequence)("\u6253\u5f00\u626b\u7801\u63a5\u53e3\u5931\u8d25:" + msg.obj.toString()), (int)0).show();
            } else if (2 == msg.what) {
                Toast.makeText((Context)AutoQuickScanActivity.this, (CharSequence)"\u626b\u7801\u5931\u8d25\u6216\u672a\u626b\u7801", (int)0).show();
                AutoQuickScanActivity.this.message.setText((CharSequence)"\u626b\u7801\u5931\u8d25\u6216\u672a\u626b\u7801");
                AutoQuickScanActivity.this.handleDecode("");
            } else if (3 == msg.what) {
                Toast.makeText((Context)AutoQuickScanActivity.this, (CharSequence)"\u626b\u7801\u6210\u529f", (int)0).show();
                AutoQuickScanActivity.this.message.setText((CharSequence)"\u626b\u7801\u6210\u529f\uff0c\u7ed3\u679c\u5982\u4e0b");
                AutoQuickScanActivity.this.authorCode.setText((CharSequence)("" + msg.obj.toString()));
                AutoQuickScanActivity.this.handleDecode(msg.obj.toString());
            }
        }
    };
    private String[] permissions = new String[]{"android.permission.CAMERA"};

    protected void onCreate(Bundle savedInstanceState) {
        Intent intent;
        super.setContentView(R.layout.aotu_quickscan_activity);
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 23) {
            this.checkPermission();
        }
        if ((intent = this.getIntent()) == null) {
            return;
        }
        try {
            Bundle bundle = intent.getExtras();
            if (bundle == null) {
                return;
            }
            JSONObject jo = new JSONObject(bundle.getString("param"));
            this.callback = jo.getString("callback");
            if (jo.has("frontCamera")) {
                this.FrontCamera = jo.getString("frontCamera");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        WindowManager windowManager = this.getWindowManager();
        Display display = windowManager.getDefaultDisplay();
        int screenWidth = display.getWidth();
        int screenHeight = display.getHeight();
        if (screenWidth >= 1024 && screenHeight >= 768) {
            this.isBigScreen = true;
            if (this.changeScreen) {
                this.bestWidth = screenWidth;
                this.bestHeight = screenHeight;
            } else {
                this.spinDegree = 0;
            }
        }
        if (this.isBigScreen) {
            if (screenWidth == 1280 && screenHeight == 800) {
                this.bigSize = this.currentApiVersion == 17 ? 9605 : 9604;
            } else if (screenWidth == 1024 && screenHeight == 768) {
                this.systemVersion = Integer.parseInt((String)Build.BRAND.subSequence(0, 1));
                this.bigSize = this.systemVersion == 5 ? 9505 : 9506;
            }
        }
        AutoQuickScanActivity autoQuickScanActivity = this;
        if (autoQuickScanActivity.camera.getNumberOfCameras() < 2) {
            if (this.FindBackCamera() == -1 && this.FindFrontCamera() == -1) {
                Toast.makeText((Context)this, (CharSequence)"\u672a\u68c0\u6d4b\u5230\u6444\u50cf\u5934\uff0c\u626b\u7801\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528\uff0c\u6309\u952e\u5c06\u4e0d\u53ef\u70b9\u51fb\uff0c\u8bf7\u8fd4\u56de", (int)1).show();
                return;
            }
            if (this.FindBackCamera() == -1) {
                this.indexCamera = this.bigSize == 9605 || this.bigSize == 9505 ? 0 : 1;
            } else if (this.FindFrontCamera() == -1) {
                this.indexCamera = this.bigSize == 9605 || this.bigSize == 9505 ? 1 : 0;
            }
        } else {
            this.indexCamera = "true".equals(this.FrontCamera.toLowerCase()) ? 1 : 0;
        }
        this.message = (TextView)this.findViewById(R.id.message);
        this.authorCode = (TextView)this.findViewById(R.id.authorCode);
        this.message.setText((CharSequence)"\u6b63\u5728\u6253\u5f00\u6444\u50cf\u5934\uff0c\u8bf7\u7a0d\u7b49");
    }

    protected void onResume() {
        super.onResume();
        this.stsartFastScan();
    }

    public void handleDecode(String result) {
        codeStr = "";
        if (!"".equals(result.trim())) {
            codeStr = result;
            Intent intent = new Intent();
            intent.putExtra("callback", this.callback);
            this.setResult(-1, intent);
        } else {
            this.setResult(0);
        }
        this.finish();
    }

    private int FindFrontCamera() {
        int cameraCount = 0;
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        cameraCount = Camera.getNumberOfCameras();
        for (int camIdx = 0; camIdx < cameraCount; ++camIdx) {
            Camera.getCameraInfo((int)camIdx, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != 1) continue;
            return camIdx;
        }
        return -1;
    }

    private int FindBackCamera() {
        int cameraCount = 0;
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        cameraCount = Camera.getNumberOfCameras();
        for (int camIdx = 0; camIdx < cameraCount; ++camIdx) {
            Camera.getCameraInfo((int)camIdx, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return camIdx;
        }
        return -1;
    }

    public void stsartFastScan() {
        try {
            CameraBeanZbar cameraBean = new CameraBeanZbar(this.indexCamera, this.bestWidth, this.bestHeight, 4, 60000L, this.spinDegree, 1);
            cameraBean.setCameraId(this.indexCamera);
            HashMap<String, Boolean> externalMap = new HashMap<String, Boolean>();
            externalMap.put("ShowPreview", true);
            cameraBean.setExternalMap(externalMap);
            CTDevice.aidlQuickScanService.scanQRCode(cameraBean, (AidlScanCallback)new AidlScanCallback.Stub(){

                public void onFailed(int arg0) throws RemoteException {
                    Message msg = new Message();
                    msg.what = 2;
                    AutoQuickScanActivity.this.myHandlers.sendMessage(msg);
                }

                public void onCaptured(String arg0, int arg1) throws RemoteException {
                    Message msg = new Message();
                    msg.what = 3;
                    msg.obj = arg0;
                    AutoQuickScanActivity.this.myHandlers.sendMessage(msg);
                }
            });
        }
        catch (Exception e) {
            Message msg = new Message();
            msg.what = 0;
            msg.obj = e.getMessage();
            this.myHandlers.sendMessage(msg);
        }
    }

    public void checkPermission() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])this.permissions, (int)1);
        } else {
            Log.i((String)"tag", (String)"\u5df2\u7533\u8bf7\u6743\u9650");
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        block0 : switch (requestCode) {
            case 1: {
                if (grantResults.length == this.permissions.length) {
                    for (int result : grantResults) {
                        if (result == 0) continue;
                        Log.d((String)"tag", (String)"onRequestPermissionsResult: \u8bf7\u6c42\u6743\u9650\u88ab\u62d2\u7edd");
                        break block0;
                    }
                    break;
                }
                Log.d((String)"TAG", (String)"onRequestPermissionsResult: \u5df2\u6388\u6743");
            }
        }
    }
}

