/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util.amap;

import com.amap.api.maps.AMapUtils;
import com.amap.api.maps.model.LatLng;
import java.util.ArrayList;
import java.util.List;

public class PathSmoothTool {
    private int mIntensity = 3;
    private float mThreshhold = 0.3f;
    private float mNoiseThreshhold = 10.0f;
    private double lastLocation_x;
    private double currentLocation_x;
    private double lastLocation_y;
    private double currentLocation_y;
    private double estimate_x;
    private double estimate_y;
    private double pdelt_x;
    private double pdelt_y;
    private double mdelt_x;
    private double mdelt_y;
    private double gauss_x;
    private double gauss_y;
    private double kalmanGain_x;
    private double kalmanGain_y;
    private double m_R = 0.0;
    private double m_Q = 0.0;

    public int getIntensity() {
        return this.mIntensity;
    }

    public void setIntensity(int mIntensity) {
        this.mIntensity = mIntensity;
    }

    public float getThreshhold() {
        return this.mThreshhold;
    }

    public void setThreshhold(float mThreshhold) {
        this.mThreshhold = mThreshhold;
    }

    public void setNoiseThreshhold(float mnoiseThreshhold) {
        this.mNoiseThreshhold = mnoiseThreshhold;
    }

    public List<LatLng> pathOptimize(List<LatLng> originlist) {
        List<LatLng> list = this.removeNoisePoint(originlist);
        List<LatLng> afterList = this.kalmanFilterPath(list, this.mIntensity);
        List<LatLng> pathoptimizeList = this.reducerVerticalThreshold(afterList, this.mThreshhold);
        return pathoptimizeList;
    }

    public List<LatLng> kalmanFilterPath(List<LatLng> originlist) {
        return this.kalmanFilterPath(originlist, this.mIntensity);
    }

    public List<LatLng> removeNoisePoint(List<LatLng> originlist) {
        return this.reduceNoisePoint(originlist, this.mNoiseThreshhold);
    }

    public LatLng kalmanFilterPoint(LatLng lastLoc, LatLng curLoc) {
        return this.kalmanFilterPoint(lastLoc, curLoc, this.mIntensity);
    }

    public List<LatLng> reducerVerticalThreshold(List<LatLng> inPoints) {
        return this.reducerVerticalThreshold(inPoints, this.mThreshhold);
    }

    private List<LatLng> kalmanFilterPath(List<LatLng> originlist, int intensity) {
        ArrayList<LatLng> kalmanFilterList = new ArrayList<LatLng>();
        if (originlist == null || originlist.size() <= 2) {
            return kalmanFilterList;
        }
        this.initial();
        LatLng latLng = null;
        LatLng lastLoc = originlist.get(0);
        kalmanFilterList.add(lastLoc);
        for (int i = 1; i < originlist.size(); ++i) {
            LatLng curLoc = originlist.get(i);
            latLng = this.kalmanFilterPoint(lastLoc, curLoc, intensity);
            if (latLng == null) continue;
            kalmanFilterList.add(latLng);
            lastLoc = latLng;
        }
        return kalmanFilterList;
    }

    private LatLng kalmanFilterPoint(LatLng lastLoc, LatLng curLoc, int intensity) {
        if (this.pdelt_x == 0.0 || this.pdelt_y == 0.0) {
            this.initial();
        }
        LatLng kalmanLatlng = null;
        if (lastLoc == null || curLoc == null) {
            return kalmanLatlng;
        }
        if (intensity < 1) {
            intensity = 1;
        } else if (intensity > 5) {
            intensity = 5;
        }
        for (int j = 0; j < intensity; ++j) {
            curLoc = kalmanLatlng = this.kalmanFilter(lastLoc.longitude, curLoc.longitude, lastLoc.latitude, curLoc.latitude);
        }
        return kalmanLatlng;
    }

    private void initial() {
        this.pdelt_x = 0.001;
        this.pdelt_y = 0.001;
        this.mdelt_x = 5.698402909980532E-4;
        this.mdelt_y = 5.698402909980532E-4;
    }

    private LatLng kalmanFilter(double oldValue_x, double value_x, double oldValue_y, double value_y) {
        this.lastLocation_x = oldValue_x;
        this.currentLocation_x = value_x;
        this.gauss_x = Math.sqrt(this.pdelt_x * this.pdelt_x + this.mdelt_x * this.mdelt_x) + this.m_Q;
        this.kalmanGain_x = Math.sqrt(this.gauss_x * this.gauss_x / (this.gauss_x * this.gauss_x + this.pdelt_x * this.pdelt_x)) + this.m_R;
        this.estimate_x = this.kalmanGain_x * (this.currentLocation_x - this.lastLocation_x) + this.lastLocation_x;
        this.mdelt_x = Math.sqrt((1.0 - this.kalmanGain_x) * this.gauss_x * this.gauss_x);
        this.lastLocation_y = oldValue_y;
        this.currentLocation_y = value_y;
        this.gauss_y = Math.sqrt(this.pdelt_y * this.pdelt_y + this.mdelt_y * this.mdelt_y) + this.m_Q;
        this.kalmanGain_y = Math.sqrt(this.gauss_y * this.gauss_y / (this.gauss_y * this.gauss_y + this.pdelt_y * this.pdelt_y)) + this.m_R;
        this.estimate_y = this.kalmanGain_y * (this.currentLocation_y - this.lastLocation_y) + this.lastLocation_y;
        this.mdelt_y = Math.sqrt((1.0 - this.kalmanGain_y) * this.gauss_y * this.gauss_y);
        LatLng latlng = new LatLng(this.estimate_y, this.estimate_x);
        return latlng;
    }

    private List<LatLng> reducerVerticalThreshold(List<LatLng> inPoints, float threshHold) {
        if (inPoints == null) {
            return null;
        }
        if (inPoints.size() <= 2) {
            return inPoints;
        }
        ArrayList<LatLng> ret = new ArrayList<LatLng>();
        for (int i = 0; i < inPoints.size(); ++i) {
            LatLng pre = PathSmoothTool.getLastLocation(ret);
            LatLng cur = inPoints.get(i);
            if (pre == null || i == inPoints.size() - 1) {
                ret.add(cur);
                continue;
            }
            LatLng next = inPoints.get(i + 1);
            double distance = PathSmoothTool.calculateDistanceFromPoint(cur, pre, next);
            if (!(distance > (double)threshHold)) continue;
            ret.add(cur);
        }
        return ret;
    }

    private static LatLng getLastLocation(List<LatLng> oneGraspList) {
        if (oneGraspList == null || oneGraspList.size() == 0) {
            return null;
        }
        int locListSize = oneGraspList.size();
        LatLng lastLocation = oneGraspList.get(locListSize - 1);
        return lastLocation;
    }

    private static double calculateDistanceFromPoint(LatLng p, LatLng lineBegin, LatLng lineEnd) {
        double yy;
        double xx;
        double A = p.longitude - lineBegin.longitude;
        double C = lineEnd.longitude - lineBegin.longitude;
        double B = p.latitude - lineBegin.latitude;
        double D = lineEnd.latitude - lineBegin.latitude;
        double dot = A * C + B * D;
        double len_sq = C * C + D * D;
        double param = dot / len_sq;
        if (param < 0.0 || lineBegin.longitude == lineEnd.longitude && lineBegin.latitude == lineEnd.latitude) {
            xx = lineBegin.longitude;
            yy = lineBegin.latitude;
        } else if (param > 1.0) {
            xx = lineEnd.longitude;
            yy = lineEnd.latitude;
        } else {
            xx = lineBegin.longitude + param * C;
            yy = lineBegin.latitude + param * D;
        }
        return AMapUtils.calculateLineDistance((LatLng)p, (LatLng)new LatLng(yy, xx));
    }

    private List<LatLng> reduceNoisePoint(List<LatLng> inPoints, float threshHold) {
        if (inPoints == null) {
            return null;
        }
        if (inPoints.size() <= 2) {
            return inPoints;
        }
        ArrayList<LatLng> ret = new ArrayList<LatLng>();
        for (int i = 0; i < inPoints.size(); ++i) {
            LatLng pre = PathSmoothTool.getLastLocation(ret);
            LatLng cur = inPoints.get(i);
            if (pre == null || i == inPoints.size() - 1) {
                ret.add(cur);
                continue;
            }
            LatLng next = inPoints.get(i + 1);
            double distance = PathSmoothTool.calculateDistanceFromPoint(cur, pre, next);
            if (!(distance < (double)threshHold)) continue;
            ret.add(cur);
        }
        return ret;
    }
}

