/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.support.annotation.NonNull;
import com.aofeng.hybrid.util.MyTrustManager;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class OkhttpUtil {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType JSON2 = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
    private static final OkHttpClient mOkHttpClient;
    private static final String CHARSET_NAME = "UTF-8";

    private static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new MyTrustManager()}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ssfFactory;
    }

    public static Response execute(Request request) throws IOException {
        return mOkHttpClient.newCall(request).execute();
    }

    public static void enqueue(Request request, Callback responseCallback) {
        mOkHttpClient.newCall(request).enqueue(responseCallback);
    }

    public static void enqueue(Request request) {
        mOkHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) {
            }
        });
    }

    public static String getStringFromServer(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response response = OkhttpUtil.execute(request);
        if (response.isSuccessful()) {
            return response.body().string();
        }
        throw new IOException("Unexpected code " + response);
    }

    public static String formatParams(List<BasicNameValuePair> params) {
        return URLEncodedUtils.format(params, (String)CHARSET_NAME);
    }

    public static String attachHttpGetParams(String url, List<BasicNameValuePair> params) {
        return url + "?" + OkhttpUtil.formatParams(params);
    }

    public static String attachHttpGetParam(String url, String name, String value) {
        return url + "?" + name + "=" + value;
    }

    public static String post(String url, FormBody body) throws IOException {
        Request request = new Request.Builder().url(url).post((RequestBody)body).build();
        Response response = mOkHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        throw new IOException("Unexpected code " + response);
    }

    public static String post(String url, String jsonObject, String token) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)jsonObject);
        Request request = token == null || "".equals(token) ? new Request.Builder().url(url).post(body).build() : new Request.Builder().url(url).post(body).addHeader("Authorization", token).build();
        Response response = mOkHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        throw new IOException("Unexpected code " + response);
    }

    public static String postFrom2Json(String url, JSONObject jsonObject) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON2, (String)jsonObject.toString());
        Request request = new Request.Builder().url(url).post(body).build();
        Response response = mOkHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        throw new IOException("Unexpected code " + response);
    }

    public static String get(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response response = mOkHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        throw new IOException("Unexpected code " + response);
    }

    public static void get(String url, Callback responseCallback) {
        Request request = new Request.Builder().url(url).build();
        mOkHttpClient.newCall(request).enqueue(responseCallback);
    }

    static {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(30L, TimeUnit.SECONDS);
        builder.sslSocketFactory(OkhttpUtil.createSSLSocketFactory());
        builder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        mOkHttpClient = builder.build();
    }
}

