/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.printer;

import android.util.Log;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.pos.device.CTYSDevice;
import com.aofeng.hybrid.pos.printer.AfPrinter;
import com.ums.upos.sdk.exception.CallServiceException;
import com.ums.upos.sdk.exception.SdkException;
import com.ums.upos.sdk.printer.BoldEnum;
import com.ums.upos.sdk.printer.FeedCount;
import com.ums.upos.sdk.printer.FeedUnitEnum;
import com.ums.upos.sdk.printer.FontConfig;
import com.ums.upos.sdk.printer.FontSizeEnum;
import com.ums.upos.sdk.printer.OnPrintResultListener;
import com.ums.upos.sdk.printer.PrinterManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CTYSPrinter
implements AfPrinter {
    OnPrintResultListener onPrintResultListener = new OnPrintResultListener(){

        public void onPrintResult(int i) {
            Log.e((String)"CTYSPrinter", (String)("\u6253\u5370\u5b8c\u6210" + i));
        }
    };
    PrinterManager pm = new PrinterManager();

    @Override
    public boolean openPrinter() {
        return true;
    }

    @Override
    public boolean closePrinter() {
        return true;
    }

    @Override
    public int getPrinterState() {
        int state = 0;
        try {
            state = this.pm.getStatus();
            return CTYSPrinter.convertErroCode(state);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private int printScrip(String param) {
        int res = 0;
        try {
            if (!CTYSDevice.islogin && !CTYSDevice.login(MainActivity.context)) {
                return CTYSPrinter.convertErroCode(-112);
            }
            int initSate = this.pm.initPrinter();
            if (initSate != 0) {
                return CTYSPrinter.convertErroCode(initSate);
            }
            JSONArray arry = new JSONArray(param);
            String scrip = "!yspace 6\n";
            if (arry.length() > 0) {
                for (int i = 0; i < arry.length(); ++i) {
                    JSONObject json = arry.getJSONObject(i);
                    if (json.getInt("type") == 1) {
                        return 4105;
                    }
                    if (json.getInt("type") == 2) {
                        return 4105;
                    }
                    if (json.getInt("type") == 3) {
                        scrip = scrip + this.printScrtext(json);
                        continue;
                    }
                    if (json.getInt("type") != 4) continue;
                    scrip = scrip + this.feedPageScrip(json);
                }
            }
            res = this.pm.setPrnScript(scrip, "384");
            this.pm.startPrint(this.onPrintResultListener);
        }
        catch (Exception e) {
            res = -1000;
        }
        return CTYSPrinter.convertErroCode(res);
    }

    private String printScrtext(JSONObject json) throws JSONException {
        String align;
        int fonzise;
        String sc = "";
        sc = json.has("fontsize") ? ((fonzise = json.getInt("fontsize")) == 1 ? "!hz s\n!asc s\n" : (fonzise == 3 ? "!hz n\n!asc n\n" : (fonzise == 4 ? "!hz l\n!asc l\n" : "!hz n\n!asc n\n"))) : "!hz n\n!asc n\n";
        sc = json.has("isbold") && json.getBoolean("isbold") ? sc + "!gray 6\n" : sc + "!gray 4\n";
        sc = json.has("align") ? ("CENTER".equals(align = json.getString("align").toUpperCase()) ? sc + "*text c" : ("RIGHT".equals(align) ? sc + "*text r" : sc + "*text l")) : sc + "*text l";
        sc = sc + " " + json.getString("text") + "\n";
        return sc;
    }

    private String feedPageScrip(JSONObject json) throws JSONException {
        String sc = "*feedline  4\n";
        if (json.has("value")) {
            sc = " *feedline " + String.valueOf(json.getInt("value") + "\n");
        }
        return sc;
    }

    @Override
    public int print(String param) {
        return this.printScrip(param);
    }

    private static int convertErroCode(int res) {
        if (res == 0) {
            return 1;
        }
        if (res == -1000) {
            return -2;
        }
        if (res == -1001) {
            return -2;
        }
        if (res == -1002) {
            return 4101;
        }
        if (res == -1003) {
            return 4101;
        }
        if (res == -1004) {
            return 6;
        }
        if (res == -1005) {
            return 0;
        }
        if (res == -1006) {
            return 4101;
        }
        if (res == -1007) {
            return 2;
        }
        if (res == -1008) {
            return 3;
        }
        if (res == -1009) {
            return -2;
        }
        if (res == -1010) {
            return -2;
        }
        if (res == -1011) {
            return 1;
        }
        return -110;
    }

    private int printtext(String param) {
        int res = 0;
        try {
            int initSate = this.pm.initPrinter();
            if (initSate != 0) {
                return CTYSPrinter.convertErroCode(initSate);
            }
            JSONArray arry = new JSONArray(param);
            if (arry.length() > 0) {
                for (int i = 0; i < arry.length(); ++i) {
                    JSONObject json = arry.getJSONObject(i);
                    if (json.getInt("type") == 1) {
                        return 4105;
                    }
                    if (json.getInt("type") == 2) {
                        return 4105;
                    }
                    if (json.getInt("type") == 3) {
                        res = this.printText(json);
                        continue;
                    }
                    if (json.getInt("type") != 4) continue;
                    this.feedPage(json);
                }
            }
            this.pm.startPrint(this.onPrintResultListener);
        }
        catch (Exception e) {
            res = -1000;
        }
        return CTYSPrinter.convertErroCode(res);
    }

    private void feedPage(JSONObject json) throws SdkException, CallServiceException, JSONException {
        FeedCount fc = new FeedCount();
        if (json.has("value")) {
            fc.setNum(json.getInt("value"));
        } else {
            fc.setNum(5);
        }
        fc.setUnit(FeedUnitEnum.LINE);
        this.pm.feedPaper(fc);
    }

    private int printText(JSONObject json) throws SdkException, CallServiceException, JSONException {
        String align;
        FontSizeEnum fes = FontSizeEnum.MIDDLE;
        BoldEnum be = BoldEnum.NOT_BOLD;
        FontConfig fc = new FontConfig();
        if (json.has("fontsize")) {
            int fonzise = json.getInt("fontsize");
            if (fonzise == 1) {
                fes = FontSizeEnum.SMALL;
            } else if (fonzise == 3) {
                fes = FontSizeEnum.MIDDLE;
            } else if (fonzise == 4) {
                fes = FontSizeEnum.BIG;
            }
        }
        if (json.has("isbold") && json.getBoolean("isbold")) {
            be = BoldEnum.BOLD;
        }
        if (!json.has("align") || "CENTER".equals(align = json.getString("align").toUpperCase()) || "RIGHT".equals(align)) {
            // empty if block
        }
        fc.setBold(be);
        fc.setSize(fes);
        return this.pm.setPrnText(json.getString("text"), fc);
    }
}

