/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.zbar.decode;

import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.android.peripheral.CaptureActivity;
import com.aofeng.hybrid.android.zbar.camera.CameraManager;
import com.aofeng.hybrid.android.zbar.decode.DecodeThread;

public final class CaptureActivityHandler
extends Handler {
    private static final String TAG = CaptureActivityHandler.class.getSimpleName();
    private final CaptureActivity activity;
    private final DecodeThread decodeThread;
    private State state;

    public CaptureActivityHandler(CaptureActivity activity) {
        this.activity = activity;
        this.decodeThread = new DecodeThread(activity);
        this.decodeThread.start();
        this.state = State.SUCCESS;
        CameraManager.get().startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        if (message.what == R.id.auto_focus) {
            if (this.state == State.PREVIEW) {
                CameraManager.get().requestAutoFocus(this, R.id.auto_focus);
            }
        } else if (message.what == R.id.restart_preview) {
            Log.d((String)TAG, (String)"Got restart preview message");
            this.restartPreviewAndDecode();
        } else if (message.what == R.id.decode_succeeded) {
            String strResult = (String)message.obj;
            Log.d((String)TAG, (String)("Got decode succeeded message:" + strResult));
            this.state = State.SUCCESS;
            this.activity.handleDecode(strResult);
        } else if (message.what == R.id.decode_failed) {
            this.state = State.PREVIEW;
            CameraManager.get().requestPreviewFrame(this.decodeThread.getHandler(), R.id.decode);
        } else if (message.what == R.id.return_scan_result) {
            Log.d((String)TAG, (String)"Got return scan result message");
            this.activity.setResult(-1, (Intent)message.obj);
            this.activity.finish();
        }
    }

    public void quitSynchronously() {
        this.state = State.DONE;
        CameraManager.get().stopPreview();
        Message quit = Message.obtain((Handler)this.decodeThread.getHandler(), (int)R.id.quit);
        quit.sendToTarget();
        try {
            this.decodeThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(R.id.decode_succeeded);
        this.removeMessages(R.id.decode_failed);
    }

    private void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            CameraManager.get().requestPreviewFrame(this.decodeThread.getHandler(), R.id.decode);
            CameraManager.get().requestAutoFocus(this, R.id.auto_focus);
            this.activity.drawViewfinder();
        }
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

