/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.zbar.camera;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.aofeng.hybrid.android.zbar.camera.CameraConfigurationManager;

final class PreviewCallback
implements Camera.PreviewCallback {
    private static final String TAG = PreviewCallback.class.getSimpleName();
    private final boolean useOneShotPreviewCallback;
    private Handler previewHandler;
    private int previewMessage;

    public PreviewCallback(CameraConfigurationManager configManager, boolean useOneShotPreviewCallback) {
        this.useOneShotPreviewCallback = useOneShotPreviewCallback;
    }

    public void setHandler(Handler previewHandler, int previewMessage) {
        this.previewHandler = previewHandler;
        this.previewMessage = previewMessage;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (!this.useOneShotPreviewCallback) {
            camera.setPreviewCallback(null);
        }
        if (this.previewHandler != null) {
            Camera.Parameters parameters = camera.getParameters();
            Camera.Size size = parameters.getPreviewSize();
            Message message = this.previewHandler.obtainMessage(this.previewMessage, size.width, size.height, (Object)data);
            message.sendToTarget();
            this.previewHandler = null;
        } else {
            Log.d((String)TAG, (String)"Got preview callback, but no handler for it");
        }
    }
}

