/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.zbar.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import android.view.View;
import com.aofeng.hybrid.R;

public final class ViewfinderView
extends View {
    private static final long ANIMATION_DELAY = 10L;
    private static final int OPAQUE = 255;
    private int CORNER_HEIGHT;
    private static final int CORNER_WIDTH = 10;
    private static final int SPEEN_DISTANCE = 5;
    private static float density;
    private int slideTop;
    private int slideBottom;
    boolean isFirst = false;
    private Bitmap resultBitmap;
    private int maskColor;
    private int resultColor;
    private int measureedWidth;
    private int measureedHeight;
    private Rect frame = new Rect();
    private int borderColor = Color.rgb((int)0, (int)221, (int)0);
    private Paint paint;
    private Paint paintText;

    public ViewfinderView(Context context) {
        super(context);
        this.init(context);
    }

    public ViewfinderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        density = context.getResources().getDisplayMetrics().density;
        this.maskColor = context.getResources().getColor(R.color.viewfinder_laser);
        this.resultColor = context.getResources().getColor(R.color.result_view);
        this.CORNER_HEIGHT = (int)(20.0f * density);
        this.paint = new Paint();
        this.paintText = new Paint();
        this.paintText.setAntiAlias(true);
        this.paintText.setColor(-1);
        this.paintText.setTextSize(40.0f);
        this.paintText.setTypeface(Typeface.SANS_SERIF);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.measureedWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.measureedHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int borderWidth = (int)((float)this.measureedWidth - 30.0f * density);
        int borderHeight = this.measureedHeight / 3;
        int left = (this.measureedWidth - borderWidth) / 2;
        int top = (this.measureedHeight - borderHeight) / 2;
        this.frame.set(left, top, left + borderWidth, top + borderHeight);
    }

    public Rect getScanImageRect(int w, int h) {
        Rect rect = new Rect();
        rect.left = this.frame.left;
        rect.right = this.frame.right;
        float temp = (float)h / (float)this.measureedHeight;
        rect.top = (int)((float)this.frame.top * temp);
        rect.bottom = (int)((float)this.frame.bottom * temp);
        return rect;
    }

    @SuppressLint(value={"DrawAllocation"})
    public void onDraw(Canvas canvas) {
        if (this.frame == null) {
            return;
        }
        if (!this.isFirst) {
            this.isFirst = true;
            this.slideTop = this.frame.top;
            this.slideBottom = this.frame.bottom;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.paint.setColor(this.resultBitmap != null ? this.resultColor : this.maskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)this.frame.top, this.paint);
        canvas.drawRect(0.0f, (float)this.frame.top, (float)this.frame.left, (float)(this.frame.bottom + 1), this.paint);
        canvas.drawRect((float)(this.frame.right + 1), (float)this.frame.top, (float)width, (float)(this.frame.bottom + 1), this.paint);
        canvas.drawRect(0.0f, (float)(this.frame.bottom + 1), (float)width, (float)height, this.paint);
        if (this.resultBitmap != null) {
            this.paint.setAlpha(255);
            canvas.drawBitmap(this.resultBitmap, (float)this.frame.left, (float)this.frame.top, this.paint);
        } else {
            this.paint.setColor(this.borderColor);
            canvas.drawRect((float)this.frame.left, (float)this.frame.top, (float)(this.frame.left + this.CORNER_HEIGHT), (float)(this.frame.top + 10), this.paint);
            canvas.drawRect((float)this.frame.left, (float)this.frame.top, (float)(this.frame.left + 10), (float)(this.frame.top + this.CORNER_HEIGHT), this.paint);
            canvas.drawRect((float)(this.frame.right - this.CORNER_HEIGHT), (float)this.frame.top, (float)this.frame.right, (float)(this.frame.top + 10), this.paint);
            canvas.drawRect((float)(this.frame.right - 10), (float)this.frame.top, (float)this.frame.right, (float)(this.frame.top + this.CORNER_HEIGHT), this.paint);
            canvas.drawRect((float)this.frame.left, (float)(this.frame.bottom - 10), (float)(this.frame.left + this.CORNER_HEIGHT), (float)this.frame.bottom, this.paint);
            canvas.drawRect((float)this.frame.left, (float)(this.frame.bottom - this.CORNER_HEIGHT), (float)(this.frame.left + 10), (float)this.frame.bottom, this.paint);
            canvas.drawRect((float)(this.frame.right - this.CORNER_HEIGHT), (float)(this.frame.bottom - 10), (float)this.frame.right, (float)this.frame.bottom, this.paint);
            canvas.drawRect((float)(this.frame.right - 10), (float)(this.frame.bottom - this.CORNER_HEIGHT), (float)this.frame.right, (float)this.frame.bottom, this.paint);
            this.slideTop += 5;
            if (this.slideTop >= this.slideBottom) {
                this.slideTop = this.frame.top;
            }
            Rect lineRect = new Rect();
            lineRect.left = this.frame.left;
            lineRect.right = this.frame.right;
            lineRect.top = this.slideTop;
            lineRect.bottom = this.slideTop + 18;
            canvas.drawBitmap(((BitmapDrawable)this.getResources().getDrawable(R.drawable.scan_line)).getBitmap(), null, lineRect, this.paint);
            Rect rectText = new Rect();
            String str = this.getResources().getString(R.string.scan_tip);
            this.paintText.getTextBounds(str, 0, str.length(), rectText);
            canvas.drawText(str, (float)((this.frame.left + this.frame.right - rectText.width()) / 2), (float)(80 + this.frame.bottom), this.paintText);
            this.postInvalidateDelayed(10L, this.frame.left, this.frame.top, this.frame.right, this.frame.bottom);
        }
    }

    public void drawViewfinder() {
        Bitmap resultBitmap = this.resultBitmap;
        this.resultBitmap = null;
        if (resultBitmap != null) {
            resultBitmap.recycle();
        }
        this.invalidate();
    }

    public void drawResultBitmap(Bitmap barcode) {
        this.resultBitmap = barcode;
        this.invalidate();
    }
}

