/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.task;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.aofeng.hybrid.activity.HybridActivity;
import com.aofeng.hybrid.android.task.HintPlugin;
import com.aofeng.hybrid.service.LogicService;
import org.json.JSONObject;

public class GenericAsyncTask
extends AsyncTask<String, String, JSONObject> {
    protected HybridActivity hybridActivity;
    protected String callback;
    protected int backresult;
    protected String logic;

    public GenericAsyncTask(HybridActivity hybridActivity, String logic, String callback) {
        this.hybridActivity = hybridActivity;
        this.callback = callback;
        this.logic = logic;
    }

    public GenericAsyncTask(HybridActivity hybridActivity, String logic, String callback, int backresult) {
        this.hybridActivity = hybridActivity;
        this.callback = callback;
        this.logic = logic;
        this.backresult = backresult;
    }

    protected JSONObject doInBackground(String ... params) {
        JSONObject data = null;
        try {
            data = new JSONObject();
            LogicService logicService = new LogicService((Context)this.hybridActivity);
            HintPlugin plugin = new HintPlugin(this);
            logicService.addService("hint", plugin);
            JSONObject result = (JSONObject)logicService.run(this.logic, new JSONObject(params[0]));
            data.put("state", (Object)"ok");
            data.put("result", (Object)result.toString());
            Log.d((String)"\u8c03\u7528\u4e1a\u52a1\u8fd4\u56de\u503c", (String)data.toString());
        }
        catch (Exception e) {
            try {
                data.put("state", (Object)"nok");
                String msg = "";
                msg = e.getMessage() == null ? msg + e.getClass() : msg + e.getMessage();
                data.put("err_msg", (Object)msg);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return data;
    }

    public void hint(String msg) {
        this.publishProgress(new String[]{msg});
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.hybridActivity.createProgressDialog(0);
        this.hybridActivity.setTitle("\u63d0\u793a");
        this.hybridActivity.setMessage("\u6b63\u5728\u5de5\u4f5c\uff0c\u8bf7\u7b49\u5f85...");
        this.hybridActivity.showProgress();
    }

    protected void onPostExecute(JSONObject result) {
        super.onPostExecute((Object)result);
        this.hybridActivity.closeProgress();
        if (this.callback != null && result != null) {
            try {
                String js = "";
                if (this.callback.contains("()")) {
                    this.callback = this.callback.substring(0, this.callback.indexOf("("));
                }
                if (result.has("params") && this.backresult == 0) {
                    js = "javascript:" + this.callback + "(" + result.getString("params") + ");";
                }
                if (this.backresult == 1) {
                    js = "javascript:" + this.callback + "(" + result.toString() + ");";
                }
                this.hybridActivity.mWebView.loadUrl(js);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void onProgressUpdate(String ... values) {
        super.onProgressUpdate((Object[])values);
        this.hybridActivity.setMessage(values[0]);
    }
}

