/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipUtil {
    private static final int BUFFER_SIZE = 4096;

    public static <T> T jsonToObject(String json, Class<T> c) {
        Object t = null;
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                t = new Gson().fromJson(json, c);
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
        return (T)t;
    }

    public static File getLocalRoot() {
        File tmp = Environment.getExternalStorageDirectory();
        if (!(tmp = new File(tmp, "webapp")).exists()) {
            tmp.mkdirs();
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void bytes2File(String path, byte[] data) {
        block8: {
            if (!TextUtils.isEmpty((CharSequence)path) && data != null) {
                File file = new File(path);
                BufferedOutputStream bos = null;
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(file));
                    bos.write(data);
                    bos.flush();
                    UnzipUtil.safeClose(bos);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    break block8;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    UnzipUtil.safeClose(bos);
                }
            }
        }
    }

    public static boolean safeClose(Closeable c) {
        boolean ret = false;
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static synchronized int deleteAllFilesInFolder(File path) {
        int deletedItems = 0;
        File[] fileList = path.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isDirectory()) {
                    deletedItems += UnzipUtil.deleteAllFilesInFolder(file);
                }
                if (!file.delete()) continue;
                ++deletedItems;
            }
        }
        return deletedItems;
    }

    public static void UnzipToFolder(String zipFileString, String outPathString) throws Exception {
        ZipEntry zipEntry;
        Log.v((String)"XZip", (String)"UnZipFolder(String, String)");
        ZipInputStream inZip = new ZipInputStream(new FileInputStream(zipFileString));
        String szName = "";
        while ((zipEntry = inZip.getNextEntry()) != null) {
            int len;
            szName = zipEntry.getName();
            if (zipEntry.isDirectory()) {
                szName = szName.substring(0, szName.length() - 1);
                File folder = new File(outPathString + File.separator + szName);
                folder.mkdirs();
                continue;
            }
            File file = new File(outPathString + File.separator + szName);
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((len = inZip.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                out.flush();
            }
            out.close();
        }
        inZip.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveStreamToFile(InputStream inputStream, String path) {
        if (path == null) {
            throw new NullPointerException("path should not be null.");
        }
        FileOutputStream fileOutputStream = null;
        try {
            int length;
            File file = UnzipUtil.createFile(path);
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            byte[] buffer = new byte[4096];
            fileOutputStream = new FileOutputStream(file);
            while ((length = inputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, length);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static synchronized File createFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        File file = new File(path);
        if (file.isFile()) {
            return file;
        }
        File parentFile = file.getParentFile();
        if (parentFile != null && (parentFile.isDirectory() || parentFile.mkdirs())) {
            try {
                if (file.createNewFile()) {
                    return file;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

