/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.sync;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import org.json.JSONObject;

public class MD5Manager {
    private static MD5Manager instance = new MD5Manager();
    public JSONObject config = null;
    private HashMap<String, String> md5s = new HashMap();

    public static MD5Manager getInstance() {
        return instance;
    }

    private MD5Manager() {
    }

    public void loadMd5() {
        this.md5s.clear();
        try {
            String LOCAL_PATH_PREFIX = this.config.getString("LOCAL_PATH_PREFIX");
            String path = LOCAL_PATH_PREFIX + "files.md5";
            File file = new File(path);
            if (file.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(path));
                String md5s = reader.readLine();
                reader.close();
                this.putMd5(md5s);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void saveMd5(String md5s) {
        this.putMd5(md5s);
        try {
            String LOCAL_PATH_PREFIX = this.config.getString("LOCAL_PATH_PREFIX");
            String path = LOCAL_PATH_PREFIX + "files.md5";
            FileWriter writer = new FileWriter(path);
            writer.write(md5s);
            ((Writer)writer).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void putMd5(String md5s) {
        String[] files = md5s.split("\\|", -1);
        boolean i = false;
        int n = files.length;
        for (String file : files) {
            String[] pair = file.split(",");
            this.md5s.put(pair[0], pair[1]);
        }
    }

    public String getMd5(String file) {
        return this.md5s.get(file);
    }
}

