/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import android.os.RemoteException;
import android.util.Log;
import com.aofeng.hybrid.pos.device.ZTDevice;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.HexDump;
import com.szzt.sdk.device.card.SmartCardSlotInfo;

public class ZTNativeReader
implements ICardReader {
    private static final String TAG = "ZTNativeReader";
    private static int SLOT = 0;
    private static int TIMEOUT = 60000;
    private static int isCard = 0;

    @Override
    public boolean openDevice(Chip chip) {
        return ZTNativeReader.openReader();
    }

    @Override
    public boolean closeDevice(Chip chip) {
        return ZTNativeReader.closeReader();
    }

    @Override
    public boolean read(Chip chip) {
        try {
            if (chip.chipName == 1) {
                return ZTNativeReader.read4442(0, 256, chip.buf);
            }
            if (chip.chipName == 0) {
                if (chip.secret != null) {
                    for (int i = 0; i < chip.secret.length(); i += 4) {
                        String pwd = chip.secret.substring(i, i + 4);
                        if (!ZTNativeReader.verify102Pwd(HexDump.hexStringToByteArray(pwd))) continue;
                        chip.secret = pwd;
                        return ZTNativeReader.read102(0, 178, chip.buf, null);
                    }
                    return false;
                }
                return ZTNativeReader.read102(0, 178, chip.buf, null);
            }
            if (chip.chipName == 3) {
                return ZTNativeReader.read24C02(0, 256, chip.buf);
            }
            if (chip.chipName == 6) {
                if (chip.secret != null) {
                    String[] kmms = chip.secret.split("\\|");
                    String area2ReadPwd = ZTNativeReader.get1608AreaPwd(2, 0, kmms);
                    for (int i = 0; i < area2ReadPwd.length(); i += 6) {
                        String pwd = area2ReadPwd.substring(i, i + 6);
                        if (!ZTNativeReader.verify1608Pwd(10, HexDump.hexStringToByteArray(pwd))) continue;
                        return ZTNativeReader.read1608(10, 0, 256, chip.buf);
                    }
                    return false;
                }
                if (chip.secret_1608 != null) {
                    String[] kmms = chip.secret_1608.split("\\|");
                    String area7ReadPwd = ZTNativeReader.get1608AreaPwd(7, 0, kmms);
                    for (int i = 0; i < area7ReadPwd.length(); i += 6) {
                        String pwd = area7ReadPwd.substring(i, i + 6);
                        if (!ZTNativeReader.verify1608Pwd(15, HexDump.hexStringToByteArray(area7ReadPwd))) continue;
                        return ZTNativeReader.read1608(15, 0, 256, chip.buf);
                    }
                    return false;
                }
                return ZTNativeReader.read1608Config(3, 0, 128, chip.buf);
            }
            if (chip.chipName == 7) {
                byte[] data = this.resetCPUCard();
                chip.buf = data;
                return data != null;
            }
            if (chip.chipName == 10) {
                return ZTNativeReader.readM1CardTT(chip);
            }
            if (chip.chipName == 11) {
                if (chip.secret != null) {
                    String[] kmms = chip.secret.split("\\|");
                    String area2WritePwd = ZTNativeReader.get1608AreaPwd(0, 0, kmms);
                    for (int i = 0; i < area2WritePwd.length(); i += 6) {
                        String pwd = area2WritePwd.substring(i, i + 6);
                        if (!this.verify153Pwd(1, HexDump.hexStringToByteArray(pwd))) continue;
                        chip.secret = pwd;
                        return this.read153(chip.buf);
                    }
                    return false;
                }
                return this.read153Config(chip.buf);
            }
            if (chip.chipName == 1001) {
                return this.read5557(chip.buf);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean read5557(byte[] buf) {
        try {
            int ret;
            byte[] data_buff;
            int i;
            for (i = 0; i < 8; ++i) {
                data_buff = new byte[4];
                ret = ZTDevice.waterCard.E5557_Direct_Read(0, 0 + i, 1, null, data_buff);
                if (ret < 0) {
                    return false;
                }
                System.arraycopy(data_buff, 0, buf, i * 4, 4);
            }
            for (i = 0; i < 2; ++i) {
                data_buff = new byte[4];
                ret = ZTDevice.waterCard.E5557_Direct_Read(1, 0 + i, 1, null, data_buff);
                if (ret < 0) {
                    return false;
                }
                System.arraycopy(data_buff, 0, buf, 32 + i * 4, 4);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"read5557: ", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean write(Chip chip, int block, int offset, int len, byte[] buf, byte[] secret) {
        if (chip.chipName == 0) {
            return ZTNativeReader.write102(offset, len, buf, secret);
        }
        if (chip.chipName == 1) {
            return ZTNativeReader.write4442(offset, len, buf, secret);
        }
        if (chip.chipName == 6) {
            return ZTNativeReader.write1608(block, offset, len, buf, secret);
        }
        if (chip.chipName == 3) {
            return ZTNativeReader.write24C02(offset, len, buf);
        }
        if (chip.chipName == 10) {
            return ZTNativeReader.writeM1CardTT(buf);
        }
        if (chip.chipName == 11) {
            return this.write153(block, offset, len, buf, secret);
        }
        if (chip.chipName == 1001) {
            return this.write5557(block, offset, len, buf, secret);
        }
        return false;
    }

    private boolean write5557(int block, int offset, int len, byte[] buf, byte[] secret) {
        try {
            int ret = ZTDevice.waterCard.E5557_Write_Free(0, block, 1, secret, buf);
            return ret >= 0;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"write5557: ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean verifyPwd(Chip chip, int block, byte[] secret) {
        if (chip.chipName == 0) {
            for (int i = 0; i < secret.length; i += 2) {
                if (!ZTNativeReader.verify102Pwd(new byte[]{secret[i], secret[i + 1]})) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 1) {
            for (int i = 0; i < secret.length; i += 3) {
                if (!ZTNativeReader.verify4442Pwd(new byte[]{secret[i], secret[i + 1], secret[i + 2]})) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 6) {
            return ZTNativeReader.verify1608Pwd(block, secret);
        }
        if (chip.chipName == 11) {
            return this.verify153Pwd(block, secret);
        }
        return true;
    }

    @Override
    public boolean changePwd(Chip chip, int block, byte[] oldSecret, byte[] newSecret) {
        if (chip.chipName == 0) {
            return ZTNativeReader.change102Pwd(oldSecret, newSecret);
        }
        if (chip.chipName == 1) {
            return ZTNativeReader.change4442Pwd(oldSecret, newSecret);
        }
        if (chip.chipName == 6) {
            return ZTNativeReader.change1608Pwd(block, oldSecret, newSecret);
        }
        return true;
    }

    @Override
    public Chip getNvlChip() {
        int ct = ZTNativeReader.getCardType();
        if (isCard == 1) {
            if (ct == 1) {
                return new Chip(1);
            }
            if (ct == 4) {
                return new Chip(0);
            }
            if (ct == 3) {
                return new Chip(3);
            }
            if (ct == 6) {
                return new Chip(6);
            }
            if (ct == 0) {
                return new Chip(7);
            }
            if (ct == 7) {
                return new Chip(11);
            }
            return null;
        }
        if (isCard == 2) {
            if (ct == 2) {
                return new Chip(10);
            }
            return null;
        }
        if (isCard == 3) {
            return new Chip(1001);
        }
        return null;
    }

    @Override
    public boolean hasCard() {
        int res;
        boolean hascard = false;
        if (!ZTNativeReader.openReader()) {
            return hascard;
        }
        if (isCard == 1) {
            int res2 = ZTDevice.nativeReader.queryPresence(SLOT);
            if (res2 > 0) {
                hascard = true;
            }
        } else if (isCard == 2 && (res = ZTDevice.contactlessCardReader.waitForCard(1000)) == 0) {
            hascard = true;
        }
        return hascard;
    }

    public static boolean openReader() {
        boolean isOpen = false;
        try {
            int ret = ZTDevice.nativeReader.open(SLOT, null);
            int res = ZTDevice.contactlessCardReader.open();
            int water = -1;
            try {
                water = ZTDevice.waterCard.Open_Mod();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"openReader: ", (Throwable)e);
            }
            isCard = 0;
            if (ret >= 0) {
                byte[] buf = new byte[4];
                ret = ZTDevice.nativeReader.powerOn(SLOT, buf);
                if (ret >= 0) {
                    isCard = 1;
                    isOpen = true;
                } else {
                    ZTDevice.nativeReader.powerOff(SLOT);
                    ZTDevice.nativeReader.close(SLOT);
                }
            }
            if (res >= 0 && isCard != 1) {
                int r = ZTDevice.contactlessCardReader.waitForCard(1000);
                if (r == 0) {
                    byte[] buf = new byte[40];
                    res = ZTDevice.contactlessCardReader.powerOn(buf);
                    if (res > 0) {
                        isCard = 2;
                        isOpen = true;
                    }
                } else {
                    ZTDevice.contactlessCardReader.close();
                }
            }
            if (water >= 0 && isCard != 1 && isCard != 2) {
                ZTDevice.waterCard.set_Datarate(1L);
                isCard = 3;
                isOpen = true;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"openReader: ", (Throwable)e);
        }
        return isOpen;
    }

    public static boolean closeReader() {
        if (isCard == 1) {
            ZTDevice.nativeReader.powerOff(SLOT);
            return ZTDevice.nativeReader.close(SLOT) >= 0;
        }
        if (isCard == 2) {
            ZTDevice.contactlessCardReader.powerOff();
            return ZTDevice.contactlessCardReader.close() >= 0;
        }
        if (isCard == 3) {
            try {
                return ZTDevice.waterCard.Close_Mod() >= 0;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"closeReader: ", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static int getCardType() {
        if (!ZTNativeReader.openReader()) {
            return -1;
        }
        try {
            if (isCard == 1) {
                SmartCardSlotInfo slot = new SmartCardSlotInfo();
                slot.power = (byte)2;
                ZTDevice.nativeReader.setSlotInfo(SLOT, slot);
                int ret = ZTDevice.nativeReader.queryPresence(SLOT);
                if (ret <= 0) {
                    int n = -1;
                    return n;
                }
                ret = ZTDevice.nativeReader.waitForCard(SLOT, TIMEOUT);
                if (ret != 0) {
                    int n = -1;
                    return n;
                }
                int n = ZTDevice.nativeReader.getCardType(SLOT);
                return n;
            }
            if (isCard == 2) {
                int ret = ZTDevice.contactlessCardReader.waitForCard(1000);
                if (ret != 0) {
                    int n = -1;
                    return n;
                }
                int n = ZTDevice.contactlessCardReader.getCardType();
                return n;
            }
            if (isCard == 3) {
                int ret = 1001;
                return ret;
            }
            int ret = -1;
            return ret;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            ZTNativeReader.closeReader();
        }
    }

    public static boolean verify4442Pwd(byte[] key) {
        int ret = ZTDevice.nativeReader.verify(SLOT, key, 18);
        return ret == 0;
    }

    public static boolean change4442Pwd(byte[] oldKey, byte[] newKey) {
        if (ZTNativeReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !ZTNativeReader.verify4442Pwd(oldKey)) {
            return false;
        }
        int ret = ZTDevice.nativeReader.write(SLOT, 2, 1, newKey);
        return ret == 0;
    }

    public static int get4442PwdAttemptCnt() {
        byte[] count = new byte[1];
        int ret = ZTDevice.nativeReader.read(SLOT, 2, 0, count);
        if (ret > 0) {
            if ((count[0] & 7) == 7) {
                return 3;
            }
            if ((count[0] & 6) == 6) {
                return 2;
            }
            if ((count[0] & 4) == 4) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public static boolean read4442(int offset, int len, byte[] buf) {
        if (ZTNativeReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        int lockstate = ZTDevice.nativeReader.lock(SLOT);
        int ret = ZTDevice.nativeReader.read(SLOT, 0, offset, buf);
        return ret >= 0;
    }

    public static boolean write4442(int offset, int len, byte[] buf, byte[] key) {
        if (ZTNativeReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !ZTNativeReader.verify4442Pwd(key)) {
            return false;
        }
        int ret = ZTDevice.nativeReader.write(SLOT, 0, offset, buf);
        return ret >= 0;
    }

    public static boolean read24C02(int offset, int len, byte[] buf) {
        int ret = ZTDevice.nativeReader.read(SLOT, 0, offset, buf);
        return ret >= 0;
    }

    public static boolean write24C02(int offset, int len, byte[] buf) {
        int ret = ZTDevice.nativeReader.write(SLOT, 0, offset, buf);
        return ret >= 0;
    }

    public static boolean verify102Pwd(byte[] key) {
        int ret = ZTDevice.nativeReader.verify(SLOT, key, 18);
        return ret == 0;
    }

    public static boolean change102Pwd(byte[] oldKey, byte[] newKey) {
        if (ZTNativeReader.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !ZTNativeReader.verify102Pwd(oldKey)) {
            return false;
        }
        int ret = ZTDevice.nativeReader.write(SLOT, 0, 80, newKey);
        return ret == 0;
    }

    public static int get102PwdAttemptCnt() {
        byte[] count = new byte[4];
        int ret = ZTDevice.nativeReader.read(SLOT, 0, 12, count);
        if (ret > 0) {
            if ((count[0] & 0xF0) == 240) {
                return 4;
            }
            if ((count[0] & 0xF0) == 112) {
                return 3;
            }
            if ((count[0] & 0xF0) == 48) {
                return 2;
            }
            if ((count[0] & 0xF0) == 16) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public static boolean read102(int offset, int len, byte[] buf, byte[] key) {
        int ret = ZTNativeReader.get102PwdAttemptCnt();
        if (ret <= 0) {
            return false;
        }
        if (key != null && !ZTNativeReader.verify102Pwd(key)) {
            return false;
        }
        ret = ZTDevice.nativeReader.read(SLOT, 0, offset * 8, buf);
        return ret >= 0;
    }

    public static boolean write102(int offset, int len, byte[] buf, byte[] key) {
        if (ZTNativeReader.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !ZTNativeReader.verify102Pwd(key)) {
            return false;
        }
        int ret = ZTDevice.nativeReader.write(SLOT, 0, offset * 8, buf);
        return ret >= 0;
    }

    public static boolean read1608(int block, int offset, int len, byte[] buf) {
        byte[] data = new byte[256];
        int area = block + 4 - 8;
        int ret = ZTDevice.nativeReader.read(SLOT, area, offset, data);
        if (block == 10) {
            System.arraycopy(data, 0, buf, 384, 256);
        } else {
            System.arraycopy(data, 0, buf, 128, 256);
        }
        return ret >= 0;
    }

    public static boolean read1608Config(int block, int offset, int len, byte[] buf) {
        byte[] data = new byte[128];
        int ret = ZTDevice.nativeReader.read(SLOT, block, offset, data);
        System.arraycopy(data, 0, buf, 0, 128);
        return ret >= 0;
    }

    public static boolean write1608(int block, int offset, int len, byte[] buf, byte[] key) {
        int area = block + 4;
        int ret = ZTDevice.nativeReader.verify(SLOT, key, block);
        if (ret != 0) {
            return false;
        }
        ret = ZTDevice.nativeReader.write(SLOT, area, offset, buf);
        return ret >= 0;
    }

    public static int get1608PwdAttemptCnt(int block) {
        byte[] count;
        int address = block > 7 ? (block - 8) * 8 + 68 : block * 8 + 64;
        int ret = ZTDevice.nativeReader.read(SLOT, 3, address, count = new byte[1]);
        if (ret > 0) {
            return count[0];
        }
        return 0;
    }

    public static boolean verify1608Pwd(int block, byte[] key) {
        int ret = ZTDevice.nativeReader.verify(SLOT, key, block);
        return ret == 0;
    }

    public static boolean change1608Pwd(int block, byte[] oldKey, byte[] key) {
        int ret;
        if (oldKey != null && (ret = ZTDevice.nativeReader.verify(SLOT, oldKey, block)) != 0) {
            return false;
        }
        int address = block > 7 ? (block - 8) * 8 + 69 : block * 8 + 65;
        ret = ZTDevice.nativeReader.read(SLOT, 3, address, key);
        return ret >= 0;
    }

    private static String get1608AreaPwd(int area, int type, String[] pwd) {
        if (type == 0) {
            return pwd[(area + 1) * 2 - 1];
        }
        if (type == 1) {
            return pwd[(area + 1) * 2 - 2];
        }
        return null;
    }

    public static boolean readM1CardTT(Chip chip) {
        if (!ZTNativeReader.openReader()) {
            return false;
        }
        int cardType = ZTDevice.contactlessCardReader.getCardType();
        if (cardType != 2) {
            return false;
        }
        byte[] paw = new byte[]{71, 89, 70, 70, 89, 71};
        int ret = ZTDevice.contactlessCardReader.verifyPinMifare(0, 96, paw);
        if (ret < 0) {
            return false;
        }
        ret = ZTDevice.contactlessCardReader.readMifare(0, 1, chip.buf);
        return ret >= 0;
    }

    public static boolean writeM1CardTT(byte[] buf) {
        if (!ZTNativeReader.openReader()) {
            return false;
        }
        int cardType = ZTDevice.contactlessCardReader.getCardType();
        if (cardType != 2) {
            return false;
        }
        int ret = ZTDevice.contactlessCardReader.verifyPinMifare(0, 96, HexDump.hexStringToByteArray("475946465947"));
        if (ret < 0) {
            return false;
        }
        int res = ZTDevice.contactlessCardReader.writeMifare(0, 1, buf);
        return res >= 0;
    }

    @Override
    public byte[] resetCPUCard() {
        byte[] data = new byte[13];
        int ret = ZTDevice.nativeReader.powerOn(0, data);
        return data;
    }

    @Override
    public byte[] resetRFCard() {
        return new byte[0];
    }

    @Override
    public byte[] resetPSAMCard() {
        byte[] data = new byte[13];
        int ret = ZTDevice.nativeReader.open(1, null);
        ret = ZTDevice.nativeReader.powerOn(1, data);
        return data;
    }

    @Override
    public byte[] CPUsendAPDU(byte[] APDU) {
        byte[] results = new byte[255];
        int length = APDU[2] + 1;
        if (APDU[2] == 5) {
            --length;
        }
        byte[] apdu = new byte[length];
        System.arraycopy(APDU, 3, apdu, 0, APDU[2]);
        int ret = ZTDevice.nativeReader.transmit(0, apdu, results);
        byte[] result = new byte[ret];
        System.arraycopy(results, 0, result, 0, ret);
        return result;
    }

    @Override
    public byte[] RFsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    @Override
    public byte[] PSAMsendAPDU(byte[] APDU) {
        byte[] results = new byte[255];
        int length = APDU[2] + 1;
        if (APDU[2] == 5) {
            --length;
        }
        byte[] apdu = new byte[length];
        System.arraycopy(APDU, 3, apdu, 0, length);
        int ret = ZTDevice.nativeReader.transmit(1, apdu, results);
        byte[] result = new byte[ret];
        System.arraycopy(results, 0, result, 0, ret);
        return result;
    }

    public boolean verify153Pwd(int block, byte[] key) {
        int ret = -1;
        ret = block == 0 ? ZTDevice.nativeReader.verify(SLOT, key, 1) : ZTDevice.nativeReader.verify(SLOT, key, 8);
        return ret >= 0;
    }

    public boolean read153(byte[] buf) {
        int ret = -1;
        byte[] res = new byte[64];
        for (int i = 0; i < 3; ++i) {
            ret = ZTDevice.nativeReader.read(SLOT, 4 + i, 0, res);
            if (ret < 0) {
                return false;
            }
            System.arraycopy(res, 0, buf, i * 64, res.length);
        }
        return true;
    }

    public boolean read153Config(byte[] buf) {
        int ret = -1;
        byte[] res = new byte[64];
        ret = ZTDevice.nativeReader.read(SLOT, 3, 0, res);
        if (ret < 0) {
            return false;
        }
        System.arraycopy(res, 0, buf, 192, res.length);
        return true;
    }

    public boolean write153(int block, int offset, int len, byte[] buf, byte[] secret) {
        int ret = ZTDevice.nativeReader.write(SLOT, 4 + block, offset, buf);
        return ret >= 0;
    }
}

