/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import android.annotation.SuppressLint;
import android.util.Log;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.pos.device.CTDevice;
import com.aofeng.hybrid.pos.device.LDDevice;
import com.aofeng.hybrid.pos.plugin.ReadCard;
import com.aofeng.hybrid.pos.plugin.WriCard;
import com.aofeng.hybrid.pos.reader.CPUSocket;
import com.aofeng.hybrid.pos.reader.CTChangAnReader;
import com.aofeng.hybrid.pos.reader.CardLog;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.Fragment;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.pos.reader.LDNativeReader;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.EncryUtil;
import com.aofeng.hybrid.util.HexDump;
import com.aofeng.hybrid.util.OkhttpUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class CardAgent {
    public static final int ERROR_READ_CARD = -1;
    public static final int ERROR_PWD_VERIFY_FAIL = -2;
    public static final int ERROR_BLANK_CARD = -3;
    public static final int ERROR_NETWORK = -4;
    public static final int ERROR_WRITE_CARD = -5;
    public static final int ERROR_NOT_SUPPORTED = -6;
    public static final int ERROR_CLOUD_ERROR = -7;
    public static final int ERROR_PWD_CHANGE_FAIL = -8;
    public static final int ERROR_DOUBLE_CARD = -9;
    public static final int ERROR_NOERROR = 0;
    public static final int ERROR_NOT_USER_CARD = 5;
    public static final int ERROR_HAS_GAS = 7;
    public static final int ERROR_SECRET_BACK = 17;
    public static final int ERROR_LOGIN = -10;
    public static final int ERROR_VIEW = -12;
    public static final HashMap<Integer, String> errorMap = new HashMap();
    private byte[] bufPwd = new byte[100];
    private ICardReader reader;
    private String cloudUrl;
    private String socketUrl;
    private String mdmCode;
    private String encryType = "";
    private String token = "";
    private String encryKey = "";
    private static String logStr;
    private static boolean isA10;

    public void setReader(ICardReader reader) {
        this.reader = reader;
    }

    public ICardReader getReader() {
        return this.reader;
    }

    public String getCloudUrl() {
        return this.cloudUrl;
    }

    public void setCloudUrl(String cloudUrl) {
        this.cloudUrl = cloudUrl;
    }

    public String getSocketUrl() {
        return this.socketUrl;
    }

    public void setSocketUrl(String socketUrl) {
        this.socketUrl = socketUrl;
    }

    public String getMdmCode() {
        return this.mdmCode;
    }

    public void setMdmCode(String mdmCode) {
        this.mdmCode = mdmCode;
    }

    public String getEncryType() {
        return this.encryType;
    }

    public void setEncryType(String encryType) {
        this.encryType = encryType;
    }

    public String getEncryKey() {
        return this.encryKey;
    }

    public void setEncryKey(String encryKey) {
        this.encryKey = encryKey;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static void log(String msg) {
        if (logStr == null) {
            logStr = "";
        }
        StringBuilder builder = new StringBuilder(logStr);
        builder.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())).append(" ").append("SN-");
        builder.append(AFApplication.device.getSN()).append(" ");
        builder.append(msg);
        builder.append("\r\n");
        logStr = builder.toString();
    }

    public boolean hasCard() {
        if (AFApplication.card.getReader() instanceof LDNativeReader && !LDDevice.login()) {
            CardAgent.log("LD device login fail");
        }
        return this.reader.hasCard();
    }

    public String read(String Area) {
        return this.read(Area, "", null);
    }

    public String read(String Area, String mdmCode) {
        return this.read(Area, mdmCode, null);
    }

    public String read(String Area, JSONObject encry) {
        return this.read(Area, "", encry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(String Area, String mdmCode, JSONObject encry) {
        try {
            if (encry != null && encry != JSONObject.NULL && encry.has("encryType")) {
                this.setEncryType(encry.getString("encryType"));
                this.setEncryKey(encry.getString("encryKey"));
            }
        }
        catch (JSONException e) {
            Log.e((String)"setEncry", (String)("JSONException" + e.getMessage()));
        }
        this.setMdmCode(mdmCode);
        boolean bl = isA10 = !"".equals(mdmCode);
        if (AFApplication.card.getReader() instanceof LDNativeReader && !LDDevice.login()) {
            CardAgent.log("LD device login fail");
            return this.getReadErrMsg(-10);
        }
        CardAgent.log("Get Card Type");
        Chip chip = this.reader.getNvlChip();
        if (chip == null) {
            CardAgent.log("GetType Erro");
            return this.getReadErrMsg(-6);
        }
        if (!this.reader.openDevice(chip)) {
            CardAgent.log("Open Device Fail");
            return this.getReadErrMsg(-6);
        }
        if (chip.chipName == -1) {
            CardAgent.log("Unknow Card");
            return this.getReadErrMsg(-1);
        }
        if (chip.chipName == -3) {
            CardAgent.log("Error Card");
            return this.getReadErrMsg(-6);
        }
        if (chip.chipName == -2) {
            CardAgent.log("Double Card");
            return this.getReadErrMsg(-9);
        }
        if (chip.chipName == 9 && AFApplication.card.getReader() instanceof CTChangAnReader) {
            return this.readCaCpu();
        }
        try {
            String result;
            String pass;
            chip.addid = 16;
            boolean ret = this.reader.read(chip);
            if (!ret) {
                CardAgent.log("Read Card Error");
                String string2 = this.getReadErrMsg(-1);
                return string2;
            }
            if (chip.isBlankChip()) {
                CardAgent.log("Blank Card");
                String string3 = this.getReadErrMsg(-3);
                return string3;
            }
            if (isA10) {
                String string4 = this.A10Read(chip, encry);
                return string4;
            }
            if (chip.chipName == 0) {
                pass = this.get102Pass(chip, 1, Area);
                if (chip.state != 0) {
                    String string5 = this.getReadErrMsg(chip.state);
                    return string5;
                }
                chip.secret = pass;
                ret = this.reader.read(chip);
                if (!ret) {
                    CardAgent.log("Read Card Error");
                    String string6 = this.getReadErrMsg(-1);
                    return string6;
                }
            }
            if (chip.chipName == 6) {
                pass = this.get1608PassArea7(chip, 1, Area);
                if (chip.state != 0) {
                    String string7 = this.getReadErrMsg(chip.state);
                    return string7;
                }
                chip.secret_1608 = pass;
                ret = this.reader.read(chip);
                if (!ret) {
                    CardAgent.log("Read Card Error");
                    String string8 = this.getReadErrMsg(-1);
                    return string8;
                }
                pass = this.get1608PassArea2(chip, 1, Area);
                if (chip.state != 0) {
                    String string9 = this.getReadErrMsg(chip.state);
                    return string9;
                }
                chip.secret = pass;
                ret = this.reader.read(chip);
                if (!ret) {
                    CardAgent.log("Read Card Error");
                    String string10 = this.getReadErrMsg(-1);
                    return string10;
                }
            }
            if (chip.chipName == 8) {
                pass = this.getM1Pass(chip, 1, Area);
                if (chip.state != 0) {
                    String string11 = this.getReadErrMsg(chip.state);
                    return string11;
                }
                chip.secret = pass;
                chip.addid = 20;
                ret = this.reader.read(chip);
                if (!ret) {
                    CardAgent.log("Read Card Error");
                    String string12 = this.getReadErrMsg(-1);
                    return string12;
                }
            }
            if (chip.chipName == 11 && chip.secret == null) {
                pass = this.get153RdPwd(chip, 1, Area);
                if (chip.state != 0) {
                    String string13 = this.getReadErrMsg(chip.state);
                    return string13;
                }
                chip.secret = pass;
                ret = this.reader.read(chip);
                if (!ret) {
                    CardAgent.log("Read Card Error");
                    String string14 = this.getReadErrMsg(-1);
                    return string14;
                }
            }
            if ((result = this.cloudRead(chip, Area)) == null) {
                String string15 = this.getReadErrMsg(-4);
                return string15;
            }
            String string16 = this.getReadErrMsg(0, result);
            return string16;
        }
        finally {
            this.reader.closeDevice(chip);
            if (AFApplication.card.getReader() instanceof LDNativeReader) {
                LDDevice.logout();
            }
            isA10 = false;
        }
    }

    public String sell(JSONObject params) {
        return this.sell(params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sell(JSONObject params, JSONObject encry) {
        if (AFApplication.card.getReader() instanceof LDNativeReader && !LDDevice.login()) {
            CardAgent.log("LD device login fail");
            return this.getWriteErrMsg(-10);
        }
        try {
            if (encry != null && encry != JSONObject.NULL) {
                this.setEncryType(encry.getString("encryType"));
                this.setEncryKey(encry.getString("encryKey"));
            }
            String code = params.has("mdmCode") ? params.getString("mdmCode") : "";
            this.setMdmCode(code);
            isA10 = !"".equals(this.mdmCode);
        }
        catch (JSONException e) {
            Log.e((String)"setMdmCode", (String)("JSONException" + e.getMessage()));
        }
        CardAgent.log("Get Card Type");
        Chip chip = this.reader.getNvlChip();
        if (chip == null) {
            CardAgent.log("GetType Erro");
            return this.getWriteErrMsg(-6);
        }
        if (!this.reader.openDevice(chip)) {
            CardAgent.log("Open Device Fail");
            return this.getWriteErrMsg(-6);
        }
        if (chip.chipName == -1) {
            CardAgent.log("Unknow Card");
            return this.getWriteErrMsg(-1);
        }
        if (chip.chipName == -3) {
            CardAgent.log("Error Card");
            return this.getWriteErrMsg(-6);
        }
        if (chip.chipName == -2) {
            CardAgent.log("Double Card");
            return this.getWriteErrMsg(-9);
        }
        if (chip.chipName == 9 && AFApplication.card.getReader() instanceof CTChangAnReader) {
            return this.writeCaCpu(params);
        }
        try {
            chip.addid = 16;
            boolean ret = this.reader.read(chip);
            if (!ret) {
                CardAgent.log("Read Card Error");
                String string2 = this.getWriteErrMsg(-1);
                return string2;
            }
            if (chip.isBlankChip()) {
                CardAgent.log("Blank Card");
                String string3 = this.getWriteErrMsg(-3);
                return string3;
            }
            if (isA10) {
                String string4 = this.sellA10Card(chip, params);
                return string4;
            }
            if (chip.chipName == 1001) {
                params.put("CardType", (Object)"1001");
                params.put("opid", 1);
                params.put("operatetype", 2);
                String string5 = this.sell(chip, params);
                return string5;
            }
            if (chip.chipName == 11) {
                params.put("CardType", (Object)"11");
                params.put("opid", 1);
                params.put("operatetype", 2);
                String string6 = this.sell(chip, params);
                return string6;
            }
            if (chip.chipName == 1) {
                params.put("CardType", (Object)"1");
                params.put("opid", 1);
                params.put("operatetype", 1);
                String string7 = this.sell(chip, params);
                return string7;
            }
            if (chip.chipName == 0) {
                params.put("CardType", (Object)"0");
                params.put("opid", 1);
                params.put("operatetype", 2);
                String string8 = this.sell102(chip, params);
                return string8;
            }
            if (chip.chipName == 2) {
                params.put("CardType", (Object)"2");
                params.put("opid", 1);
                params.put("operatetype", 1);
                String string9 = this.sell(chip, params);
                return string9;
            }
            if (chip.chipName == 3) {
                params.put("CardType", (Object)"3");
                params.put("opid", 1);
                params.put("operatetype", 1);
                String string10 = this.sell(chip, params);
                return string10;
            }
            if (chip.chipName == 6) {
                params.put("CardType", (Object)"6");
                params.put("opid", 1);
                params.put("operatetype", 2);
                String string11 = this.sell1608(chip, params);
                return string11;
            }
            if (chip.chipName == 7) {
                params.put("CardType", (Object)"7");
                params.put("opid", 1);
                params.put("operatetype", 7);
                String string12 = this.sell(chip, params);
                return string12;
            }
            if (chip.chipName == 8) {
                params.put("CardType", (Object)"8");
                params.put("opid", 1);
                params.put("operatetype", 2);
                String string13 = this.sellM1card(chip, params);
                return string13;
            }
            if (chip.chipName == 10) {
                params.put("CardType", (Object)"10");
                params.put("opid", 1);
                params.put("operatetype", 2);
                String string14 = this.sell(chip, params);
                return string14;
            }
            String string15 = this.getWriteErrMsg(-6);
            return string15;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                String string16 = this.getWriteErrMsg(-4);
                return string16;
            }
            String string17 = this.getWriteErrMsg(-5);
            return string17;
        }
        finally {
            this.reader.closeDevice(chip);
            isA10 = false;
        }
    }

    private String sellA10Card(Chip chip, JSONObject params) {
        try {
            if (chip.chipName == 0) {
                chip.secret = this.get102Pass(chip, params);
                boolean ret = this.reader.read(chip);
                if (!ret) {
                    CardAgent.log("Read Card Error");
                    return this.getWriteErrMsg(-1);
                }
            } else if (chip.chipName == 6) {
                String password;
                chip.secret_1608 = password = this.get1608PassArea7(chip, params);
                boolean ret = this.reader.read(chip);
                if (!ret) {
                    CardAgent.log("Read Card Error");
                    return this.getWriteErrMsg(-1);
                }
                chip.secret = password = this.get1608PassArea2(chip, params);
                ret = this.reader.read(chip);
                if (!ret) {
                    CardAgent.log("Read Card Error");
                    return this.getWriteErrMsg(-1);
                }
            }
            if (chip.chipName == 7) {
                return this.getWriteErrMsg(5);
            }
            JSONObject obj = params.getJSONObject("writingData");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Kdata", (Object)obj.getString("cardWriting"));
            jsonObject.put("CscKmm", (Object)obj.getString("checkPassword"));
            jsonObject.put("WscKmm", (Object)obj.getString("updatePassword"));
            jsonObject.put("Kmm", (Object)obj.getString("password"));
            String akmm = jsonObject.getString("Kmm");
            String Kdata = jsonObject.getString("Kdata");
            if (chip.chipName == 6) {
                return this.writeWX1608(jsonObject, chip);
            }
            if (chip.chipName == 3 || chip.chipName == 2) {
                boolean r = Kdata.length() / 2 >= chip.buf.length ? this.reader.write(chip, 0, 0, chip.buf.length, HexDump.hexStringToByteArray(Kdata.substring(0, chip.buf.length * 2)), null) : this.reader.write(chip, 0, 0, Kdata.length() / 2, HexDump.hexStringToByteArray(Kdata), null);
                if (!r) {
                    CardAgent.log("Write Error");
                    return this.getWriteErrMsg(-5);
                }
                return this.getWriteErrMsg(0, akmm);
            }
            if (chip.chipName != 0) {
                chip.secret = jsonObject.getString("CscKmm");
            }
            if (!this.reader.verifyPwd(chip, 0, HexDump.hexStringToByteArray(chip.secret))) {
                CardAgent.log("verifyPwd Error");
                return this.getWriteErrMsg(-2);
            }
            String hexToWrite = jsonObject.getString("Kdata");
            if (chip.chipName != 1) {
                String hexOnCard = chip.getRegisters();
                ArrayList<Fragment> segments = Fragment.FindFragment(hexToWrite, hexOnCard);
                for (Fragment f : segments) {
                    boolean r = this.reader.write(chip, 0, f.offset, f.length, HexDump.hexStringToByteArray(hexToWrite.substring(f.offset * 2, (f.offset + f.length) * 2)), null);
                    if (!r) {
                        CardAgent.log("Write Data Error");
                        return this.getWriteErrMsg(-5);
                    }
                    CardAgent.log("Write Data Success");
                }
            } else {
                boolean r = this.reader.write(chip, 0, 32, 208, HexDump.hexStringToByteArray(hexToWrite.substring(64, 480)), null);
                if (!r) {
                    CardAgent.log("Write Data Error");
                    return this.getWriteErrMsg(-5);
                }
                CardAgent.log("Write Data Success");
            }
            if (this.needChangePwd(chip) && !this.reader.changePwd(chip, 0, null, HexDump.hexStringToByteArray(this.getNewPwd(chip)))) {
                CardAgent.log("ChangePwd Fail");
                return this.getWriteErrMsg(-8);
            }
            CardAgent.log("Write Card Success");
            return this.getWriteErrMsg(0, akmm);
        }
        catch (Exception e) {
            CardAgent.log("\u5199\u5361\u9519\u8bef" + e.getMessage() + " : " + e.toString());
            if (e instanceof IOException) {
                return this.getWriteErrMsg(-4);
            }
            return this.getWriteErrMsg(-5);
        }
    }

    private String readCaCpu() {
        ReadCard rc = new ReadCard();
        CTDevice.careader.readCard(rc);
        if (rc != null) {
            CardAgent.log("Read Card Success");
            return "{\"code\":200,\"msg\":{\"CardID\":\"" + rc.cardNum + "\",\"Factory\":\"ChanganCpu\",\"Times\":" + rc.buyCount + ",\"Money\":" + rc.remainAmount + ",\"Gas\":0.0,\"CardType\":\"" + rc.cardType + "\"}}";
        }
        CardAgent.log("Read Card Error");
        return this.getWriteErrMsg(-6);
    }

    private String writeCaCpu(JSONObject params) {
        ReadCard rc = new ReadCard();
        CTDevice.careader.readCard(rc);
        if (rc == null) {
            CardAgent.log("Write Card Not Supported");
            return this.getWriteErrMsg(-6);
        }
        try {
            WriCard wc = new WriCard();
            wc.amount = Integer.parseInt(params.getString("money"));
            wc.buyCount = Integer.parseInt(params.getString("cs"));
            wc.cardNum = params.getString("kh");
            wc.cardType = Integer.parseInt(params.getString("klx"));
            wc.serverIP = params.getString("prmt_server");
            wc.wriParm = params.getString("card_params");
            rc = new ReadCard();
            int ret = CTDevice.careader.writeCard(rc, wc);
            if (ret == 0) {
                CardAgent.log("Write Card Success");
                return this.getWriteErrMsg(0, "212");
            }
            if (ret == 17) {
                CardAgent.log("Write Card Not Supported");
                return this.getWriteErrMsg(-6);
            }
            if (ret == 7) {
                CardAgent.log("Write Card Not Supported");
                return this.getWriteErrMsg(-6);
            }
            if (ret == 5) {
                CardAgent.log("Write Card Not User Card");
                return this.getWriteErrMsg(-5);
            }
            CardAgent.log("Write Card Error");
            return this.getWriteErrMsg(-5);
        }
        catch (Exception e) {
            CardAgent.log("Write Card Exception" + e.getMessage());
            return this.getWriteErrMsg(-6);
        }
    }

    private String sell1608(Chip chip, JSONObject params) throws Exception {
        String Area = params.has("AREA") ? params.getString("AREA") : "";
        String pass = this.get1608PassArea7(chip, 1, Area);
        if (chip.state != 0) {
            return this.getReadErrMsg(chip.state);
        }
        chip.secret_1608 = pass;
        boolean r = this.reader.read(chip);
        if (!r) {
            CardAgent.log("Read Card Error");
            return this.getWriteErrMsg(-1);
        }
        pass = this.get1608PassArea2(chip, 1, Area);
        if (chip.state != 0) {
            return this.getReadErrMsg(chip.state);
        }
        chip.secret = pass;
        r = this.reader.read(chip);
        if (!r) {
            CardAgent.log("Read Card Error");
            return this.getWriteErrMsg(-1);
        }
        return this.sell(chip, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String issue(JSONObject params) {
        Chip chip = this.reader.getNvlChip();
        if (chip == null) {
            return this.getWriteErrMsg(-6);
        }
        if (!this.reader.openDevice(chip)) {
            return this.getWriteErrMsg(-6);
        }
        try {
            boolean ret = this.reader.read(chip);
            if (!ret) {
                String string2 = this.getWriteErrMsg(-1);
                return string2;
            }
            if (chip.chipName == 1) {
                params.put("CardType", (Object)"1");
                params.put("opid", 1);
                params.put("operatetype", 1);
                String string3 = this.issue(chip, params);
                return string3;
            }
            if (chip.chipName == 0) {
                params.put("CardType", (Object)"0");
                params.put("opid", 1);
                params.put("operatetype", 2);
                params.put("CscKmm", (Object)"F0F0");
                String string4 = this.issue102(chip, params);
                return string4;
            }
            if (chip.chipName == 3) {
                params.put("CardType", (Object)"3");
                params.put("opid", 1);
                params.put("operatetype", 1);
                String string5 = this.issue(chip, params);
                return string5;
            }
            if (chip.chipName == 6) {
                params.put("CardType", (Object)"6");
                params.put("opid", 1);
                params.put("operatetype", 1);
                String string6 = this.issue1608(chip, params);
                return string6;
            }
            String string7 = this.getWriteErrMsg(-6);
            return string7;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                String string8 = this.getWriteErrMsg(-4);
                return string8;
            }
            String string9 = this.getWriteErrMsg(-5);
            return string9;
        }
        finally {
            this.reader.closeDevice(chip);
        }
    }

    private String issue102(Chip chip, JSONObject params) throws Exception {
        String Area = params.has("AREA") ? params.getString("AREA") : "";
        String pass = this.get102Pass(chip, 0, Area);
        if (chip.state != 0) {
            return this.getWriteErrMsg(chip.state);
        }
        chip.secret = pass;
        boolean ret = this.reader.read(chip);
        if (!ret) {
            return this.getWriteErrMsg(-1);
        }
        return this.issue(chip, params);
    }

    private String issue1608(Chip chip, JSONObject params) throws Exception {
        String Area = params.has("AREA") ? params.getString("AREA") : "";
        String pass = this.get1608PassArea7(chip, 1, Area);
        if (chip.state != 0) {
            return this.getReadErrMsg(chip.state);
        }
        chip.secret_1608 = pass;
        boolean r = this.reader.read(chip);
        if (!r) {
            CardAgent.log("Read Card Error");
            return this.getWriteErrMsg(-1);
        }
        pass = this.get1608PassArea2(chip, 1, Area);
        if (chip.state != 0) {
            return this.getReadErrMsg(chip.state);
        }
        chip.secret = pass;
        r = this.reader.read(chip);
        if (!r) {
            CardAgent.log("Read Card Error");
            return this.getWriteErrMsg(-1);
        }
        return this.issue(chip, params);
    }

    private String issue(Chip chip, JSONObject params) throws Exception {
        String uuid = UUID.randomUUID().toString();
        String url = this.cloudUrl + "WriteNewCard";
        if (!params.has("ulen") || params.getInt("ulen") != 0) {
            url = url + "/" + params.get("factory") + "/" + params.get("kmm") + "/" + params.get("kzt") + "/" + params.get("kh") + "/" + params.get("dqdm") + "/" + params.get("yhh") + "/" + params.get("tm") + "/" + params.get("ql") + "/" + params.get("csql") + "/" + params.get("ccsql") + "/" + params.get("cs") + "/" + params.get("ljgql") + "/" + params.get("bkcs") + "/" + params.get("ljyql") + "/" + params.get("bjql") + "/" + params.get("czsx") + "/" + params.get("tzed") + "/" + params.get("sqrq") + "/" + params.get("cssqrq") + "/" + params.get("oldprice") + "/" + params.get("newprice") + "/" + params.get("sxrq") + "/" + params.get("sxbj") + "/" + params.get("klx") + "/" + params.get("meterid");
        }
        params.put("CardData", (Object)chip.getRegisters());
        if (chip.chipName == 7) {
            params.put("GUID", (Object)uuid);
            params.put("socket_url", (Object)this.getSocketUrl());
            CPUSocket CPUSocket2 = new CPUSocket(params.toString());
            CPUSocket2.start();
        }
        HttpPost httpPost = new HttpPost(url);
        String data = params.toString().replace("\n", "").replace("\r", "").replace(" ", "").replace("\t", "");
        httpPost.setEntity((HttpEntity)new StringEntity(EncryUtil.encry(data, this.encryType, this.encryKey), "UTF8"));
        HttpClient hc = CommUtil.getCardServiceHttpClient();
        JSONObject obj = null;
        HttpResponse response = hc.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            return this.getWriteErrMsg(-4);
        }
        String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
        if (!obj.isNull("Exception")) {
            CardAgent.log("CloudWrite notNull Exception");
            return this.getWriteErrMsg(-7);
        }
        if (!obj.isNull("Err")) {
            CardAgent.log("CloudWrite notNull Error");
            return this.getWriteErrMsg(-4);
        }
        if (obj.isNull("CscKmm")) {
            CardAgent.log("CloudWrite Null CscKmm");
            return this.getWriteErrMsg(-7);
        }
        if (chip.chipName == 7) {
            return this.getWriteErrMsg(0, obj.getString("Kmm"));
        }
        if (chip.chipName != 8 && chip.chipName != 0) {
            chip.secret = chip.removeDuplicatePass(obj.getString("CscKmm"));
        }
        chip.newSecret = obj.getString("WscKmm");
        String akmm = obj.getString("Kmm");
        if (chip.chipName == 6) {
            return this.writeWX1608(obj, chip);
        }
        if (chip.chipName == 11) {
            return this.writear153(obj, chip);
        }
        if (chip.chipName == 8) {
            return this.writeM1card(obj, chip);
        }
        if (chip.chipName == 10) {
            return this.writeM1CardTT(obj, chip);
        }
        String Kdata = obj.getString("Kdata");
        if (chip.chipName == 3 || chip.chipName == 2) {
            boolean r = false;
            r = Kdata.length() / 2 >= chip.buf.length ? this.reader.write(chip, 0, 0, chip.buf.length, HexDump.hexStringToByteArray(Kdata.substring(0, chip.buf.length * 2)), null) : this.reader.write(chip, 0, 0, Kdata.length() / 2, HexDump.hexStringToByteArray(Kdata), null);
            if (!r) {
                CardAgent.log("Write Error");
                return this.getWriteErrMsg(-5);
            }
            return this.getWriteErrMsg(0, akmm);
        }
        if (!this.reader.verifyPwd(chip, 0, HexDump.hexStringToByteArray(chip.secret))) {
            return this.getWriteErrMsg(-2);
        }
        String hexToWrite = obj.getString("Kdata");
        String hexOnCard = chip.getRegisters();
        ArrayList<Fragment> segments = Fragment.FindFragment(hexToWrite, hexOnCard);
        for (Fragment f : segments) {
            boolean r = this.reader.write(chip, 0, f.offset, f.length, HexDump.hexStringToByteArray(hexToWrite.substring(f.offset * 2, (f.offset + f.length) * 2)), null);
            if (!r) {
                CardAgent.log("Write Data Error");
                return this.getWriteErrMsg(-5);
            }
            CardAgent.log("Write Data Success");
        }
        if (this.needChangePwd(chip) && !this.reader.changePwd(chip, 0, null, HexDump.hexStringToByteArray(this.getNewPwd(chip)))) {
            CardAgent.log("ChangePwd Fail");
            return this.getWriteErrMsg(-8);
        }
        CardAgent.log("Write Card Success");
        return this.getWriteErrMsg(0, this.token);
    }

    private String sell102(Chip chip, JSONObject params) throws Exception {
        String pass = this.get102Pass(chip, 0, params.has("AREA") ? params.getString("AREA") : "");
        if (chip.state != 0) {
            return this.getWriteErrMsg(chip.state);
        }
        chip.secret = pass;
        boolean ret = this.reader.read(chip);
        if (!ret) {
            CardAgent.log("Write Card Error");
            return this.getWriteErrMsg(-1);
        }
        return this.sell(chip, params);
    }

    private String writear153(JSONObject obj, Chip chip) throws Exception {
        String[] writeDatas = obj.getString("Kdata").toUpperCase().split("\\|");
        String[] cardDatas = chip.getRegisters().split("\\|");
        String[] secrets = chip.secret.split("\\|");
        String secret = CardAgent.get1608AreaPwd(0, 1, secrets);
        if (!this.reader.verifyPwd(chip, 0, HexDump.hexStringToByteArray(secret))) {
            return this.getWriteErrMsg(-2);
        }
        for (int i = 0; i < 3; ++i) {
            String hexToWrite = writeDatas[i + 2];
            String hexOnCard = cardDatas[i + 2];
            ArrayList<Fragment> segments = Fragment.FindFragment(hexToWrite, hexOnCard);
            for (Fragment f : segments) {
                boolean r = this.reader.write(chip, i, f.offset, f.length, HexDump.hexStringToByteArray(hexToWrite.substring(f.offset * 2, (f.offset + f.length) * 2)), null);
                if (!r) {
                    CardAgent.log("Write Data Error");
                    return this.getWriteErrMsg(-5);
                }
                CardAgent.log("Write Data Success");
            }
        }
        CardAgent.log("Write Card Success");
        return this.getWriteErrMsg(0, obj.getString("Kmm"));
    }

    private static String get1608AreaPwd(int area, int type, String[] pwd) {
        if (type == 0) {
            return pwd[(area + 1) * 2 - 1];
        }
        if (type == 1) {
            return pwd[(area + 1) * 2 - 2];
        }
        return null;
    }

    private String writeWX1608(JSONObject obj, Chip chip) throws Exception {
        String[] writeDatas = obj.getString("Kdata").toUpperCase().split("\\|");
        String[] cardDatas = chip.getRegisters().split("\\|");
        String[] secrets = chip.secret.split("\\|");
        for (int i = 7; i >= 0; --i) {
            String hexToWrite = writeDatas[i + 2];
            String hexOnCard = cardDatas[i + 2];
            String secret = CardAgent.get1608AreaPwd(i, 1, secrets);
            if (hexToWrite.equals("") || hexOnCard.equals("") || secret.equals("")) continue;
            ArrayList<Fragment> segments = Fragment.FindFragment(hexToWrite, hexOnCard);
            for (Fragment f : segments) {
                boolean r = this.reader.write(chip, i, f.offset, f.length, HexDump.hexStringToByteArray(hexToWrite.substring(f.offset * 2, (f.offset + f.length) * 2)), HexDump.hexStringToByteArray(chip.removeDuplicatePass(secret)));
                if (!r) {
                    CardAgent.log("Write Data Error");
                    return this.getWriteErrMsg(-5);
                }
                CardAgent.log("Write Data Success");
            }
        }
        CardAgent.log("Write Card Success");
        return this.getWriteErrMsg(0, obj.getString("Kmm"));
    }

    private String get1608PassArea2(Chip chip, int opid, String AREA) {
        try {
            chip.state = 0;
            boolean flag = false;
            HttpPost httpPost = null;
            String body = "";
            httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            body = "{\"CardType\" : \"6\",\"operatetype\":\"1\",\"cardinfo\" :\"" + chip.bytes2HexStr(0, 128) + "|23272b2f33373b3f||||||||" + chip.bytes2HexStr(128, 256) + "|00\",\"opid\":\"" + opid + "\", \"AREA\":\"" + AREA + "\", \"Wsckmm\":\"f0f0\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(EncryUtil.encry(body, this.encryType, this.encryKey), "UTF8"));
            HttpClient hc = CommUtil.getCardServiceHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                CardAgent.log("Get1608PassArea2 NetError " + response.getStatusLine().getStatusCode());
                chip.state = -4;
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
            if (obj.isNull("CscKmm")) {
                CardAgent.log("Get1608PassArea2 Null CscKmm");
                chip.state = -7;
                return null;
            }
            return obj.getString("CscKmm");
        }
        catch (Exception e) {
            CardAgent.log("Get1608PassArea2 Error " + e.getMessage());
            chip.state = -4;
            return null;
        }
    }

    private String get1608PassArea7(Chip chip, int opid, String AREA) {
        try {
            chip.state = 0;
            boolean flag = false;
            HttpPost httpPost = null;
            String body = "";
            httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            body = "{\"CardType\" : \"6\",\"operatetype\":\"0\",\"cardinfo\" :\"" + chip.bytes2HexStr(0, 128) + "|23272b2f33373b3f|||||||||00\",\"opid\":\"" + opid + "\", \"AREA\":\"" + AREA + "\", \"Wsckmm\":\"f0f0\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(EncryUtil.encry(body, this.encryType, this.encryKey), "UTF8"));
            HttpClient hc = CommUtil.getCardServiceHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                CardAgent.log("Get1608PassArea7 NetError " + response.getStatusLine().getStatusCode());
                chip.state = -4;
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
            if (obj.isNull("CscKmm")) {
                CardAgent.log("Get1608PassArea7 Null CscKmm");
                chip.state = -7;
                return null;
            }
            return EncryUtil.decry(obj.getString("CscKmm"), this.encryType, this.encryKey);
        }
        catch (Exception e) {
            CardAgent.log("Get1608PassArea7 Error " + e.getMessage());
            chip.state = -4;
            return null;
        }
    }

    private String sell(Chip chip, JSONObject params) throws Exception {
        String url = this.cloudUrl;
        String uuid = UUID.randomUUID().toString();
        if (!params.has("ulen") || params.getInt("ulen") == 18) {
            url = url + "WriteGasCard/" + params.get("factory") + "/" + params.get("kmm") + "/" + params.get("kh") + "/" + params.get("dqdm") + "/" + params.get("ql") + "/" + params.get("csql") + "/" + params.get("ccsql") + "/" + params.get("cs") + "/" + params.get("ljgql") + "/" + params.get("bjql") + "/" + params.get("czsx") + "/" + params.get("tzed") + "/" + params.get("sqrq") + "/" + params.get("cssqrq") + "/" + params.get("oldprice") + "/" + params.get("newprice") + "/" + params.get("sxrq") + "/" + params.get("sxbj");
        } else if (params.getInt("ulen") == 25) {
            url = url + "WriteGasCard/" + params.get("factory") + "/" + params.get("kmm") + "/" + params.get("kzt") + "/" + params.get("kh") + "/" + params.get("dqdm") + "/" + params.get("yhh") + "/" + params.get("tm") + "/" + params.get("ql") + "/" + params.get("csql") + "/" + params.get("ccsql") + "/" + params.get("cs") + "/" + params.get("ljgql") + "/" + params.get("bkcs") + "/" + params.get("ljyql") + "/" + params.get("bjql") + "/" + params.get("czsx") + "/" + params.get("tzed") + "/" + params.get("sqrq") + "/" + params.get("cssqrq") + "/" + params.get("oldprice") + "/" + params.get("newprice") + "/" + params.get("sxrq") + "/" + params.get("sxbj") + "/" + params.get("klx") + "/" + params.get("meterid");
        } else if (params.getInt("ulen") == 0) {
            url = url + "WriteGasCard";
        }
        CardAgent.log("Cloud Params Length:" + (params.has("ulen") ? params.getInt("ulen") : 0));
        params.put("CardData", (Object)chip.getRegisters());
        if (chip.chipName == 7) {
            params.put("GUID", (Object)uuid);
            params.put("socket_url", (Object)this.getSocketUrl());
            CPUSocket CPUSocket2 = new CPUSocket(params.toString());
            CPUSocket2.start();
        }
        HttpPost httpPost = new HttpPost(url);
        String data = params.toString().replace("\n", "").replace("\r", "").replace(" ", "").replace("\t", "");
        httpPost.setEntity((HttpEntity)new StringEntity(EncryUtil.encry(data, this.encryType, this.encryKey), "UTF8"));
        HttpClient hc = CommUtil.getCardServiceHttpClient();
        JSONObject obj = null;
        HttpResponse response = hc.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            return this.getWriteErrMsg(-4);
        }
        String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
        if (!obj.isNull("Exception")) {
            CardAgent.log("CloudWrite notNull Exception");
            return this.getWriteErrMsg(-7);
        }
        if (!obj.isNull("Err")) {
            CardAgent.log("CloudWrite notNull Error");
            return this.getWriteErrMsg(-4);
        }
        if (obj.isNull("CscKmm")) {
            CardAgent.log("CloudWrite Null CscKmm");
            return this.getWriteErrMsg(-7);
        }
        if (chip.chipName == 7) {
            return this.getWriteErrMsg(0, obj.getString("Kmm"));
        }
        if (chip.chipName != 8 && chip.chipName != 0) {
            chip.secret = chip.removeDuplicatePass(obj.getString("CscKmm"));
        }
        chip.newSecret = obj.getString("WscKmm");
        String akmm = obj.getString("Kmm");
        if (chip.chipName == 6) {
            return this.writeWX1608(obj, chip);
        }
        if (chip.chipName == 11) {
            return this.writear153(obj, chip);
        }
        if (chip.chipName == 1001) {
            return this.write5557(obj, chip);
        }
        if (chip.chipName == 8) {
            return this.writeM1card(obj, chip);
        }
        if (chip.chipName == 10) {
            return this.writeM1CardTT(obj, chip);
        }
        String Kdata = obj.getString("Kdata");
        if (chip.chipName == 3 || chip.chipName == 2) {
            boolean r = false;
            r = Kdata.length() / 2 >= chip.buf.length ? this.reader.write(chip, 0, 0, chip.buf.length, HexDump.hexStringToByteArray(Kdata.substring(0, chip.buf.length * 2)), null) : this.reader.write(chip, 0, 0, Kdata.length() / 2, HexDump.hexStringToByteArray(Kdata), null);
            if (!r) {
                CardAgent.log("Write Error");
                return this.getWriteErrMsg(-5);
            }
            return this.getWriteErrMsg(0, akmm);
        }
        if (!this.reader.verifyPwd(chip, 0, HexDump.hexStringToByteArray(chip.secret))) {
            return this.getWriteErrMsg(-2);
        }
        String hexToWrite = obj.getString("Kdata");
        String hexOnCard = chip.getRegisters();
        ArrayList<Fragment> segments = Fragment.FindFragment(hexToWrite, hexOnCard);
        for (Fragment f : segments) {
            boolean r = this.reader.write(chip, 0, f.offset, f.length, HexDump.hexStringToByteArray(hexToWrite.substring(f.offset * 2, (f.offset + f.length) * 2)), null);
            if (!r) {
                CardAgent.log("Write Data Error");
                return this.getWriteErrMsg(-5);
            }
            CardAgent.log("Write Data Success");
        }
        if (this.needChangePwd(chip) && !this.reader.changePwd(chip, 0, null, HexDump.hexStringToByteArray(this.getNewPwd(chip)))) {
            CardAgent.log("ChangePwd Fail");
            return this.getWriteErrMsg(-8);
        }
        CardAgent.log("Write Card Success");
        return this.getWriteErrMsg(0, this.token);
    }

    private String write5557(JSONObject obj, Chip chip) throws Exception {
        int i;
        String writeDatas = obj.getString("Kdata").toUpperCase();
        String secret = obj.getString("CscKmm").toUpperCase();
        String change = obj.getString("WscKmm").toUpperCase();
        for (i = 0; i < secret.length() / 8; ++i) {
        }
        i = 1;
        while (i < 7) {
            String string2 = writeDatas.substring(8 * i, 8 * ++i);
        }
        CardAgent.log("Write Card Success");
        return this.getWriteErrMsg(0, obj.getString("Kmm"));
    }

    private String getNewPwd(Chip chip) {
        if (chip.chipName == 1) {
            return chip.newSecret.substring(0, 6);
        }
        if (chip.chipName == 0) {
            return chip.newSecret.substring(0, 4);
        }
        return chip.newSecret;
    }

    private boolean needChangePwd(Chip chip) {
        if (chip.newSecret != null && !chip.newSecret.equals("") && !chip.newSecret.equals("nn")) {
            if (chip.chipName == 1) {
                return chip.newSecret.length() >= 6 && !chip.newSecret.startsWith("000000");
            }
            if (chip.chipName == 0) {
                return chip.newSecret.length() >= 4 && !chip.newSecret.startsWith("0000") && chip.newSecret.substring(0, 4).equals(chip.secret);
            }
            return false;
        }
        return false;
    }

    private String getWriteErrMsg(int errCode) {
        return this.getWriteErrMsg(errCode, null);
    }

    private String getWriteErrMsg(int errCode, String kmm) {
        CardAgent.log("errCode  = " + errCode);
        if (AFApplication.card.getReader() instanceof LDNativeReader) {
            LDDevice.logout();
        }
        if (errCode == 0) {
            CardAgent.log("Write finish");
            CardAgent.postlog();
            return "{\"code\":200, \"msg\":{\"Err\":null,\"Exception\":null,\"Kmm\":\"" + kmm + "\"}}";
        }
        String json = "{\"code\":500, \"msg\":{\"Err\":\"";
        String msg = "\u672a\u77e5\u9519\u8bef\uff01";
        if (errorMap.containsKey(errCode)) {
            msg = errorMap.get(errCode);
        }
        json = json + msg + "\",\"Exception\":\"" + msg + "\"}}";
        CardAgent.log("Write finish");
        CardAgent.postlog();
        return json;
    }

    public String getReadErrMsg(int errCode) {
        return this.getReadErrMsg(errCode, null);
    }

    public String getReadErrMsg(int errCode, String result) {
        if (AFApplication.card.getReader() instanceof LDNativeReader) {
            LDDevice.logout();
        }
        if (errCode == 0) {
            CardAgent.log("Read finish");
            CardAgent.postlog();
            return "{\"code\":200, \"msg\":" + result + "}";
        }
        String json = "{\"code\":500, \"msg\":";
        json = errorMap.containsKey(errCode) ? json + "\"" + errorMap.get(errCode) + "\"}" : json + "\"\u672a\u77e5\u9519\u8bef\uff01\"}";
        CardAgent.log("Read finish");
        CardAgent.postlog();
        return json;
    }

    private String get102Pass(Chip chip, int opid, String AREA) {
        try {
            chip.state = 0;
            boolean flag = false;
            HttpPost httpPost = null;
            String body = "";
            httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            body = "{\"CardType\" : \"0\",\"operatetype\":\"0\",\"cardinfo\" :\"" + chip.bytes2HexStr(0, 177) + "\",\"opid\":\"" + opid + "\", \"AREA\":\"" + AREA + "\", \"Wsckmm\":\"f0f0\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(EncryUtil.encry(body, this.encryType, this.encryKey), "UTF8"));
            HttpClient hc = CommUtil.getCardServiceHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                CardAgent.log("Get102Pass NetError " + response.getStatusLine().getStatusCode());
                chip.state = -4;
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
            if (flag) {
                return chip.removeDuplicatePass(obj.getString("checkPassword"));
            }
            if (obj.isNull("CscKmm")) {
                CardAgent.log("Get102Pass Null CscKmm");
                chip.state = -7;
                return null;
            }
            return chip.removeDuplicatePass(obj.getString("CscKmm"));
        }
        catch (Exception e) {
            CardAgent.log("Get102Pass Error:" + e.getMessage());
            chip.state = -4;
            return null;
        }
    }

    private String get102Pass2(Chip chip, int opid) {
        try {
            chip.state = 0;
            HttpPost httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            String body = "{\"CardType\" : \"0\",\"operatetype\":\"0\",\"cardinfo\" :\"" + chip.bytes2HexStr(0, 22) + "\",\"opid\":\"" + opid + "\", \"Wsckmm\":\"f0f0\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(EncryUtil.encry(body, this.encryType, this.encryKey), "UTF8"));
            HttpClient hc = CommUtil.getCardServiceHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                CardAgent.log("Get102Pass NetError " + response.getStatusLine().getStatusCode());
                chip.state = -4;
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
            if (obj.isNull("CscKmm")) {
                obj.put("CscKmm", (Object)"f0f0");
            }
            return chip.removeDuplicatePass(obj.getString("CscKmm"));
        }
        catch (Exception e) {
            CardAgent.log("Get102Pass Error:" + e.getMessage());
            chip.state = -4;
            return null;
        }
    }

    private String get102Pass(Chip chip, JSONObject jsonObject) {
        chip.state = 0;
        try {
            String url = this.cloudUrl + "/atm/anonymous/getInfoNet";
            JSONObject jsonboys = new JSONObject();
            jsonboys.put("ipAddress", (Object)jsonObject.getString("ipAddress"));
            jsonboys.put("macAddress", (Object)jsonObject.getString("macAddress"));
            jsonboys.put("terminalCode", (Object)jsonObject.getString("terminalCode"));
            jsonboys.put("orgUnitId", (Object)jsonObject.getString("orgUnitId"));
            jsonboys.put("mdmCode", (Object)jsonObject.getString("mdmCode"));
            jsonboys.put("parsingStyle", (Object)"2");
            jsonboys.put("cardType", (Object)"0");
            jsonboys.put("operateType", (Object)"0");
            jsonboys.put("cardReading", (Object)chip.getRegisters());
            jsonboys.put("machineCode", (Object)jsonObject.getString("machineCode"));
            jsonboys.put("selfManufacture", (Object)"AOFENG");
            jsonboys.put("cpuId", (Object)UUID.randomUUID().toString());
            url = CardAgent.parseUrl(url, jsonboys);
            String result = OkhttpUtil.post(url, "", "");
            CardAgent.log("Get102Pass result = " + result);
            JSONObject obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
            if (obj.getBoolean("result")) {
                this.token = obj.getJSONObject("data").getString("token");
                return chip.removeDuplicatePass(obj.getJSONObject("data").getString("checkPassword"));
            }
            chip.state = -7;
            return null;
        }
        catch (Exception e) {
            CardAgent.log("Get102Pass Error:" + e.getMessage());
            chip.state = -4;
            return null;
        }
    }

    private String cloudRead(Chip chip, String AREA) {
        try {
            HttpClient hc;
            HttpResponse response;
            HttpPost httpPost = null;
            String body = "";
            String cpuId = UUID.randomUUID().toString();
            httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            body = "{\"CardType\":\"" + chip.chipName + "\",\"operatetype\":\"" + (chip.chipName == 0 ? 2 : (chip.chipName == 6 ? 2 : 1)) + "\",\"cardinfo\":\"" + chip.getRegisters() + "\",\"opid\":\"1\", \"AREA\":\"" + AREA + "\"";
            if (0 == chip.chipName) {
                body = body + ", \"Wsckmm\":\"f0f0\"";
            }
            if (chip.chipName == 7) {
                body = body + ",\"GUID\" :\"" + cpuId + "\"";
                body = body + ",\"socket_url\" :\"" + this.getSocketUrl() + "\"";
            }
            body = body + "}";
            httpPost.setEntity((HttpEntity)new StringEntity(EncryUtil.encry(body, this.encryType, this.encryKey), "UTF8"));
            if (chip.chipName == 7) {
                CPUSocket CPUSocket2 = new CPUSocket(body.toString());
                CPUSocket2.start();
            }
            if ((response = (hc = CommUtil.getCardServiceHttpClient()).execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() != 200) {
                CardAgent.log("CloudRead NetError " + response.getStatusLine().getStatusCode());
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
            if (!obj.isNull("Err")) {
                CardAgent.log("CloudRead notNull Error");
                return null;
            }
            if (!obj.isNull("Exception")) {
                CardAgent.log("CloudRead notNull Exception");
                return null;
            }
            return obj.toString();
        }
        catch (Exception e) {
            CardAgent.log("CloudRead Exception");
            return null;
        }
    }

    private String A10Read(Chip chip, JSONObject jsonObject) {
        String result;
        boolean ret;
        String pass;
        if (chip.chipName == 0) {
            pass = this.get102Pass(chip, jsonObject);
            if (chip.state != 0) {
                return this.getReadErrMsg(chip.state);
            }
            chip.secret = pass;
            ret = this.reader.read(chip);
            if (!ret) {
                CardAgent.log("Read Card Error");
                return this.getReadErrMsg(-1);
            }
        }
        if (chip.chipName == 6) {
            pass = this.get1608PassArea7(chip, jsonObject);
            if (chip.state != 0) {
                return this.getReadErrMsg(chip.state);
            }
            chip.secret_1608 = pass;
            ret = this.reader.read(chip);
            if (!ret) {
                CardAgent.log("Read Card Error");
                return this.getReadErrMsg(-1);
            }
            pass = this.get1608PassArea2(chip, jsonObject);
            if (chip.state != 0) {
                return this.getReadErrMsg(chip.state);
            }
            chip.secret = pass;
            ret = this.reader.read(chip);
            if (!ret) {
                CardAgent.log("Read Card Error");
                return this.getReadErrMsg(-1);
            }
        }
        if ((result = this.A10CloudRead(chip, jsonObject)) == null) {
            return this.getReadErrMsg(-4);
        }
        return this.getReadErrMsg(0, result);
    }

    private String get1608PassArea2(Chip chip, JSONObject params) {
        try {
            chip.state = 0;
            boolean flag = false;
            Object httpPost = null;
            String body = "";
            String url = this.cloudUrl + "/atm/anonymous/getInfoNet";
            JSONObject jsonboys = new JSONObject();
            jsonboys.put("ipAddress", (Object)params.getString("ipAddress"));
            jsonboys.put("macAddress", (Object)params.getString("macAddress"));
            jsonboys.put("terminalCode", (Object)params.getString("terminalCode"));
            jsonboys.put("orgUnitId", (Object)params.getString("orgUnitId"));
            jsonboys.put("mdmCode", (Object)params.getString("mdmCode"));
            jsonboys.put("parsingStyle", (Object)"2");
            jsonboys.put("cardType", (Object)"6");
            jsonboys.put("operateType", (Object)"1");
            jsonboys.put("cardReading", (Object)(chip.bytes2HexStr(0, 128) + "|23272b2f33373b3f||||||||" + chip.bytes2HexStr(128, 256) + "|00"));
            jsonboys.put("machineCode", (Object)params.getString("machineCode"));
            jsonboys.put("selfManufacture", (Object)"AOFENG");
            jsonboys.put("cpuId", (Object)UUID.randomUUID().toString());
            url = CardAgent.parseUrl(url, jsonboys);
            String result = OkhttpUtil.post(url, "", "");
            JSONObject obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
            if (obj.getBoolean("result")) {
                this.token = obj.getJSONObject("data").getString("token");
                return chip.removeDuplicatePass(obj.getJSONObject("data").getString("checkPassword"));
            }
            chip.state = -7;
            return null;
        }
        catch (Exception e) {
            CardAgent.log("Get1608PassArea2 Error " + e.getMessage());
            chip.state = -4;
            return null;
        }
    }

    private String get1608PassArea7(Chip chip, JSONObject params) {
        try {
            chip.state = 0;
            Object httpPost = null;
            String body = "";
            String url = this.cloudUrl + "/atm/anonymous/getInfoNet";
            JSONObject jsonboys = new JSONObject();
            jsonboys.put("ipAddress", (Object)params.getString("ipAddress"));
            jsonboys.put("macAddress", (Object)params.getString("macAddress"));
            jsonboys.put("terminalCode", (Object)params.getString("terminalCode"));
            jsonboys.put("orgUnitId", (Object)params.getString("orgUnitId"));
            jsonboys.put("mdmCode", (Object)params.getString("mdmCode"));
            jsonboys.put("parsingStyle", (Object)"2");
            jsonboys.put("cardType", (Object)"6");
            jsonboys.put("operateType", (Object)"0");
            jsonboys.put("cardReading", (Object)(chip.bytes2HexStr(0, 128) + "|23272b2f33373b3f|||||||||00"));
            jsonboys.put("machineCode", (Object)params.getString("machineCode"));
            jsonboys.put("selfManufacture", (Object)"AOFENG");
            jsonboys.put("cpuId", (Object)UUID.randomUUID().toString());
            url = CardAgent.parseUrl(url, jsonboys);
            String result = OkhttpUtil.post(url, "", "");
            JSONObject obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
            if (obj.getBoolean("result")) {
                return chip.removeDuplicatePass(obj.getJSONObject("data").getString("checkPassword"));
            }
            chip.state = -7;
            return null;
        }
        catch (Exception e) {
            CardAgent.log("Get1608PassArea7 Error " + e.getMessage());
            chip.state = -4;
            return null;
        }
    }

    private String A10CloudRead(Chip chip, JSONObject jsonObject) {
        Object httpPost = null;
        String body = "";
        String cpuId = UUID.randomUUID().toString();
        String url = this.cloudUrl + "/atm/anonymous/getInfoNet";
        JSONObject jsonboys = new JSONObject();
        jsonboys.put("ipAddress", (Object)jsonObject.getString("ipAddress"));
        jsonboys.put("macAddress", (Object)jsonObject.getString("macAddress"));
        jsonboys.put("terminalCode", (Object)jsonObject.getString("terminalCode"));
        jsonboys.put("orgUnitId", (Object)jsonObject.getString("orgUnitId"));
        jsonboys.put("mdmCode", (Object)jsonObject.getString("mdmCode"));
        jsonboys.put("parsingStyle", (Object)"2");
        jsonboys.put("cardType", chip.chipName);
        jsonboys.put("operateType", (Object)"2");
        jsonboys.put("cardReading", (Object)chip.getRegisters());
        jsonboys.put("machineCode", (Object)jsonObject.getString("machineCode"));
        jsonboys.put("selfManufacture", (Object)"AOFENG");
        jsonboys.put("cpuId", (Object)cpuId);
        url = CardAgent.parseUrl(url, jsonboys);
        String result = OkhttpUtil.post(url, "", "");
        JSONObject obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
        CardAgent.log(obj.toString());
        try {
            if (obj.getBoolean("result")) {
                obj = obj.getJSONObject("data");
                obj.put("CardData", (Object)chip.getRegisters());
                obj.put("cardType", chip.chipName);
                if (obj.getString("dllVersion").contains("GPM1")) {
                    obj.put("CardID", (Object)obj.getString("serialNumber").subSequence(20, 36));
                    obj.put("serialNumber", (Object)obj.getString("serialNumber").subSequence(20, 36));
                } else {
                    obj.put("CardID", (Object)obj.getString("serialNumber"));
                }
                return obj.toString();
            }
            return obj.toString();
        }
        catch (Exception e) {
            try {
                return obj.toString();
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static void postlog() {
        CardLog cl = new CardLog(logStr);
        logStr = "";
        cl.start();
    }

    public static void postlog2(String url) {
        CardLog cl = new CardLog(logStr, url);
        logStr = "";
        cl.start();
    }

    private String getM1Pass(Chip chip, int opid, String AREA) {
        try {
            chip.state = 0;
            HttpPost httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            String body = "{\"CardType\" : \"8\",\"operatetype\":\"0\",\"cardinfo\" :\"" + chip.bytes2HexStr(0, 16) + "|" + chip.bytes2HexStr(16, 16) + "|" + chip.bytes2HexStr(32, 16) + "|" + chip.bytes2HexStr(48, 16) + "\",\"opid\":\"" + opid + "\", \"AREA\":\"" + AREA + "\", \"Wsckmm\":\"fffffffffffff\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(EncryUtil.encry(body, this.encryType, this.encryKey), "UTF8"));
            HttpClient hc = CommUtil.getCardServiceHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                CardAgent.log("Getm1Pass NetError " + response.getStatusLine().getStatusCode());
                chip.state = -4;
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
            if (obj.isNull("CscKmm")) {
                CardAgent.log("Getm1Pass Null CscKmm");
                chip.state = -7;
                return null;
            }
            return obj.getString("CscKmm");
        }
        catch (Exception e) {
            CardAgent.log("Getm1Pass Error " + e.getMessage());
            chip.state = -4;
            return null;
        }
    }

    private String sellM1card(Chip chip, JSONObject params) throws Exception {
        String pass = this.getM1Pass(chip, 1, params.has("AREA") ? params.getString("AREA") : "");
        if (chip.state != 0) {
            return this.getReadErrMsg(chip.state);
        }
        chip.secret = pass;
        chip.addid = 20;
        boolean r = this.reader.read(chip);
        if (!r) {
            CardAgent.log("Read Card Error");
            return this.getWriteErrMsg(-1);
        }
        return this.sell(chip, params);
    }

    private String writeM1card(JSONObject obj, Chip chip) throws Exception {
        String[] writeDatas = obj.getString("Kdata").toUpperCase().split("\\|");
        int i = 0;
        int block = 4;
        int keyoffset = 0;
        for (String f : writeDatas) {
            block = 4;
            if (i == 3 || i == 7) {
                block = 3;
            }
            if (i < 4) {
                chip.addid = 16 + i;
                keyoffset = 4;
            } else {
                chip.addid = 16 + i;
                keyoffset = 5;
            }
            boolean r = this.reader.write(chip, block, keyoffset, 0, HexDump.hexStringToByteArray(f), null);
            if (!r) {
                CardAgent.log("Write Data Error");
                return this.getWriteErrMsg(-5);
            }
            ++i;
            CardAgent.log("Write Data Success");
        }
        CardAgent.log("Write Card Success");
        return this.getWriteErrMsg(0, obj.getString("Kmm"));
    }

    private String writeM1CardTT(JSONObject obj, Chip chip) throws Exception {
        int block = 1;
        int keyoffset = 0;
        String writeDatas = obj.getString("Kdata").toUpperCase();
        boolean r = this.reader.write(chip, block, keyoffset, 0, HexDump.hexStringToByteArray(writeDatas), null);
        if (!r) {
            CardAgent.log("Write Data Error");
            return this.getWriteErrMsg(-5);
        }
        CardAgent.log("Write Card Success");
        return this.getWriteErrMsg(0, obj.getString("Kmm"));
    }

    public static String parseUrl(String url, JSONObject jsonObject) {
        StringBuilder posturl = new StringBuilder(url + "?");
        try {
            int i = 0;
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (i == 0) {
                    posturl.append(key).append("=").append(jsonObject.get(key).toString());
                    ++i;
                    continue;
                }
                posturl.append("&").append(key).append("=").append(jsonObject.get(key).toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String postUrl = posturl.toString().replaceAll("\\{", "%7B").replaceAll("\"", "%22").replaceAll(" ", "%20").replaceAll("\\}", "%7D");
        CardAgent.log("jsonObject url  = " + postUrl);
        return postUrl;
    }

    private String get153RdPwd(Chip chip, int opid, String AREA) {
        try {
            chip.state = 0;
            HttpPost httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            String body = "{\"CardType\" : \"11\",\"operatetype\":\"0\",\"cardinfo\" :\"" + chip.bytes2HexStr(0, 64) + "|||\",\"opid\":\"" + opid + "\", \"AREA\":\"" + AREA + "\", \"Wsckmm\":\"fffffffffffff\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(EncryUtil.encry(body, this.encryType, this.encryKey), "UTF8"));
            HttpClient hc = CommUtil.getCardServiceHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                CardAgent.log("Getm1Pass NetError " + response.getStatusLine().getStatusCode());
                chip.state = -4;
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(EncryUtil.decry(result, this.encryType, this.encryKey));
            if (obj.isNull("CscKmm")) {
                CardAgent.log("Get153Pass Null CscKmm");
                chip.state = -7;
                return null;
            }
            return obj.getString("CscKmm");
        }
        catch (Exception e) {
            CardAgent.log("Get153Pass Error " + e.getMessage());
            chip.state = -4;
            return null;
        }
    }

    static {
        errorMap.put(-1, "\u8bfb\u5361\u9519\uff01");
        errorMap.put(-2, "\u5bc6\u7801\u6821\u9a8c\u9519\uff01");
        errorMap.put(-3, "\u7a7a\u767d\u5361\uff01");
        errorMap.put(-4, "\u8bf7\u786e\u8ba4\u662f\u5426\u4e3a\u71c3\u6c14\u5361\uff0c\u6216\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\uff01");
        errorMap.put(-5, "\u5199\u5361\u9519\uff01");
        errorMap.put(-6, "\u5361\u672a\u63d2\u597d\u6216\u4e0d\u652f\u6301\u7684\u5361\u578b\uff01");
        errorMap.put(-7, "\u5361\u4e91\u670d\u52a1\u51fa\u9519\uff01");
        errorMap.put(-8, "\u4fee\u6539\u5bc6\u7801\u9519\u8bef\uff01");
        errorMap.put(-9, "\u68c0\u6d4b\u5230\u4e24\u5f20\u5361\uff0c\u8bf7\u786e\u8ba4\u786e\u8ba4\u71c3\u6c14\u5361\u5e76\u79fb\u9664\u53e6\u4e00\u5f20\u5361\u7247\uff01");
        errorMap.put(5, "\u4e0d\u662f\u7528\u6237\u5361");
        errorMap.put(7, "\u5361\u4e0a\u6709\u5269\u4f59\u6c14\u91cf\uff01");
        errorMap.put(17, "\u52a0\u5bc6\u673a\u8fd4\u56de\u9519\u8bef");
        errorMap.put(-10, "\u8bbe\u5907\u767b\u9646\u5931\u8d25");
        errorMap.put(-12, "\u8bbe\u5907\u9a8c\u8bc1\u5931\u8d25");
        isA10 = false;
    }
}

