/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.task;

import android.os.AsyncTask;
import com.aofeng.hybrid.activity.HybridActivity;
import com.aofeng.hybrid.android.NativeBaseMethod;
import org.json.JSONArray;
import org.json.JSONObject;

public class SimpleAsyncTask
extends AsyncTask<String, String, JSONObject> {
    protected HybridActivity hybridActivity;
    protected JSONObject json;
    protected String callback;
    protected String progressHint;
    protected String successHint;
    protected String failureHint;

    public SimpleAsyncTask(HybridActivity hybridActivity, JSONObject json) {
        this.hybridActivity = hybridActivity;
        this.json = json;
    }

    protected JSONObject doInBackground(String ... params) {
        try {
            this.callback = params[0];
            JSONArray hints = this.json.getJSONArray("hint");
            if (!hints.isNull(0)) {
                this.progressHint = hints.getString(0).toString();
            }
            if (!hints.isNull(1)) {
                this.successHint = hints.getString(1).toString();
            }
            if (!hints.isNull(2)) {
                this.failureHint = hints.getString(2).toString();
            }
            this.publishProgress(new String[]{this.progressHint});
            return this.action();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected JSONObject action() throws Exception {
        return NativeBaseMethod._executeTask(this.hybridActivity.mWebView, this.json);
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.hybridActivity.createProgressDialog(0);
    }

    protected void onPostExecute(JSONObject result) {
        block10: {
            super.onPostExecute((Object)result);
            this.hybridActivity.closeProgress();
            if (result != null) {
                try {
                    if (result.has("code") && result.getInt("code") != 200) {
                        if (this.failureHint != null) {
                            NativeBaseMethod.alert(this.hybridActivity.mWebView, this.failureHint);
                        }
                    } else {
                        if (this.callback != null) {
                            this.hybridActivity.mWebView.loadUrl(String.format(this.callback, result.toString()));
                        }
                        if (this.successHint != null) {
                            NativeBaseMethod.alert(this.hybridActivity.mWebView, this.successHint);
                        }
                    }
                    break block10;
                }
                catch (Exception e) {
                    if (this.failureHint != null) {
                        NativeBaseMethod.alert(this.hybridActivity.mWebView, this.failureHint);
                    }
                    break block10;
                }
            }
            if (this.failureHint != null) {
                NativeBaseMethod.alert(this.hybridActivity.mWebView, this.failureHint);
            }
        }
    }

    protected void onProgressUpdate(String ... values) {
        super.onProgressUpdate((Object[])values);
        this.hybridActivity.setMessage(values[0]);
    }
}

