/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.service;

import android.content.Context;
import android.os.StrictMode;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.service.GenericService;
import com.aofeng.hybrid.service.ValueWrapper;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.EncryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class RestService
extends GenericService {
    public RestService(Context context) {
        super(context);
    }

    @Override
    public JSONObject action(JSONObject json) {
        JSONObject result = new JSONObject();
        try {
            result.put("code", 500);
            result.put("data", (Object)"\u4e0d\u53ef\u5904\u7406\u5f02\u5e38\u3002");
            Object obj = this.execute(json);
            result.put("code", 200);
            result.put("data", obj);
            return result;
        }
        catch (Exception e) {
            try {
                result.put("code", 500);
                result.put("data", (Object)e.getMessage());
                return result;
            }
            catch (Exception ex) {
                return result;
            }
        }
    }

    public Object execute(JSONObject json) throws Exception {
        JSONObject array;
        String result;
        boolean needEncry;
        String method = json.getString("action");
        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
        String encryType = CommUtil.getSharedPreference(MainActivity.context, "encryType");
        String encryKey = CommUtil.getSharedPreference(MainActivity.context, "encryKey");
        boolean bl = needEncry = !"".equals(encryType.toLowerCase()) && !"".equals(encryKey);
        if (method.toLowerCase().equals("get")) {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpGet getMethod = new HttpGet(json.getString("url"));
            HttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new Exception("\u8c03\u7528\u5931\u8d25\u3002");
            }
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        } else if (method.toLowerCase().equals("post")) {
            DefaultHttpClient httpClient;
            HttpResponse response;
            HttpPost httpPost = new HttpPost(json.getString("url"));
            if (!json.isNull("data") && json.getString("data").length() != 0) {
                String data = json.getString("data");
                if (needEncry) {
                    data = EncryUtil.encry(data, encryType, encryKey);
                }
                httpPost.setEntity((HttpEntity)new StringEntity(data, "UTF8"));
            }
            if ((response = (httpClient = new DefaultHttpClient()).execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() != 200) {
                throw new Exception("\u8c03\u7528\u5931\u8d25\u3002");
            }
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            if (needEncry) {
                result = EncryUtil.decry(result, encryType, encryKey);
            }
        } else {
            throw new Exception("\u4e0d\u652f\u6301\u7684rest\u8c03\u7528\u65b9\u5f0f\u3002");
        }
        if (result.startsWith("{")) {
            array = new JSONObject(result);
        } else if (result.startsWith("[")) {
            array = new JSONArray(result);
        } else {
            throw new Exception("\u8c03\u7528rest\u670d\u52a1\u5931\u8d25\u3002");
        }
        return array;
    }

    private boolean parseArray(JSONArray array, List<Map<String, Object>> list) {
        try {
            for (int i = 0; i < array.length(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                HashMap<String, Object> map = new HashMap<String, Object>();
                list.add(map);
                if (this.parseJSON(obj, map)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean parseJSON(JSONObject obj, Map<String, Object> map) {
        try {
            Iterator itr = obj.keys();
            while (itr.hasNext()) {
                ValueWrapper wrapper;
                String key = (String)itr.next();
                Object property = obj.get(key);
                if (!this.parseProperty(property, wrapper = new ValueWrapper())) {
                    return false;
                }
                map.put(key, wrapper.value);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean parseProperty(Object property, ValueWrapper wrapper) {
        if (property instanceof JSONArray) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            if (!this.parseArray((JSONArray)property, list)) {
                return false;
            }
            wrapper.value = list;
        } else if (property instanceof JSONObject) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (!this.parseJSON((JSONObject)property, map)) {
                return false;
            }
            wrapper.value = map;
        } else {
            wrapper.value = property;
        }
        return true;
    }
}

