/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.peripheral;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.os.Vibrator;
import android.util.Log;
import android.view.KeyEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;
import android.widget.Toast;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.android.zbar.camera.CameraManager;
import com.aofeng.hybrid.android.zbar.decode.CaptureActivityHandler;
import com.aofeng.hybrid.android.zbar.decode.InactivityTimer;
import com.aofeng.hybrid.android.zbar.view.ViewfinderView;
import com.aofeng.hybrid.util.CommUtil;
import java.io.IOException;
import org.json.JSONObject;

public class CaptureActivity
extends Activity
implements SurfaceHolder.Callback,
View.OnClickListener {
    private InactivityTimer inactivityTimer;
    private CaptureActivityHandler handler;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private boolean vibrate;
    private boolean flag = true;
    private boolean hasSurface = false;
    private ViewfinderView viewfinderView;
    private ImageView iv_title_back;
    private ImageView iv_flashlight;
    private ScreenOffReceiver mScreenOffReceiver = new ScreenOffReceiver();
    public static Context context;
    private String callback;
    public static String codeStr;
    private String FrontCamera = "";
    private String SCREEN_ORIENTATION = "";
    private boolean disenable_bar = false;
    private static final float BEEP_VOLUME = 0.2f;
    private static final long VIBRATE_DURATION = 200L;
    private final MediaPlayer.OnCompletionListener beepListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mediaPlayer) {
            mediaPlayer.seekTo(0);
        }
    };
    public static final int FLAG_NEEDS_MENU_KEY = 0x8000000;
    private long preTime = 0L;

    private void initBeepSound() {
        if (this.playBeep && this.mediaPlayer == null) {
            this.setVolumeControlStream(3);
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.setOnCompletionListener(this.beepListener);
            AssetFileDescriptor file = this.getResources().openRawResourceFd(R.raw.beep);
            try {
                this.mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
                file.close();
                this.mediaPlayer.setVolume(0.2f, 0.2f);
                this.mediaPlayer.prepare();
            }
            catch (IOException e) {
                this.mediaPlayer = null;
            }
        }
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        try {
            CameraManager.get().openDriver(surfaceHolder, this.FrontCamera);
        }
        catch (IOException ioe) {
            Log.e((String)"CaptureActivity", (String)ioe.getMessage());
            return;
        }
        catch (RuntimeException e) {
            Log.e((String)"CaptureActivity", (String)e.getMessage());
            return;
        }
        if (this.handler == null) {
            this.handler = new CaptureActivityHandler(this);
        }
    }

    private void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            Vibrator vibrator = (Vibrator)this.getSystemService("vibrator");
            vibrator.vibrate(200L);
        }
    }

    public ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    public void handleDecode(String result) {
        this.inactivityTimer.onActivity();
        this.playBeepSoundAndVibrate();
        codeStr = "";
        if (!result.equals("")) {
            codeStr = result;
            Intent intent = new Intent();
            intent.putExtra("callback", String.format(this.callback, new Object[0]));
            this.setResult(-1, intent);
        } else {
            this.setResult(0);
        }
        this.finish();
    }

    public void onAttachedToWindow() {
        if (this.disenable_bar) {
            this.getWindow().clearFlags(0x8000000);
            this.getWindow().addFlags(1024);
        }
        super.onAttachedToWindow();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.disenable_bar) {
            switch (keyCode) {
                case 3: 
                case 4: 
                case 28: {
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.disenable_bar) {
            return true;
        }
        if (event.getKeyCode() == 4 && event.getAction() == 0) {
            if (System.currentTimeMillis() - this.preTime < 2000L) {
                Intent home = new Intent("android.intent.action.MAIN");
                home.setFlags(0x4000000);
                home.addCategory("android.intent.category.HOME");
                this.startActivity(home);
                return true;
            }
            Toast.makeText((Context)this, (CharSequence)"\u518d\u6309\u4e00\u6b21\u9000\u51fa\u7a0b\u5e8f", (int)0).show();
            this.preTime = System.currentTimeMillis();
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    public void light() {
        if (this.flag) {
            CameraManager.get().openLight();
            this.flag = false;
            this.iv_flashlight.setImageDrawable(this.getResources().getDrawable(R.drawable.icon_light_hover));
            return;
        }
        CameraManager.get().offLight();
        this.flag = true;
        this.iv_flashlight.setImageDrawable(this.getResources().getDrawable(R.drawable.icon_light));
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.SCREEN_ORIENTATION = CommUtil.getSharedPreference((Context)this, "SCREEN_ORIENTATION");
        this.setRequestedOrientation(-1);
        Window window = this.getWindow();
        window.addFlags(128);
        this.setContentView(R.layout.capture);
        context = this;
        this.disenable_bar = "true".equals(CommUtil.getSharedPreference((Context)this, "pos").toLowerCase()) && "true".equals(CommUtil.getSharedPreference((Context)this, "full_screen").toLowerCase());
        CameraManager.init((Context)this.getApplication());
        this.viewfinderView = (ViewfinderView)this.findViewById(R.id.viewfinder_view);
        this.iv_flashlight = (ImageView)this.findViewById(R.id.iv_flashlight);
        this.iv_flashlight.setOnClickListener((View.OnClickListener)this);
        this.iv_title_back = (ImageView)this.findViewById(R.id.iv_title_back);
        this.iv_title_back.setOnClickListener((View.OnClickListener)this);
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer(this);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        this.registerReceiver(this.mScreenOffReceiver, intentFilter);
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        try {
            Bundle bundle = intent.getExtras();
            JSONObject jo = new JSONObject(bundle.getString("param"));
            this.callback = jo.getString("callback");
            if (jo.has("frontCamera")) {
                this.FrontCamera = jo.getString("frontCamera");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected void onPause() {
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        CameraManager.get().offLight();
        this.inactivityTimer.onPause();
        CameraManager.get().closeDriver();
        if (!this.hasSurface) {
            SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.preview_view);
            SurfaceHolder surfaceHolder = surfaceView.getHolder();
            surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
        super.onPause();
    }

    protected void onResume() {
        super.onResume();
        this.handler = null;
        SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.preview_view);
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            surfaceHolder.setType(3);
        }
        this.playBeep = true;
        AudioManager audioService = (AudioManager)this.getSystemService("audio");
        if (audioService.getRingerMode() != 2) {
            this.playBeep = false;
        }
        this.initBeepSound();
        this.inactivityTimer.onResume();
        this.vibrate = true;
    }

    protected void onDestroy() {
        this.inactivityTimer.shutdown();
        this.unregisterReceiver(this.mScreenOffReceiver);
        super.onDestroy();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_flashlight) {
            this.light();
        } else if (v.getId() == R.id.iv_title_back) {
            this.finish();
        }
    }

    private class ScreenOffReceiver
    extends BroadcastReceiver {
        private ScreenOffReceiver() {
        }

        public void onReceive(Context arg0, Intent arg1) {
            Log.d((String)"CaptureActivity", (String)"CaptureActivity receive screen off command ++");
            CaptureActivity.this.finish();
        }
    }
}

