/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.peripheral;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.util.CommUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.json.JSONObject;

public class CameraActivity
extends Activity {
    private String callback;
    private String fileName;
    private static final int JPEG_SIZE = 150;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.camera);
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        try {
            Bundle bundle = intent.getExtras();
            JSONObject jo = new JSONObject(bundle.getString("param"));
            this.fileName = AFApplication.APP_DATA + jo.getString("file");
            File file = new File(this.fileName);
            Uri uri = Uri.fromFile((File)file);
            intent = new Intent("android.media.action.IMAGE_CAPTURE");
            intent.putExtra("output", (Parcelable)uri);
            this.callback = jo.getString("callback");
            this.startActivityForResult(intent, jo.getInt("requestCode"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            try {
                Intent intent = new Intent();
                this.touchImage(1024, 600);
                intent.putExtra("callback", String.format(this.callback, "file://" + this.fileName));
                this.setResult(-1, intent);
                this.finish();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setResult(0);
                this.finish();
            }
        } else {
            this.setResult(0);
            this.finish();
        }
    }

    public void touchImage(int reqWidth, int reqHeight) throws Exception {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)this.fileName, (BitmapFactory.Options)options).copy(Bitmap.Config.ARGB_8888, true);
        this.compressImage(bitmap, 150);
    }

    public void compressImage(Bitmap image, int imageSize) throws Exception {
        int options;
        this.DrawWatermark(image);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String needCompressed = CommUtil.getSharedPreference((Context)this, "needCompressed").toLowerCase();
        image.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
        if (options != 100) {
            for (options = needCompressed.equals("") || needCompressed.equals("true") ? 30 : 100; baos.toByteArray().length / 1024 > imageSize && options > 10; options -= 5) {
                int size = baos.toByteArray().length / 1024;
                baos.reset();
                image.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
                Log.d((String)"CameraActivity", (String)("compression ratio:" + options + ", size:" + size));
            }
        }
        FileOutputStream out = new FileOutputStream(this.fileName);
        out.write(baos.toByteArray());
        out.flush();
        out.close();
        baos.close();
    }

    private void DrawWatermark(Bitmap src) throws Exception {
        int h = src.getHeight();
        int w = src.getWidth();
        int TextinitSize = 35;
        int OFFSET_TOP = h / 2;
        int OFFSET_LEFT = 0;
        float ratioWidth = (float)w / 480.0f;
        float ratioHeight = (float)h / 800.0f;
        Resources resources = this.getResources();
        float scale = resources.getDisplayMetrics().density;
        float RATIO = Math.min(ratioWidth, ratioHeight);
        int TEXT_SIZE = Math.round((float)TextinitSize * RATIO);
        Canvas canvas = new Canvas(src);
        Intent intent = this.getIntent();
        Bundle bundle = intent.getExtras();
        JSONObject jo = new JSONObject(bundle.getString("param"));
        String[] lines = jo.getString("watermark").split("\t");
        OFFSET_LEFT = TextinitSize;
        OFFSET_TOP = Math.round((float)h - (float)TextinitSize * RATIO * (float)lines.length);
        Paint paint = new Paint(1);
        paint.setColor(0);
        paint.setAlpha(50);
        paint.setTextSize((float)TEXT_SIZE);
        paint.setAntiAlias(true);
        paint.setFakeBoldText(true);
        paint.setColor(-16776961);
        for (String line : lines) {
            canvas.drawText(line, (float)OFFSET_LEFT, (float)OFFSET_TOP, paint);
            OFFSET_TOP += Math.round((float)TextinitSize * RATIO);
        }
    }

    private int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }
}

