/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.peripheral;

import android.app.Activity;
import android.content.Intent;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.application.AFApplication;
import java.io.File;
import java.io.IOException;
import org.json.JSONObject;

public class AudioClipActivity
extends Activity
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnPreparedListener {
    private String fileName;
    private Button btnRecord;
    private Button btnPlay;
    private Button btnReturn;
    private boolean shouldStop;
    private MediaRecorder mRecorder = new MediaRecorder();
    private MediaPlayer mPlayer = new MediaPlayer();
    private String callback;
    public Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what > 0) {
                AudioClipActivity.this.btnRecord.setText((CharSequence)("\u505c\u6b62\u5f55\u97f3  " + msg.what));
            } else {
                AudioClipActivity.this.mRecorder.stop();
                AudioClipActivity.this.mRecorder.reset();
                AudioClipActivity.this.btnRecord.setText((CharSequence)"\u5f00\u59cb\u5f55\u97f3");
                AudioClipActivity.this.btnPlay.setEnabled(true);
                AudioClipActivity.this.btnReturn.setEnabled(true);
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.audioclip);
        this.setFinishOnTouchOutside(false);
        this.mPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.btnRecord = (Button)this.findViewById(R.id.btnRecord);
        this.btnRecord.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AudioClipActivity.this.btnRecord.getText().equals("\u5f00\u59cb\u5f55\u97f3")) {
                    AudioClipActivity.this.shouldStop = false;
                    AudioClipActivity.this.btnPlay.setEnabled(false);
                    AudioClipActivity.this.btnReturn.setEnabled(false);
                    AudioClipActivity.this.btnRecord.setText((CharSequence)"\u505c\u6b62\u5f55\u97f3");
                    try {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (int n = 60; !AudioClipActivity.this.shouldStop && n > 0; --n) {
                                    try {
                                        Thread.sleep(1000L);
                                        Message msg = new Message();
                                        msg.what = n;
                                        AudioClipActivity.this.mHandler.sendMessage(msg);
                                        continue;
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                                Message msg = new Message();
                                msg.what = -1;
                                AudioClipActivity.this.mHandler.sendMessage(msg);
                            }
                        }).start();
                        AudioClipActivity.this.mRecorder.setAudioSource(1);
                        AudioClipActivity.this.mRecorder.setOutputFormat(1);
                        AudioClipActivity.this.mRecorder.setAudioEncoder(1);
                        AudioClipActivity.this.mRecorder.setOutputFile(AudioClipActivity.this.fileName);
                        AudioClipActivity.this.mRecorder.prepare();
                        AudioClipActivity.this.mRecorder.start();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    AudioClipActivity.this.shouldStop = true;
                }
            }
        });
        this.btnPlay = (Button)this.findViewById(R.id.btnPlay);
        this.btnPlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AudioClipActivity.this.btnPlay.getText().equals("\u653e\u97f3")) {
                    File file = new File(AudioClipActivity.this.fileName);
                    if (!file.exists()) {
                        return;
                    }
                    AudioClipActivity.this.btnRecord.setEnabled(false);
                    AudioClipActivity.this.btnReturn.setEnabled(false);
                    AudioClipActivity.this.btnPlay.setText((CharSequence)"\u505c\u6b62\u653e\u97f3");
                    try {
                        AudioClipActivity.this.mPlayer.reset();
                        AudioClipActivity.this.mPlayer.setDataSource(AudioClipActivity.this.fileName);
                        AudioClipActivity.this.mPlayer.prepareAsync();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    AudioClipActivity.this.mPlayer.stop();
                    AudioClipActivity.this.btnPlay.setText((CharSequence)"\u653e\u97f3");
                    AudioClipActivity.this.btnRecord.setEnabled(true);
                    AudioClipActivity.this.btnReturn.setEnabled(true);
                }
            }
        });
        this.btnReturn = (Button)this.findViewById(R.id.btnReturn);
        this.btnReturn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AudioClipActivity.this.goBack();
                AudioClipActivity.this.finish();
            }
        });
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        try {
            Bundle bundle = intent.getExtras();
            JSONObject jo = new JSONObject(bundle.getString("param"));
            this.fileName = AFApplication.APP_DATA + jo.getString("file");
            this.callback = jo.getString("callback");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        this.goBack();
        super.onBackPressed();
    }

    private void goBack() {
        File file = new File(this.fileName);
        if (file.exists()) {
            Intent intent = new Intent();
            intent.putExtra("callback", String.format(this.callback, "file://" + this.fileName));
            this.setResult(-1, intent);
        } else {
            this.setResult(0);
        }
    }

    public void onCompletion(MediaPlayer mp) {
        this.btnPlay.setText((CharSequence)"\u653e\u97f3");
        this.btnRecord.setEnabled(true);
        this.btnReturn.setEnabled(true);
    }

    public void onPrepared(MediaPlayer mp) {
        mp.start();
    }
}

