/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.webkit.WebView;
import android.widget.Toast;
import com.aofeng.hybrid.activity.HybridActivity;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.android.peripheral.AutoQuickScanActivity;
import com.aofeng.hybrid.android.peripheral.CaptureActivity;
import com.aofeng.hybrid.android.peripheral.LDScanActivity;
import com.aofeng.hybrid.android.peripheral.SignActivity;
import com.aofeng.hybrid.android.receiver.PhoneStatus;
import com.aofeng.hybrid.android.service.Player;
import com.aofeng.hybrid.android.task.CardAsyncTask;
import com.aofeng.hybrid.android.task.GenericAsyncTask;
import com.aofeng.hybrid.android.task.HintPlugin;
import com.aofeng.hybrid.android.task.PrintAsyncTask;
import com.aofeng.hybrid.android.task.SimpleAsyncTask;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.plugin.H5Param;
import com.aofeng.hybrid.plugin.NativeCallJS;
import com.aofeng.hybrid.plugin.TaskExecutor;
import com.aofeng.hybrid.pos.device.LDDevice;
import com.aofeng.hybrid.pos.reader.CTNativeReader;
import com.aofeng.hybrid.pos.reader.CardAgent;
import com.aofeng.hybrid.service.GenericService;
import com.aofeng.hybrid.service.LogicService;
import com.aofeng.hybrid.service.PathService;
import com.aofeng.hybrid.sync.SyncDBAndPagesTask;
import com.aofeng.hybrid.util.AndroidIdentification;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NativeBaseMethod {
    private static Map<String, Object> services = new HashMap<String, Object>();
    private static int NOTIFICATION_ID;
    private static final String LD_BANKOFHEBEI = "LD_BANKOFHEBEI";
    private static final String LD_BANKOFCHINA = "LD_BANKOFCHINA";
    private static final String CT_CHINAUMS = "CT_CHINAUMS";
    private static final String NOTEXSITS = "NOTEXSITS";
    private static Player player;
    private static final HashMap<String, String> PayWayMap;
    public static JSONObject logic_param;
    public static JSONArray devices_array;
    public static String json_str;

    public static String getPayWay(String payway) {
        if (payway == null) {
            return PayWayMap.get(LD_BANKOFHEBEI);
        }
        if (PayWayMap.containsKey(payway)) {
            return PayWayMap.get(payway);
        }
        return PayWayMap.get(NOTEXSITS);
    }

    public static void pay(WebView view, JSONObject json, String pay_way) throws ClassNotFoundException {
        String pay_page = NativeBaseMethod.getPayWay(pay_way);
        if (NOTEXSITS.equals(pay_page)) {
            NativeBaseMethod.alert(view, "\u672a\u77e5\u652f\u4ed8\u65b9\u5f0f");
            return;
        }
        Context context = view.getContext();
        Intent intent = new Intent(context, Class.forName(pay_page));
        Bundle bundle = new Bundle();
        bundle.putString("params", json.toString());
        intent.putExtras(bundle);
        ((Activity)context).startActivityForResult(intent, 555);
    }

    public static void pay(WebView view, JSONObject json) throws ClassNotFoundException {
        NativeBaseMethod.pay(view, json, null);
    }

    public static String getVersion(WebView view) {
        try {
            PackageInfo manager = view.getContext().getPackageManager().getPackageInfo(view.getContext().getApplicationInfo().packageName, 0);
            return manager.versionCode + 46 + manager.versionName;
        }
        catch (Exception e) {
            return "\u83b7\u53d6\u7248\u672c\u4fe1\u606f\u9519\u8bef:" + e.getMessage();
        }
    }

    public static boolean needUpdate(WebView view, JSONObject appVer) {
        try {
            String appVerName = "".equals(CommUtil.getSharedPreference(view.getContext(), "appVer")) ? "appVer" : CommUtil.getSharedPreference(view.getContext(), "appVer");
            int serverVersion = appVer.getInt(appVerName);
            int appVersion = CommUtil.getVersionCode(view.getContext());
            if (appVersion < serverVersion) {
                return true;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String version = "".equals(CommUtil.getSharedPreference(view.getContext(), "hybrid_version")) ? "hybrid_version" : CommUtil.getSharedPreference(view.getContext(), "hybrid_version");
            LogUtil.d("Async server timestamp", appVer.getString(version));
            String lastModifiedTime = CommUtil.getSharedPreference(view.getContext(), SyncDBAndPagesTask.UPDATE_MOST_RECENT_TIME);
            LogUtil.d("Async client timestamp", sdf.format(new Date(Long.parseLong(lastModifiedTime))));
            Date newModifiedDate = sdf.parse(appVer.getString(version));
            return new Date(Long.parseLong(lastModifiedTime)).before(newModifiedDate);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void updateSystem(WebView view) throws ClassNotFoundException {
        Context context = view.getContext();
        String page = "com.aofeng.hybrid.activity.PreludeActivity";
        Intent intent = new Intent(context, Class.forName(page));
        intent.setFlags(0x4000000);
        ((Activity)context).startActivity(intent);
    }

    public static void back_home(WebView view) {
        MainActivity.backHome(MainActivity.context);
    }

    public static String getSellId(WebView view) {
        return MainActivity.getsellSId();
    }

    public static void notify2(WebView webView, String title, String msg, String insistent) throws Exception {
        NativeBaseMethod.notify(webView, title, msg, insistent, "ic_launcher", "ic_launcher", "ding");
    }

    public static void notify(WebView webView, String title, String msg, String insistent, String smallIconName, String largeIconName, String soundRawName) throws Exception {
        Context ctx = webView.getContext();
        Resources res = ctx.getResources();
        int smallIconId = res.getIdentifier(smallIconName, "drawable", ctx.getPackageName());
        int largeIconId = res.getIdentifier(largeIconName, "drawable", ctx.getPackageName());
        int soundId = res.getIdentifier(soundRawName, "raw", ctx.getPackageName());
        CommUtil.notify(webView.getContext(), NOTIFICATION_ID++, title, msg, insistent.equals("true"), smallIconId, largeIconId, soundId);
    }

    public static void setPreference(WebView webView, String key, String value) {
        CommUtil.setSharedPreference(webView.getContext(), key, value);
    }

    public static String getPreference(WebView webView, String key) {
        return CommUtil.getSharedPreference(webView.getContext(), key);
    }

    public static int getAppVersion(WebView webView) {
        return CommUtil.getVersionCode(webView.getContext());
    }

    public static JSONObject getPhoneStatus(WebView webView) throws Exception {
        Context context = webView.getContext();
        Date date = new Date();
        return PhoneStatus.getPhoneStatus(context, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupDatabase(WebView webView) {
        AbstractInterruptibleChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            File dbFile = webView.getContext().getDatabasePath("hybrid.db");
            File exportDir = new File(Environment.getExternalStorageDirectory(), "dbBackup");
            if (!exportDir.exists()) {
                exportDir.mkdirs();
            }
            File backup = new File(exportDir, "hybrid.db");
            backup.createNewFile();
            inChannel = new FileInputStream(dbFile).getChannel();
            outChannel = new FileOutputStream(backup).getChannel();
            ((FileChannel)inChannel).transferTo(0L, ((FileChannel)inChannel).size(), (WritableByteChannel)((Object)outChannel));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static JSONObject getAppContext(WebView webView) throws JSONException {
        Context ctx = webView.getContext();
        return CommUtil.getHybridContext(ctx);
    }

    public static void printWithHint(WebView webView, JSONObject jo) throws Exception {
        try {
            String params = jo.getString("params");
            String callback = jo.getString("callback");
            PrintAsyncTask dat = null;
            if (!jo.has("backresult") || jo.isNull("backresult")) {
                return;
            }
            int backresult = jo.getInt("backresult");
            dat = new PrintAsyncTask((HybridActivity)webView.getContext(), params, callback, backresult);
            dat.execute(new String[0]);
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "printWithHint\u6267\u884c\u5e26\u8fdb\u5ea6\u7684\u6253\u5370\u51fa\u9519\u3002");
            NativeBaseMethod.alert(webView, "\u5f02\u6b65\u8c03\u7528print\u76f8\u5173\u65b9\u6cd5\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0:" + e.getMessage());
            throw e;
        }
    }

    public static void syncPrintWithHint(WebView webView, JSONObject jo) throws Exception {
        try {
            String temp_json = json_str;
            json_str = "";
            if (temp_json.equals("")) {
                NativeBaseMethod.alert(webView, "\u5f02\u6b65\u8c03\u7528\u6253\u5370\u5931\u8d25,\u8bf7\u5148\u4f20\u5165\u53c2\u6570");
                return;
            }
            JSONArray param = null;
            try {
                param = new JSONArray(temp_json);
            }
            catch (JSONException e) {
                NativeBaseMethod.alert(webView, "\u5f02\u6b65\u8c03\u7528\u6253\u5370\u5931\u8d25,\u53c2\u6570\u4e0d\u662fjsonArray\uff1a" + temp_json);
                return;
            }
            String callback = jo.getString("callback");
            PrintAsyncTask dat = null;
            if (!jo.has("backresult") || jo.isNull("backresult")) {
                return;
            }
            int backresult = jo.getInt("backresult");
            dat = new PrintAsyncTask((HybridActivity)webView.getContext(), temp_json, callback, backresult);
            dat.execute(new String[0]);
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "printWithHint\u6267\u884c\u5e26\u8fdb\u5ea6\u7684\u6253\u5370\u51fa\u9519\u3002");
            NativeBaseMethod.alert(webView, "\u5f02\u6b65\u8c03\u7528print\u76f8\u5173\u65b9\u6cd5\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0:" + e.getMessage());
            throw e;
        }
    }

    public static void cardWithHint(WebView webView, JSONObject jo) throws Exception {
        try {
            String method = jo.getString("method");
            String callback = jo.getString("callback");
            CardAsyncTask dat = null;
            if (!jo.has("backresult") || jo.isNull("backresult")) {
                return;
            }
            int backresult = jo.getInt("backresult");
            dat = new CardAsyncTask((HybridActivity)webView.getContext(), method, callback, backresult);
            dat.execute(new String[0]);
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "cardWithHint\u6267\u884c\u5e26\u8fdb\u5ea6\u7684\u903b\u8f91\u51fa\u9519\u3002");
            NativeBaseMethod.alert(webView, "\u5f02\u6b65\u8c03\u7528card\u76f8\u5173\u65b9\u6cd5\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0:" + e.getMessage());
            throw e;
        }
    }

    public static void logicWithHint(WebView webView, JSONObject jo) throws Exception {
        try {
            String logic = jo.getString("logic");
            String callback = jo.getString("callback");
            jo.remove("logic");
            jo.remove("callback");
            GenericAsyncTask dat = null;
            if (jo.has("backresult") && !jo.isNull("backresult")) {
                int backresult = jo.getInt("backresult");
                dat = new GenericAsyncTask((HybridActivity)webView.getContext(), logic, callback, backresult);
            } else {
                dat = new GenericAsyncTask((HybridActivity)webView.getContext(), logic, callback);
            }
            if (jo.has("data")) {
                dat.execute(new String[]{jo.getString("data")});
            } else {
                dat.execute(new String[]{jo.toString()});
            }
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "logicWithHint\u6267\u884c\u5e26\u8fdb\u5ea6\u7684\u903b\u8f91\u51fa\u9519\u3002");
            NativeBaseMethod.alert(webView, "\u5f02\u6b65\u8c03\u7528logic\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0:" + e.getMessage());
            throw e;
        }
    }

    public static JSONObject logic(WebView webView, JSONObject jo) throws Exception {
        try {
            String logic = jo.getString("logic");
            jo.remove("logic");
            LogicService ls = new LogicService(webView.getContext());
            ls.addService("hint", new HintPlugin(null));
            return (JSONObject)ls.run(logic, jo);
        }
        catch (Exception e) {
            JSONObject error = new JSONObject();
            error.put("state", (Object)"nok");
            error.put("err_msg", (Object)e.getMessage());
            return error;
        }
    }

    public static JSONObject bzLogic(WebView webView, JSONObject jo) throws Exception {
        try {
            String logic = jo.getString("logic");
            jo.remove("logic");
            LogicService ls = new LogicService(webView.getContext());
            ls.addService("hint", new HintPlugin(null));
            return (JSONObject)ls.run(logic, jo.getJSONObject("data"));
        }
        catch (Exception e) {
            JSONObject error = new JSONObject();
            error.put("state", (Object)"nok");
            error.put("err_msg", (Object)e.getMessage());
            return error;
        }
    }

    public static JSONObject bzLogic(WebView webView, String param) throws Exception {
        JSONObject jo = new JSONObject(param);
        return NativeBaseMethod.bzLogic(webView, jo);
    }

    public static JSONObject syncBzLogic(WebView webView) throws Exception {
        String temp_json = json_str;
        json_str = "";
        JSONObject params = null;
        params = new JSONObject(temp_json);
        return NativeBaseMethod.bzLogic(webView, params);
    }

    public static JSONObject path(WebView webView, JSONObject jo) throws Exception {
        try {
            PathService ps = new PathService(webView.getContext());
            return ps.action(jo);
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u6267\u884c\u903b\u8f91\u51fa\u9519\u3002");
            throw e;
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    public static void _open_a_page(WebView webView, JSONObject jo) throws Exception {
        try {
            Context context = webView.getContext();
            String pageType = jo.getString("type").toLowerCase();
            if (pageType.equals("native")) {
                NativeBaseMethod.startupNativePage(jo.getString("page"), jo.getJSONObject("param"), context);
            } else if (pageType.equals("h5")) {
                NativeBaseMethod.startupH5Page(jo.getString("page"), jo.getString("method"), context);
            } else if (pageType.equals("boomerang")) {
                NativeBaseMethod.startupBoomerangPage(jo.getString("page"), jo.getJSONObject("param"), context);
            }
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u6253\u5f00\u65b0\u9875\u9762\u51fa\u9519\u3002");
            throw e;
        }
    }

    public static JSONObject print(WebView view, String params) throws JSONException {
        if (AFApplication.printer == null) {
            try {
                AFApplication.initPos(view.getContext());
            }
            catch (Exception e) {
                Log.e((String)"erro", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
                return new JSONObject("{\"code\":500, \"msg\":\"\u8c03\u7528\u6253\u5370\u673a\u5931\u8d25\uff0c\u9700\u8981\u91cd\u542f\u8bbe\u5907\"}");
            }
        }
        return new JSONObject(AFApplication.printer.print(params));
    }

    public static String getSN(WebView view) {
        if (!"true".equals(CommUtil.getSharedPreference(view.getContext(), "pos").toLowerCase())) {
            return AndroidIdentification.getUniqueId();
        }
        if (AFApplication.device == null) {
            try {
                AFApplication.initPos(view.getContext());
            }
            catch (Exception e) {
                Log.e((String)"erro", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
            }
        }
        return AFApplication.device.getSN();
    }

    public static String getIP(WebView view) {
        if (!"true".equals(CommUtil.getSharedPreference(view.getContext(), "pos").toLowerCase())) {
            return AndroidIdentification.getUniqueId();
        }
        if (AFApplication.device == null) {
            try {
                AFApplication.initPos(view.getContext());
            }
            catch (Exception e) {
                Log.e((String)"erro", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
            }
        }
        return AFApplication.device.getIP();
    }

    public static String getAddress(WebView view) {
        if (!"true".equals(CommUtil.getSharedPreference(view.getContext(), "pos").toLowerCase())) {
            return AndroidIdentification.getUniqueId();
        }
        if (AFApplication.device == null) {
            try {
                AFApplication.initPos(view.getContext());
            }
            catch (Exception e) {
                Log.e((String)"erro", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
            }
        }
        return AFApplication.device.getAddress();
    }

    public static void voicePromptOnce(WebView view, String voiceName) {
        Context ctx = view.getContext();
        player = new Player();
        player.playByPathOnce(ctx, "/data/data/com.aofeng.hybridwork/files/www/static/voice/" + voiceName);
    }

    public static void voicePrompts(WebView view, String voiceName) {
        Context ctx = view.getContext();
        player = new Player();
        player.playByPath(ctx, "/data/data/com.aofeng.hybridwork/files/www/static/voice/" + voiceName);
    }

    public static void stopPlayer(WebView view) {
        if (player != null) {
            player.stop();
            player = null;
        }
    }

    public static JSONObject read(WebView view) throws JSONException {
        if (AFApplication.card == null || AFApplication.device == null) {
            try {
                AFApplication.initPos(view.getContext());
            }
            catch (Exception e) {
                Log.e((String)"erro", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
                return new JSONObject("{\"code\":500, \"msg\":\"\u8c03\u7528\u8bfb\u5361\u5668\u5931\u8d25\uff0c\u9700\u8981\u91cd\u542f\u8bbe\u5907\"}");
            }
        }
        String json = AFApplication.card.read("");
        JSONObject jo = new JSONObject(json);
        return jo;
    }

    public static JSONObject read(WebView view, String Area) throws JSONException {
        if (AFApplication.card == null || AFApplication.device == null) {
            try {
                AFApplication.initPos(view.getContext());
            }
            catch (Exception e) {
                Log.e((String)"erro", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
                return new JSONObject("{\"code\":500, \"msg\":\"\u8c03\u7528\u8bfb\u5361\u5668\u5931\u8d25\uff0c\u9700\u8981\u91cd\u542f\u8bbe\u5907\"}");
            }
        }
        String json = AFApplication.card.read(Area);
        JSONObject jo = new JSONObject(json);
        return jo;
    }

    public static JSONObject read(WebView view, String Area, String mdmCode) throws JSONException {
        if (AFApplication.card == null || AFApplication.device == null) {
            try {
                AFApplication.initPos(view.getContext());
            }
            catch (Exception e) {
                Log.e((String)"erro", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
                return new JSONObject("{\"code\":500, \"msg\":\"\u8c03\u7528\u8bfb\u5361\u5668\u5931\u8d25\uff0c\u9700\u8981\u91cd\u542f\u8bbe\u5907\"}");
            }
        }
        String json = "";
        if (!mdmCode.startsWith("{")) {
            json = AFApplication.card.read(Area, mdmCode, null);
        } else {
            JSONObject encry = new JSONObject(mdmCode);
            if (encry.has("mdmCode")) {
                String code = encry.getString("mdmCode");
                json = AFApplication.card.read(Area, code, encry);
            } else {
                json = AFApplication.card.read(Area, encry);
            }
        }
        JSONObject jo = new JSONObject(json);
        return jo;
    }

    public static JSONObject sell(WebView view, String params) throws JSONException {
        if (AFApplication.card == null || AFApplication.device == null) {
            try {
                AFApplication.initPos(view.getContext());
            }
            catch (Exception e) {
                Log.e((String)"erro", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
                return new JSONObject("{\"code\":500, \"msg\":\"\u8c03\u7528\u8bfb\u5361\u5668\u5931\u8d25\uff0c\u9700\u8981\u91cd\u542f\u8bbe\u5907\"}");
            }
        }
        String result = AFApplication.card.sell(new JSONObject(params));
        return new JSONObject(result);
    }

    public static JSONObject sell(WebView view, String params, String encry) throws JSONException {
        if (AFApplication.card == null || AFApplication.device == null) {
            try {
                AFApplication.initPos(view.getContext());
            }
            catch (Exception e) {
                Log.e((String)"erro", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
                return new JSONObject("{\"code\":500, \"msg\":\"\u8c03\u7528\u8bfb\u5361\u5668\u5931\u8d25\uff0c\u9700\u8981\u91cd\u542f\u8bbe\u5907\"}");
            }
        }
        String result = "";
        result = encry.startsWith("{") ? AFApplication.card.sell(new JSONObject(params), new JSONObject(encry)) : AFApplication.card.sell(new JSONObject(params));
        return new JSONObject(result);
    }

    public static void searchPRMT(WebView view) {
        MainActivity.searchBluetooh();
    }

    public static boolean hasCard(WebView view) {
        if (AFApplication.card == null || AFApplication.device == null) {
            try {
                AFApplication.initPos(view.getContext());
            }
            catch (Exception e) {
                Log.e((String)"erro", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
                return false;
            }
        }
        return AFApplication.card.hasCard();
    }

    public static JSONObject issue(WebView view, String params) throws JSONException {
        return new JSONObject(AFApplication.card.issue(new JSONObject(params)));
    }

    public static void toSet(WebView webView) throws ClassNotFoundException {
        Context context = webView.getContext();
        String page = "com.aofeng.hybrid.activity.SetActivity";
        Intent intent = new Intent(context, Class.forName(page));
        Bundle bundle = new Bundle();
        bundle.putString("SCREEN_ORIENTATION", HybridActivity.SCREEN_ORIENTATION);
        intent.putExtras(bundle);
        ((Activity)context).startActivity(intent);
    }

    public static void _executeAsyncTask(WebView webView, final JSONObject jo, final NativeCallJS jsCallback) throws Exception {
        try {
            Object service;
            String className = jo.getString("type");
            if (!services.containsKey(className)) {
                String mangledName = "com.aofeng.hybrid.service." + className.substring(0, 1).toUpperCase() + className.substring(1) + "Service";
                Class<?> clazz = Class.forName(mangledName);
                Constructor<?> ctor = clazz.getConstructor(Context.class);
                service = ctor.newInstance(webView.getContext().getApplicationContext());
                services.put(className, service);
            } else {
                service = services.get(className);
            }
            TaskExecutor.scheduleTaskOnUiThread(0L, new Runnable(){

                @Override
                public void run() {
                    try {
                        jsCallback.apply(((GenericService)service).action(jo.getJSONObject("data")));
                    }
                    catch (Exception e) {
                        LogUtil.d("NativeBaseMethod", "\u8c03\u7528\u670d\u52a1\u51fa\u9519\u3002");
                    }
                }
            });
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u8c03\u7528\u670d\u52a1\u51fa\u9519\u3002");
            throw e;
        }
    }

    public static void simpleTask(WebView webView, JSONObject jo) throws Exception {
        try {
            SimpleAsyncTask dat = new SimpleAsyncTask((HybridActivity)webView.getContext(), jo);
            String callback = null;
            if (jo.has("callback") && !jo.isNull("callback")) {
                callback = jo.getString("callback");
            }
            dat.execute(new String[]{callback});
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u6267\u884c\u7b80\u5355\u5f02\u6b65\u4efb\u52a1\u51fa\u9519\u3002");
            throw e;
        }
    }

    public static JSONObject _executeTask(WebView webView, JSONObject jo) throws Exception {
        try {
            Object service;
            String className = jo.getString("type");
            if (!services.containsKey(className)) {
                String mangledName = "com.aofeng.hybrid.service." + className.substring(0, 1).toUpperCase() + className.substring(1) + "Service";
                Class<?> clazz = Class.forName(mangledName);
                Constructor<?> ctor = clazz.getConstructor(Context.class);
                service = ctor.newInstance(webView.getContext().getApplicationContext());
                services.put(className, service);
            } else {
                service = services.get(className);
            }
            return ((GenericService)service).action(jo.getJSONObject("data"));
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u8c03\u7528\u670d\u52a1\u51fa\u9519\u3002");
            throw e;
        }
    }

    public static void alert(WebView webView, String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(webView.getContext());
        builder.setTitle((CharSequence)"\u7cfb\u7edf\u63d0\u793a");
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.setCancelable(false);
        builder.create();
        builder.show();
    }

    public static void alert(WebView webView, int msg) {
        NativeBaseMethod.alert(webView, String.valueOf(msg));
    }

    public static void alert(WebView webView, boolean msg) {
        NativeBaseMethod.alert(webView, String.valueOf(msg));
    }

    public static void toast(WebView webView, String message) {
        Toast.makeText((Context)webView.getContext(), (CharSequence)message, (int)0).show();
    }

    public static void toast(WebView webView, JSONObject jo) {
        Toast.makeText((Context)webView.getContext(), (CharSequence)jo.toString(), (int)0).show();
    }

    public static void toast(WebView webView, String message, int isShowLong) {
        Toast.makeText((Context)webView.getContext(), (CharSequence)message, (int)isShowLong).show();
    }

    public static void goBack(WebView view) {
        if (view.getContext() instanceof Activity) {
            ((Activity)view.getContext()).finish();
        }
    }

    private static void startupNativePage(String page, JSONObject param, Context context) throws Exception {
        LogUtil.d("NativeBaseMethod", page);
        Intent intent = new Intent(context, Class.forName(page));
        Bundle bundle = new Bundle();
        bundle.putString("param", param.toString());
        intent.putExtras(bundle);
        context.startActivity(intent);
    }

    private static void startupBoomerangPage(String page, JSONObject param, Context context) throws Exception {
        LogUtil.d("NativeBaseMethod", page);
        Intent intent = new Intent(context, Class.forName(page));
        Bundle bundle = new Bundle();
        bundle.putString("param", param.toString());
        intent.putExtras(bundle);
        ((Activity)context).startActivityForResult(intent, param.getInt("requestCode"));
    }

    private static void startupH5Page(String page, String method, Context context) {
        Intent intent = new Intent(context, HybridActivity.class);
        Bundle bundle = new Bundle();
        if (!page.startsWith("http://")) {
            page = "file://" + context.getFilesDir().getAbsolutePath() + File.separator + "www/" + page;
        }
        LogUtil.d("NativeBaseMethod", page);
        bundle.putSerializable("param", (Serializable)new H5Param(page, method));
        intent.putExtras(bundle);
        context.startActivity(intent);
    }

    public static void makeAPhoneCall(WebView webView, String phoneNumber) {
        Intent callIntent = new Intent("android.intent.action.CALL");
        callIntent.setData(Uri.parse((String)("tel:" + phoneNumber)));
        ((HybridActivity)webView.getContext()).startActivity(callIntent);
    }

    public static void delfile(WebView webView, String path) {
        int n;
        if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        }
        if ((n = path.indexOf("?")) > 0) {
            path = path.substring(0, n);
        }
        File file = new File(path);
        file.delete();
    }

    public static void viewPic(WebView webView, String path) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setDataAndType(Uri.parse((String)path), "image/*");
        webView.getContext().startActivity(intent);
    }

    public static void confirm(final WebView webView, String msg, final String js) throws Exception {
        AlertDialog.Builder builder = new AlertDialog.Builder(webView.getContext());
        builder.setTitle((CharSequence)"\u7cfb\u7edf\u786e\u8ba4");
        builder.setMessage((CharSequence)msg);
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                webView.loadUrl(js);
            }
        });
        builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.setCancelable(false);
        builder.create();
        builder.show();
    }

    public static void getSignature(WebView webView, JSONObject jo) throws Exception {
        Context context = webView.getContext();
        Intent intent = new Intent(context, SignActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString("param", jo.toString());
        intent.putExtras(bundle);
        ((Activity)context).startActivityForResult(intent, 421);
    }

    public static String getProxyUrl(WebView webView) throws Exception {
        Context context = webView.getContext();
        JSONObject config = CommUtil.getHybridContext(context);
        String result = config.getString("cc_base_url");
        return result;
    }

    public static String getFullFileName(WebView webView, String fileName) throws Exception {
        String fullFillName = "";
        if (fileName.trim().length() > 0) {
            fullFillName = "file://" + Environment.getExternalStorageDirectory() + File.separator + "safecheck" + File.separator + fileName;
        }
        return fullFillName;
    }

    public static void delFileName(WebView webView, String FileName) throws Exception {
        File file;
        String Path2 = AFApplication.APP_DATA + FileName;
        if (Path2.trim().length() > 0 && (file = new File(Path2)).exists() && file.isFile()) {
            file.delete();
        }
    }

    public static void scanCode(WebView webView, JSONObject params) {
        Intent intent = null;
        intent = AFApplication.card.getReader() instanceof CTNativeReader ? new Intent(webView.getContext(), AutoQuickScanActivity.class) : (AFApplication.device instanceof LDDevice ? new Intent(webView.getContext(), LDScanActivity.class) : new Intent(webView.getContext(), CaptureActivity.class));
        Bundle bundle = new Bundle();
        bundle.putString("param", params.toString());
        intent.putExtras(bundle);
        ((Activity)webView.getContext()).startActivityForResult(intent, 0);
    }

    public static String getCode(WebView webView) throws JSONException {
        if (AFApplication.card.getReader() instanceof CTNativeReader) {
            String cadeStr = AutoQuickScanActivity.codeStr;
            AutoQuickScanActivity.codeStr = "";
            return cadeStr;
        }
        if (AFApplication.device instanceof LDDevice) {
            String cadeStr = LDScanActivity.codeStr;
            LDScanActivity.codeStr = "";
            return cadeStr;
        }
        String cadeStr = CaptureActivity.codeStr;
        CaptureActivity.codeStr = "";
        return cadeStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject readLocalFile(WebView webView, String fileName) throws JSONException, IOException {
        BufferedReader reader = null;
        JSONObject result = new JSONObject();
        CardAgent.log("readLocalFile fileName = " + fileName);
        try {
            File file = new File("/data/data/com.aofeng.hybridwork/files/www/static/" + fileName);
            if (file != null) {
                if (file.exists()) {
                    String mLine;
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    String str = "";
                    while ((mLine = reader.readLine()) != null) {
                        str = str + mLine;
                    }
                    result.put("code", 200);
                    result.put("data", (Object)str);
                }
            }
        }
        catch (Exception e) {
            result.put("code", 500);
            result.put("err", (Object)e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            Log.d((String)"\u8bfb\u53d6\u6587\u4ef6\u8fd4\u56de\u7ed9\u524d\u53f0\u7684json=>", (String)result.toString());
            CardAgent.log("\u8bfb\u53d6\u6587\u4ef6\u8fd4\u56de\u7ed9\u524d\u53f0\u7684json = " + result.toString());
            return result;
        }
    }

    public static JSONObject organizeJSON(WebView webView, JSONObject jo) throws JSONException {
        JSONObject result = null;
        try {
            result = new JSONObject();
            if (!jo.isNull("isStart") && jo.getBoolean("isStart")) {
                logic_param = new JSONObject();
                devices_array = new JSONArray();
            }
            if (!jo.isNull("isDevice") && jo.getBoolean("isDevice")) {
                devices_array.put((Object)new JSONObject(jo.getString("device")));
            } else if (!jo.isNull("isJSON") && jo.getBoolean("isJSON")) {
                logic_param = new JSONObject(jo.getString("jsonstr"));
            }
            result.put("code", 200);
        }
        catch (Exception e) {
            result.put("code", 500);
            result.put("err", (Object)e.getMessage());
        }
        return result;
    }

    public static void runSyncLogic(WebView webView, JSONObject jo) throws Exception {
        try {
            String logic = jo.getString("logic");
            String callback = jo.getString("callback");
            jo.remove("logic");
            jo.remove("callback");
            GenericAsyncTask dat = null;
            if (jo.has("backresult") && !jo.isNull("backresult")) {
                int backresult = jo.getInt("backresult");
                dat = new GenericAsyncTask((HybridActivity)webView.getContext(), logic, callback, backresult);
            } else {
                dat = new GenericAsyncTask((HybridActivity)webView.getContext(), logic, callback);
            }
            JSONObject row = new JSONObject(logic_param.getString("row"));
            row.put("f_devices", (Object)devices_array);
            logic_param.put("row", (Object)row);
            dat.execute(new String[]{logic_param.toString()});
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "runSyncLogic\u6267\u884c\u5f02\u5e38:" + e.getMessage());
            NativeBaseMethod.alert(webView, "\u5f02\u6b65\u8c03\u7528logic\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0:" + e.getMessage());
        }
    }

    public static void param_cache(WebView webView, String splitStr) {
        json_str = json_str + splitStr;
    }

    public static void syncLogic(WebView webView, JSONObject jo) throws Exception {
        try {
            String logic = jo.getString("logic");
            String callback = jo.getString("callback");
            jo.remove("logic");
            jo.remove("callback");
            GenericAsyncTask dat = null;
            if (jo.has("backresult") && !jo.isNull("backresult")) {
                int backresult = jo.getInt("backresult");
                dat = new GenericAsyncTask((HybridActivity)webView.getContext(), logic, callback, backresult);
            } else {
                dat = new GenericAsyncTask((HybridActivity)webView.getContext(), logic, callback);
            }
            String temp_json = json_str;
            json_str = "";
            if (temp_json.equals("")) {
                NativeBaseMethod.alert(webView, "\u5f02\u6b65\u8c03\u7528logic\u5931\u8d25,\u8bf7\u5148\u4f20\u5165\u53c2\u6570");
                return;
            }
            JSONObject param = null;
            try {
                param = new JSONObject(temp_json);
            }
            catch (JSONException e) {
                NativeBaseMethod.alert(webView, "\u5f02\u6b65\u8c03\u7528logic\u5931\u8d25,\u53c2\u6570\u4e0d\u662fjson\u683c\u5f0f\uff1a" + temp_json);
                return;
            }
            dat.execute(new String[]{param.toString()});
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "syncLogic\u6267\u884c\u5f02\u5e38:" + e.getMessage());
            NativeBaseMethod.alert(webView, "\u5f02\u6b65\u8c03\u7528logic\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0:" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject postUrl(WebView webView, String url, String token, String body) throws Exception {
        JSONObject jsonObject = new JSONObject();
        try {
            HttpClient httpClient = CommUtil.getCardServiceHttpClient();
            if (body != null && !"".equals(body)) {
                url = CardAgent.parseUrl(url, new JSONObject(body));
            }
            HttpPost httpPost = new HttpPost(url);
            if (token != null && !"".equals(token)) {
                httpPost.addHeader("Authorization", token);
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int code = response.getStatusLine().getStatusCode();
            jsonObject.put("code", code);
            if (code == 200) {
                String rev = EntityUtils.toString((HttpEntity)response.getEntity());
                jsonObject.put("data", (Object)new JSONObject(rev));
            }
        }
        catch (Exception e) {
            CardAgent.log("post\u6267\u884c\u5f02\u5e38:" + e.getMessage());
        }
        finally {
            CardAgent.log("posturl \u8fd4\u56de jsonObject = " + jsonObject);
            CardAgent.postlog2(NativeBaseMethod.getProxyUrl(webView));
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTerminalCode(WebView webView, String filename, String sn) throws Exception {
        CardAgent.log("getTerminalCode filename = " + filename);
        try {
            Context context = webView.getContext();
            JSONObject config = CommUtil.getHybridContext(context);
            String url = config.getString("cc_base_url");
            String dir = config.getString("REMOTE_WWW_PREFIX");
            String fileDownloadUrl = url + "/rs/dir";
            String path = dir + "static\\" + filename;
            HttpClient client = CommUtil.getTimeoutHttpClient();
            HttpPost post = new HttpPost(fileDownloadUrl);
            post.setEntity((HttpEntity)new StringEntity(path, "UTF-8"));
            HttpResponse response = client.execute((HttpUriRequest)post);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                JSONObject jsonObject = new JSONObject(result);
                String string2 = jsonObject.getString(sn);
                return string2;
            }
            String string3 = "";
            return string3;
        }
        catch (Exception e) {
            CardAgent.log("loadContextByAssets  Assets not " + filename);
            CardAgent.log("\u9519\u8bef " + e.getMessage());
        }
        finally {
            CardAgent.postlog2(NativeBaseMethod.getProxyUrl(webView));
        }
        return "";
    }

    public static void log(WebView webView, String message) throws Exception {
        CardAgent.log(message);
        CardAgent.postlog2(NativeBaseMethod.getProxyUrl(webView));
    }

    static {
        PayWayMap = new HashMap();
        PayWayMap.put(LD_BANKOFHEBEI, "com.aofeng.hybrid.activity.PayTransferActivity");
        PayWayMap.put(LD_BANKOFCHINA, "com.aofeng.hybrid.activity.BOCPayActivity");
        PayWayMap.put(CT_CHINAUMS, "com.aofeng.hybrid.activity.ChinaUmsPayActivity");
        logic_param = null;
        devices_array = null;
        json_str = "";
    }
}

