/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.HexDump;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.json.JSONObject;

public class CPUSocket
extends Thread {
    private ICardReader reader;
    private String body;

    public CPUSocket() {
    }

    CPUSocket(String body) {
        this.body = body;
        this.reader = AFApplication.card.getReader();
    }

    @Override
    public void run() {
        try {
            JSONObject json = new JSONObject(this.body);
            String UUID2 = (String)json.get("GUID");
            String[] strList = json.getString("socket_url").split("\\:");
            Socket socket = new Socket(strList[0], (int)Integer.valueOf(strList[1]));
            OutputStream ops = socket.getOutputStream();
            ops.write((UUID2 + "C").getBytes());
            InputStream ips = socket.getInputStream();
            while (true) {
                String byteStr;
                byte[] result;
                byte[] apdu;
                String apdustr;
                String byteStr2;
                byte[] result2;
                int length;
                if ((length = ips.available()) <= 0) {
                    Thread.sleep(5L);
                    continue;
                }
                byte[] s = new byte[length];
                ips.read(s);
                String str = new String(s);
                if ("OK".equals(str) || "ok".equals(str)) {
                    System.out.println("Socket\u901a\u4fe1\u5df2\u5339\u914d");
                    continue;
                }
                if (str.contains("ok") || str.contains("OK")) {
                    str = str.substring(2);
                }
                if ("cpu_reset".equals(str)) {
                    result2 = this.reader.resetCPUCard();
                    if (result2 == null) {
                        ops.write("6A82".getBytes());
                        continue;
                    }
                    byteStr2 = HexDump.toHexString(result2);
                    System.out.println(byteStr2);
                    ops.write(byteStr2.getBytes());
                    continue;
                }
                if ("sam_reset".equals(str)) {
                    result2 = this.reader.resetPSAMCard();
                    if (result2 == null) {
                        ops.write("6A82".getBytes());
                        continue;
                    }
                    byteStr2 = HexDump.toHexString(result2);
                    System.out.println(byteStr2);
                    ops.write(byteStr2.getBytes());
                    continue;
                }
                String[] strs = str.split(";");
                if ("cpu_protocol".equals(strs[0])) {
                    System.out.println("\u539f\u59cb\u6570\u636e:" + strs[2]);
                    apdustr = strs[2];
                    apdu = HexDump.hexStringToByteArray(apdustr);
                    result = this.reader.CPUsendAPDU(apdu);
                    if (result == null) {
                        ops.write("6A82".getBytes());
                        continue;
                    }
                    byteStr = HexDump.toHexString(result);
                    System.out.println("\u8fd4\u56de\u6570\u636e:" + byteStr);
                    ops.write(byteStr.getBytes());
                    continue;
                }
                if (!"sam_protocol".equals(strs[0])) continue;
                System.out.println("\u539f\u59cb\u6570\u636e:" + strs[2]);
                apdustr = strs[2];
                apdu = HexDump.hexStringToByteArray(apdustr);
                result = this.reader.PSAMsendAPDU(apdu);
                if (result == null) {
                    ops.write("6A82".getBytes());
                    continue;
                }
                byteStr = HexDump.toHexString(result);
                System.out.println("\u8fd4\u56de\u6570\u636e:" + byteStr);
                ops.write(byteStr.getBytes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

