/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.plugin;

import android.os.RemoteException;
import android.util.Log;
import com.aofeng.hybrid.pos.plugin.BlueRW;
import com.aofeng.hybrid.pos.plugin.ReadCard;
import com.aofeng.hybrid.pos.plugin.SlotCard;
import com.aofeng.hybrid.pos.plugin.StringUtility;
import com.aofeng.hybrid.pos.plugin.WriCard;
import com.aofeng.hybrid.pos.reader.CTChangAnReader;
import com.centerm.smartpos.aidl.iccard.AidlICCard;
import com.centerm.smartpos.aidl.rfcard.AidlRFCard;

public class CTCAReader {
    public static AidlRFCard rfReader;
    public static AidlICCard icReader;
    public int defaultReaderNo = 0;
    private BlueRW blueRW = new BlueRW();

    public SlotCard findTheSlotThatHasCardOn() {
        SlotCard sc = new SlotCard();
        Object mem102Solt = null;
        byte[] data = new byte[256];
        int rfCardSlot = this.ifCardOnContactlessSlot(data);
        int icCardSlot = this.ifCardInSlot(data);
        if (rfCardSlot == -2 && icCardSlot < 0) {
            sc.slot = -3;
        } else if (rfCardSlot == -1 && icCardSlot == -1) {
            sc.slot = -1;
        } else if (rfCardSlot >= 0 && icCardSlot >= 0) {
            sc.slot = -2;
        } else if (icCardSlot >= 0) {
            sc.slot = 2;
            sc.cardType = icCardSlot;
        } else if (rfCardSlot == 1) {
            sc.slot = 0;
            sc.cardType = 0;
        } else {
            sc.slot = 0;
            sc.cardType = rfCardSlot;
        }
        return sc;
    }

    private int ifCardInSlot(byte[] data) {
        if (icReader != null) {
            try {
                icReader.open();
                int cardType = CTChangAnReader.getCardType();
                if (cardType == 7) {
                    return 9;
                }
                return cardType;
            }
            catch (RemoteException e) {
                return -2;
            }
        }
        return -1;
    }

    private int ifCardOnContactlessSlot(byte[] data) {
        if (rfReader != null) {
            try {
                rfReader.open();
                if (rfReader.status() == 0) {
                    return -1;
                }
                int cardType = rfReader.readCardType();
                return cardType;
            }
            catch (RemoteException e) {
                return -2;
            }
        }
        return -1;
    }

    private int oneRound(int r, String s, byte[] ret) {
        byte[] b = StringUtility.StringToByteArray(s);
        byte[] result = null;
        try {
            result = r == 0 ? rfReader.send(b) : icReader.send(b);
            if (result == null) {
                return -1;
            }
            System.arraycopy(result, 0, ret, 0, result.length);
            return result.length;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private int isCPU() {
        SlotCard sc = this.findTheSlotThatHasCardOn();
        if (sc.slot < 0) {
            return sc.slot;
        }
        if (sc.slot == 1 && sc.cardType == 1) {
            return 1;
        }
        if (sc.slot == 0 && sc.cardType == 0) {
            return 0;
        }
        return -1;
    }

    public int prelude() {
        int n;
        int r = this.isCPU();
        if (r < 0) {
            return -9999;
        }
        if (this.openDevice(r) < 0) {
            return -9998;
        }
        byte[] ret = new byte[64];
        String cmd = "00A404000E325041592E5359532E4444463031";
        if (r == 1) {
            cmd = "00A404000E315041592E5359532E44444630310000";
        }
        if ((n = this.oneRound(r, cmd, ret)) < 0) {
            return -1;
        }
        if (n > 2 && ret[n - 2] == 97 && (n = this.oneRound(r, "00C00000" + StringUtility.ByteArrayToString(ret, n - 1, 1), ret)) < 0) {
            return -1;
        }
        return r;
    }

    public int readCard(ReadCard rc) {
        int r = this.prelude();
        if (r < 0) {
            return r;
        }
        BlueRW.icReader = icReader;
        BlueRW.rfReader = rfReader;
        this.blueRW.defaultReaderNo = this.defaultReaderNo;
        this.blueRW.isRfOrCpu = r;
        int n = this.blueRW.readRfCard(rc);
        this.closeDevice(r);
        return n;
    }

    private int openDevice(int ic) {
        try {
            if (ic == 0) {
                rfReader.open();
                byte[] ret = rfReader.reset();
                if (ret != null) {
                    return 0;
                }
                return -1;
            }
            icReader.open();
            return 0;
        }
        catch (RemoteException e) {
            return -2;
        }
    }

    private void closeDevice(int r) {
        try {
            if (r == 0) {
                rfReader.close();
            } else {
                icReader.close();
            }
        }
        catch (RemoteException e) {
            Log.e((String)"closeDevice", (String)("ERROR:" + e.getMessage()));
        }
    }

    public int writeCard(ReadCard rc, WriCard wc) {
        int r = this.prelude();
        if (r < 0) {
            return r;
        }
        BlueRW.icReader = icReader;
        BlueRW.rfReader = rfReader;
        this.blueRW.defaultReaderNo = this.defaultReaderNo;
        this.blueRW.isRfOrCpu = r;
        int n = this.blueRW.writeRfCard(rc, wc);
        this.closeDevice(r);
        return n;
    }

    public int clearCard(ReadCard rc, WriCard wc) {
        int r = this.prelude();
        if (r < 0) {
            return r;
        }
        BlueRW.icReader = icReader;
        BlueRW.rfReader = rfReader;
        this.blueRW.defaultReaderNo = this.defaultReaderNo;
        this.blueRW.isRfOrCpu = r;
        int n = this.blueRW.clearRfCard(rc, wc);
        this.closeDevice(r);
        return n;
    }
}

