/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.plugin.AFChromeClient;
import com.aofeng.hybrid.plugin.AFWebViewClient;
import com.aofeng.hybrid.plugin.H5Param;
import com.aofeng.hybrid.service.LogicService;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import java.lang.reflect.Method;

public class HybridActivity
extends Activity {
    private static final String TAG = HybridActivity.class.getSimpleName();
    public WebView mWebView;
    ProgressDialog pd;
    public static String SCREEN_ORIENTATION;

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.pd = new ProgressDialog((Context)this, 3);
        this.pd.setCancelable(false);
        Bundle bundle = this.getIntent().getExtras();
        String full = bundle.getString("full_screen");
        if ("true".equals(full)) {
            this.requestWindowFeature(1);
            this.getWindow().setFlags(1024, 1024);
            String deviceRefl = CommUtil.getSharedPreference((Context)this, "device");
            if ("com.aofeng.hybrid.pos.device.ZTDevice".equals(deviceRefl)) {
                Intent intent = new Intent();
                intent.setAction("szzt.action.service.NAV_BAR_HIDE");
                this.sendBroadcast(intent);
                Intent intent1 = new Intent();
                intent1.setAction("szzt.action.service.DROP_STATUS_DISABLE");
                this.sendBroadcast(intent1);
                Intent intent2 = new Intent();
                intent2.setAction("szzt.action.service.STATUS_BAR_HIDE");
                this.sendBroadcast(intent2);
            }
        }
        if ((SCREEN_ORIENTATION = bundle.getString("SCREEN_ORIENTATION")).equals("0")) {
            this.setRequestedOrientation(6);
        } else if (SCREEN_ORIENTATION.equals("2")) {
            this.setRequestedOrientation(0);
        } else if (!"true".equals(CommUtil.getSharedPreference((Context)this, "pos").toLowerCase())) {
            this.setRequestedOrientation(1);
        }
        this.getWindow().addFlags(128);
        H5Param hp = (H5Param)bundle.getSerializable("param");
        this.setContentView(R.layout.main);
        this.mWebView = (WebView)this.findViewById(R.id.wvPortal);
        this.mWebView.setWebViewClient((WebViewClient)new AFWebViewClient(this));
        try {
            this.mWebView.setWebChromeClient((WebChromeClient)new AFChromeClient("HostApp", Class.forName(hp.clazz)));
        }
        catch (ClassNotFoundException e) {
            LogUtil.d(TAG, "\u6253\u5f00h5\u9875\u9762\u9519\u8bef\u3002" + hp.clazz);
        }
        WebSettings mWebSettings = this.mWebView.getSettings();
        mWebSettings.setJavaScriptEnabled(true);
        mWebSettings.setAllowFileAccess(true);
        mWebSettings.setDomStorageEnabled(true);
        mWebSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        mWebSettings.setCacheMode(2);
        if (Build.VERSION.SDK_INT >= 17) {
            mWebSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                Class<?> clazz = mWebSettings.getClass();
                Method method = clazz.getMethod("setAllowUniversalAccessFromFileURLs", Boolean.TYPE);
                if (method != null) {
                    method.invoke((Object)mWebSettings, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mWebView.requestFocus(130);
        if (savedInstanceState != null) {
            this.mWebView.restoreState(savedInstanceState);
        } else {
            this.mWebView.loadUrl(hp.page);
        }
        LogUtil.d(TAG, hp.page);
    }

    public void onBackPressed() {
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
        } else {
            super.onBackPressed();
        }
    }

    protected void onPause() {
        super.onPause();
        LogUtil.d("HybridActivity:", "Paused");
    }

    protected void onStop() {
        super.onStop();
        LogUtil.d("HybridActivity:", "Stopped");
        this.invokeKnownLogic();
    }

    private void invokeKnownLogic() {
        try {
            LogicService logicService = new LogicService((Context)this);
            logicService.run("ScreenLocked", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mWebView.destroy();
        LogUtil.d("HybridActivity:", "Destroyed");
    }

    private void destroyWebView() {
        ((RelativeLayout)this.findViewById(R.id.wvContainer)).removeAllViews();
        if (this.mWebView != null) {
            this.mWebView.clearCache(true);
            this.mWebView.destroy();
            this.mWebView = null;
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mWebView.saveState(outState);
        LogUtil.d("HybridActivity:", "onSaveInstanceState");
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            String callback = data.getStringExtra("callback");
            this.mWebView.loadUrl(callback);
        }
    }

    public void createProgressDialog(int progressStyle) {
        this.pd.setProgressStyle(progressStyle);
    }

    public void setProgress(int progress, String hint) {
        if (!this.pd.isShowing()) {
            this.pd.show();
        }
        this.pd.setMessage((CharSequence)hint);
        this.pd.setProgress(progress);
    }

    public void showProgress() {
        this.pd.show();
    }

    public void setMessage(String hint) {
        if (!this.pd.isShowing()) {
            this.pd.show();
        }
        this.pd.setMessage((CharSequence)hint);
    }

    public void closeProgress() {
        this.pd.dismiss();
    }
}

