/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import com.aofeng.hybrid.pos.device.LDDevice;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.HexDump;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.IntegerBuffer;

public class LDChangAnReader
implements ICardReader {
    @Override
    public boolean openDevice(Chip chip) {
        int result;
        block6: {
            result = -1;
            BytesBuffer atr = new BytesBuffer();
            try {
                if (chip.chipName == 0) {
                    result = LDDevice.driverFor1604.powerUp(0, atr);
                    break block6;
                }
                if (chip.chipName == 1) {
                    result = LDDevice.driverFor4442.powerUp(0, atr);
                    break block6;
                }
                if (chip.chipName == 2) {
                    result = LDDevice.driverFor24C01.powerUp();
                    break block6;
                }
                if (chip.chipName == 9) {
                    result = 0;
                    break block6;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return result == 0;
    }

    @Override
    public boolean closeDevice(Chip chip) {
        int result;
        block6: {
            result = -1;
            try {
                if (chip.chipName == 0) {
                    result = LDDevice.driverFor1604.powerDown();
                    break block6;
                }
                if (chip.chipName == 1) {
                    result = LDDevice.driverFor4442.powerDown();
                    break block6;
                }
                if (chip.chipName == 3) {
                    result = LDDevice.driverFor24C01.powerDown();
                    break block6;
                }
                if (chip.chipName == 9) {
                    LDDevice.rfCpuCardDriver.halt();
                    LDDevice.rfCardReader.stopSearch();
                    result = 0;
                    break block6;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return result == 0;
    }

    @Override
    public boolean read(Chip chip) {
        try {
            if (chip.chipName == 1) {
                return LDChangAnReader.read4442(0, 256, chip.buf);
            }
            if (chip.chipName == 0) {
                if (chip.secret != null) {
                    for (int i = 0; i < chip.secret.length(); i += 4) {
                        String pwd = chip.secret.substring(i, i + 4);
                        if (!LDChangAnReader.verify102Pwd(HexDump.hexStringToByteArray(pwd))) continue;
                        chip.secret = pwd;
                        return LDChangAnReader.read102(0, 178, chip.buf, null);
                    }
                    return false;
                }
                return LDChangAnReader.read102(0, 178, chip.buf, null);
            }
            if (chip.chipName == 2) {
                return LDChangAnReader.read24C01(0, 128, chip.buf);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean write(Chip chip, int block, int offset, int len, byte[] buf, byte[] secret) {
        if (chip.chipName == 0) {
            return LDChangAnReader.write102(offset, len, buf, secret);
        }
        if (chip.chipName == 1) {
            return LDChangAnReader.write4442(offset, len, buf, secret);
        }
        if (chip.chipName == 2) {
            return LDChangAnReader.write24c01(offset, len, buf);
        }
        return false;
    }

    @Override
    public boolean verifyPwd(Chip chip, int block, byte[] secret) {
        if (chip.chipName == 0) {
            for (int i = 0; i < secret.length; i += 2) {
                if (!LDChangAnReader.verify102Pwd(new byte[]{secret[i], secret[i + 1]})) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 1) {
            for (int i = 0; i < secret.length; i += 3) {
                if (!LDChangAnReader.verify4442Pwd(new byte[]{secret[i], secret[i + 1], secret[i + 2]})) continue;
                return true;
            }
            return false;
        }
        return chip.chipName != 6;
    }

    @Override
    public boolean changePwd(Chip chip, int block, byte[] oldSecret, byte[] newSecret) {
        if (chip.chipName == 0) {
            return LDChangAnReader.change102Pwd(oldSecret, newSecret);
        }
        if (chip.chipName == 1) {
            return LDChangAnReader.change4442Pwd(oldSecret, newSecret);
        }
        return chip.chipName != 6;
    }

    @Override
    public Chip getNvlChip() {
        try {
            int ct = LDChangAnReader.getCardType();
            if (ct == 1) {
                return new Chip(1);
            }
            if (ct == 0) {
                return new Chip(0);
            }
            if (ct == 2) {
                return new Chip(2);
            }
            if (ct == 3) {
                return new Chip(3);
            }
            if (ct == 6) {
                return new Chip(6);
            }
            if (LDDevice.rfCpuCardDriver.exists()) {
                return new Chip(9);
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] resetCPUCard() {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] resetRFCard() {
        try {
            BytesBuffer bb = new BytesBuffer();
            LDDevice.rfCardReader.activate("PRO", bb);
            return bb.getData();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] resetPSAMCard() {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] CPUsendAPDU(byte[] apdu) {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] RFsendAPDU(byte[] apdu) {
        try {
            BytesBuffer bb = new BytesBuffer();
            LDDevice.rfCpuCardDriver.exchangeApdu(apdu, bb);
            return bb.getData();
        }
        catch (RequestException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] PSAMsendAPDU(byte[] apdu) {
        byte[] data = new byte[8];
        return data;
    }

    public static boolean write24c01(int offset, int len, byte[] buf) {
        int ret = -1;
        try {
            ret = LDDevice.driverFor24C01.write(offset, buf, 0, buf.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return ret == 0;
    }

    public static boolean write4442(int offset, int len, byte[] buf, byte[] key) {
        int result = -1;
        if (LDChangAnReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !LDChangAnReader.verify4442Pwd(key)) {
            return false;
        }
        try {
            result = LDDevice.driverFor4442.write(offset, buf, 0, len);
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        return result == 0;
    }

    public static boolean write102(int offset, int len, byte[] buf, byte[] key) {
        int ret = -1;
        if (key != null && !LDChangAnReader.verify102Pwd(key)) {
            return false;
        }
        try {
            ret = LDDevice.driverFor1604.write(offset, buf, 0, len);
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        return ret == 0;
    }

    public static boolean read24C01(int offset, int len, byte[] buf) {
        byte[] data = new byte[len];
        int result = -1;
        try {
            result = LDDevice.driverFor24C01.read(0, data, offset, len);
            if (result == 0) {
                System.arraycopy(data, 0, buf, 0, data.length);
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean verify4442Pwd(byte[] key) {
        int result = -1;
        IntegerBuffer integerBuffer = new IntegerBuffer();
        try {
            result = LDDevice.driverFor4442.verify(key, integerBuffer);
        }
        catch (Exception e) {
            return false;
        }
        return result == 0;
    }

    public static boolean change4442Pwd(byte[] oldKey, byte[] newKey) {
        int result = -1;
        if (LDChangAnReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !LDChangAnReader.verify4442Pwd(oldKey)) {
            return false;
        }
        try {
            result = LDDevice.driverFor4442.changeKey(newKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result == 0;
    }

    public static boolean change102Pwd(byte[] oldKey, byte[] newKey) {
        if (oldKey != null && !LDChangAnReader.verify102Pwd(oldKey)) {
            return false;
        }
        int ret = -1;
        try {
            ret = LDDevice.driverFor1604.changeKey(0, newKey);
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        return ret == 0;
    }

    @Override
    public boolean hasCard() {
        boolean has4442Card = false;
        boolean has102Card = false;
        try {
            has4442Card = LDDevice.driverFor4442.exists();
            has102Card = LDDevice.driverFor1604.exists();
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        LDDevice.logout();
        return has4442Card || has102Card;
    }

    public static boolean read4442(int offset, int len, byte[] buf) {
        byte[] data = new byte[len];
        int result = -1;
        if (LDChangAnReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        try {
            result = LDDevice.driverFor4442.read(0, data, offset, len);
            if (result == 0) {
                System.arraycopy(data, 0, buf, 0, data.length);
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static int get4442PwdAttemptCnt() {
        int result = -1;
        IntegerBuffer intBuff = new IntegerBuffer();
        try {
            result = LDDevice.driverFor4442.readErrorCount(intBuff);
        }
        catch (Exception e) {
            return -1;
        }
        return result == 0 ? 3 - intBuff.getData() : 0;
    }

    public static int get102PwdAttemptCnt() {
        String errorCount;
        int result = -1;
        byte[] data = new byte[1];
        try {
            result = LDDevice.driverFor1604.read(12, data, 0, 1);
            errorCount = HexDump.decBytesToHex(data).substring(0, 1);
        }
        catch (Exception e) {
            return -1;
        }
        if (errorCount.equals("F")) {
            return 4;
        }
        if (errorCount.equals("7")) {
            return 3;
        }
        if (errorCount.equals("3")) {
            return 2;
        }
        if (errorCount.equals("1")) {
            return 1;
        }
        return 0;
    }

    public static boolean verify102Pwd(byte[] key) {
        int result = -1;
        IntegerBuffer intBuff = new IntegerBuffer();
        try {
            result = LDDevice.driverFor1604.verify(0, key, intBuff);
        }
        catch (Exception e) {
            return false;
        }
        return result == 0;
    }

    public static boolean read102(int offset, int len, byte[] buf, byte[] key) {
        int result = -1;
        byte[] data = new byte[len];
        if (key != null && !LDChangAnReader.verify102Pwd(key)) {
            return false;
        }
        try {
            result = LDDevice.driverFor1604.read(0, data, offset, len);
            if (result == 0) {
                System.arraycopy(data, 0, buf, 0, data.length);
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static int getCardType() {
        BytesBuffer atr = new BytesBuffer();
        byte[] buf = new byte[20];
        try {
            int ret = LDDevice.driverFor1604.powerUp(0, atr);
            ret = LDDevice.driverFor1604.read(0, buf, 0, 2);
            if (buf[0] == 15 && buf[1] == 15 || buf[0] == 113 && buf[1] == 85 || buf[0] == 23 && buf[1] == 170) {
                return 0;
            }
            buf = new byte[20];
            ret = LDDevice.driverFor4442.powerUp(0, atr);
            ret = LDDevice.driverFor4442.read(0, buf, 0, 8);
            if (buf[6] == -127 && buf[7] == 21) {
                return 1;
            }
        }
        catch (Exception e) {
            String error = e.getMessage();
            return -1;
        }
        return -1;
    }

    private static boolean isAllZero(byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] == 0) continue;
            return false;
        }
        return true;
    }
}

