/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.sign;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.MotionEvent;
import com.aofeng.hybrid.android.sign.BasePen;
import com.aofeng.hybrid.android.sign.Bezier;
import com.aofeng.hybrid.android.sign.ControllerPoint;
import com.aofeng.hybrid.android.sign.MotionElement;
import java.util.ArrayList;

public abstract class BasePenExtend
extends BasePen {
    public ArrayList<ControllerPoint> mHWPointList = new ArrayList();
    public ArrayList<ControllerPoint> mPointList = new ArrayList();
    public ControllerPoint mLastPoint = new ControllerPoint(0.0f, 0.0f);
    public Paint mPaint;
    public double mBaseWidth;
    public double mLastVel;
    public double mLastWidth;
    public Bezier mBezier = new Bezier();
    protected ControllerPoint mCurPoint;
    protected Context mContext;

    public BasePenExtend(Context context) {
        this.mContext = context;
    }

    public void setPaint(Paint paint) {
        this.mPaint = paint;
        this.mBaseWidth = paint.getStrokeWidth();
    }

    @Override
    public void draw(Canvas canvas) {
        this.mPaint.setStyle(Paint.Style.FILL);
        if (this.mHWPointList == null || this.mHWPointList.size() < 1) {
            return;
        }
        if (this.mHWPointList.size() < 2) {
            ControllerPoint controllerPoint = this.mHWPointList.get(0);
        } else {
            this.mCurPoint = this.mHWPointList.get(0);
            this.drawNeetToDo(canvas);
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, Canvas canvas) {
        MotionEvent event2 = MotionEvent.obtain((MotionEvent)event);
        switch (event.getActionMasked()) {
            case 0: {
                this.onDown(this.createMotionElement(event2));
                return true;
            }
            case 2: {
                this.onMove(this.createMotionElement(event2));
                return true;
            }
            case 1: {
                this.onUp(this.createMotionElement(event2), canvas);
                return true;
            }
        }
        return super.onTouchEvent(event, canvas);
    }

    public void onDown(MotionElement mElement) {
        if (this.mPaint == null) {
            throw new NullPointerException("paint \u7b14\u4e0d\u53ef\u80fd\u4e3anull\u54e6");
        }
        if (this.getNewPaint(this.mPaint) != null) {
            Paint paint;
            this.mPaint = paint = this.getNewPaint(this.mPaint);
            paint = null;
            System.out.println("shiming \u5f53\u7ed8\u5236\u7684\u65f6\u5019\u662f\u5426\u4e3a\u65b0\u7684paint" + this.mPaint + "\u539f\u6765\u7684\u5bf9\u8c61\u662f\u5426\u9500\u6bc1\u4e86paint==" + paint);
        }
        this.mPointList.clear();
        this.mHWPointList.clear();
        ControllerPoint curPoint = new ControllerPoint(mElement.x, mElement.y);
        this.mLastWidth = mElement.tooltype == 2 ? (double)mElement.pressure * this.mBaseWidth : 0.8 * this.mBaseWidth;
        curPoint.width = (float)this.mLastWidth;
        this.mLastVel = 0.0;
        this.mPointList.add(curPoint);
        this.mLastPoint = curPoint;
    }

    protected Paint getNewPaint(Paint paint) {
        return null;
    }

    public void onMove(MotionElement mElement) {
        double curWidth;
        ControllerPoint curPoint = new ControllerPoint(mElement.x, mElement.y);
        double deltaX = curPoint.x - this.mLastPoint.x;
        double deltaY = curPoint.y - this.mLastPoint.y;
        double curDis = Math.hypot(deltaX, deltaY);
        double curVel = curDis * (double)0.02f;
        if (this.mPointList.size() < 2) {
            curWidth = mElement.tooltype == 2 ? (double)mElement.pressure * this.mBaseWidth : this.calcNewWidth(curVel, this.mLastVel, curDis, 1.5, this.mLastWidth);
            curPoint.width = (float)curWidth;
            this.mBezier.init(this.mLastPoint, curPoint);
        } else {
            this.mLastVel = curVel;
            curWidth = mElement.tooltype == 2 ? (double)mElement.pressure * this.mBaseWidth : this.calcNewWidth(curVel, this.mLastVel, curDis, 1.5, this.mLastWidth);
            curPoint.width = (float)curWidth;
            this.mBezier.addNode(curPoint);
        }
        this.mLastWidth = curWidth;
        this.mPointList.add(curPoint);
        this.moveNeetToDo(curDis);
        this.mLastPoint = curPoint;
    }

    public void onUp(MotionElement mElement, Canvas canvas) {
        ControllerPoint point;
        double t;
        this.mCurPoint = new ControllerPoint(mElement.x, mElement.y);
        double deltaX = this.mCurPoint.x - this.mLastPoint.x;
        double deltaY = this.mCurPoint.y - this.mLastPoint.y;
        double curDis = Math.hypot(deltaX, deltaY);
        this.mCurPoint.width = mElement.tooltype == 2 ? (float)((double)mElement.pressure * this.mBaseWidth) : 0.0f;
        this.mPointList.add(this.mCurPoint);
        this.mBezier.addNode(this.mCurPoint);
        int steps = 1 + (int)curDis / 10;
        double step = 1.0 / (double)steps;
        for (t = 0.0; t < 1.0; t += step) {
            point = this.mBezier.getPoint(t);
            this.mHWPointList.add(point);
        }
        this.mBezier.end();
        for (t = 0.0; t < 1.0; t += step) {
            point = this.mBezier.getPoint(t);
            this.mHWPointList.add(point);
        }
        this.draw(canvas);
        this.clear();
    }

    public double calcNewWidth(double curVel, double lastVel, double curDis, double factor, double lastWidth) {
        double calVel = curVel * 0.6 + lastVel * 0.4;
        double vfac = Math.log(factor * 2.0) * -calVel;
        double calWidth = this.mBaseWidth * Math.exp(vfac);
        double mMoveThres = curDis * (double)0.01f;
        if (mMoveThres > 10.0) {
            mMoveThres = 10.0;
        }
        return calWidth;
    }

    public MotionElement createMotionElement(MotionEvent motionEvent) {
        MotionElement motionElement = new MotionElement(motionEvent.getX(), motionEvent.getY(), motionEvent.getPressure(), motionEvent.getToolType(0));
        return motionElement;
    }

    public void clear() {
        this.mPointList.clear();
        this.mHWPointList.clear();
    }

    protected void drawToPoint(Canvas canvas, ControllerPoint point, Paint paint) {
        if (this.mCurPoint.x == point.x && this.mCurPoint.y == point.y) {
            return;
        }
        this.doNeetToDo(canvas, point, paint);
    }

    public boolean isNull() {
        return this.mPaint == null;
    }

    protected abstract void moveNeetToDo(double var1);

    protected abstract void doNeetToDo(Canvas var1, ControllerPoint var2, Paint var3);

    protected abstract void drawNeetToDo(Canvas var1);
}

