/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.service;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import com.aofeng.hybrid.android.service.AbstractService;

public class ServiceManager {
    private Class<? extends AbstractService> mServiceClass;
    private Context mActivity;
    private boolean mIsBound;
    private Messenger mService = null;
    private Handler mIncomingHandler = null;
    private final Messenger mMessenger = new Messenger((Handler)new IncomingHandler());
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            ServiceManager.this.mService = new Messenger(service);
            Log.i((String)"ServiceHandler", (String)"Attached.");
            try {
                Message msg = Message.obtain(null, (int)9991);
                msg.replyTo = ServiceManager.this.mMessenger;
                ServiceManager.this.mService.send(msg);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            ServiceManager.this.mService = null;
            Log.i((String)"ServiceHandler", (String)"Disconnected.");
        }
    };

    public ServiceManager(Context context, Class<? extends AbstractService> serviceClass, Handler incomingHandler) {
        this.mActivity = context;
        this.mServiceClass = serviceClass;
        this.mIncomingHandler = incomingHandler;
        if (this.isRunning()) {
            this.doBindService();
        }
    }

    public void start() {
        this.doStartService();
        this.doBindService();
    }

    public void stop() {
        this.doUnbindService();
        this.doStopService();
    }

    public void unbind() {
        this.doUnbindService();
    }

    public boolean isRunning() {
        ActivityManager manager = (ActivityManager)this.mActivity.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!this.mServiceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void send(Message msg) throws RemoteException {
        if (this.mIsBound && this.mService != null) {
            this.mService.send(msg);
        }
    }

    private void doStartService() {
        this.mActivity.startService(new Intent(this.mActivity, this.mServiceClass));
    }

    private void doStopService() {
        this.mActivity.stopService(new Intent(this.mActivity, this.mServiceClass));
    }

    private void doBindService() {
        this.mActivity.bindService(new Intent(this.mActivity, this.mServiceClass), this.mConnection, 1);
        this.mIsBound = true;
    }

    private void doUnbindService() {
        if (this.mIsBound) {
            if (this.mService != null) {
                try {
                    Message msg = Message.obtain(null, (int)9992);
                    msg.replyTo = this.mMessenger;
                    this.mService.send(msg);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mActivity.unbindService(this.mConnection);
            this.mIsBound = false;
            Log.i((String)"ServiceHandler", (String)"Unbinding.");
        }
    }

    private class IncomingHandler
    extends Handler {
        private IncomingHandler() {
        }

        public void handleMessage(Message msg) {
            if (ServiceManager.this.mIncomingHandler != null) {
                Log.i((String)"ServiceHandler", (String)("Incoming message. Passing to handler: " + msg));
                ServiceManager.this.mIncomingHandler.handleMessage(msg);
            }
        }
    }
}

