/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.printer;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Message;
import com.aofeng.hybrid.pos.printer.AfPrinter;
import com.aofeng.hybrid.util.BluetoothService;
import com.aofeng.hybrid.util.command.PrintPicture;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import zj.com.customize.sdk.Other;

public class BTPrint
implements AfPrinter {
    private BluetoothAdapter mBtAdapter;
    private BluetoothService mService;
    @SuppressLint(value={"HandlerLeak"})
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
        }
    };

    public static byte translate(int i) {
        switch (i) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
        }
        return 0;
    }

    public BTPrint() {
        this.mBtAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mService = new BluetoothService(this.mHandler);
    }

    @Override
    public boolean openPrinter() {
        if (!this.mBtAdapter.isEnabled()) {
            this.mBtAdapter.enable();
        }
        if (this.mService != null) {
            this.mService.start();
        }
        return true;
    }

    public Set<BluetoothDevice> getBondedDevices() {
        if (this.mBtAdapter != null) {
            return this.mBtAdapter.getBondedDevices();
        }
        return null;
    }

    public void connect(String macAddress) {
        this.mBtAdapter.cancelDiscovery();
        if (BluetoothAdapter.checkBluetoothAddress((String)macAddress)) {
            BluetoothDevice device = this.mBtAdapter.getRemoteDevice(macAddress);
            this.mService.connect(device);
        }
    }

    @Override
    public int getPrinterState() {
        int statusCode = 0;
        try {
            statusCode = this.mService.getState();
        }
        catch (Exception e) {
            return statusCode;
        }
        return statusCode;
    }

    @Override
    public int print(String msg) {
        int res = 1;
        long startTime = System.currentTimeMillis();
        String address = "";
        try {
            if (this.getPrinterState() != 3) {
                this.openPrinter();
                Set<BluetoothDevice> binds = this.getBondedDevices();
                for (BluetoothDevice device : binds) {
                    address = device.getAddress();
                    this.connect(address);
                }
            }
            Thread.sleep(800L);
            while (this.getPrinterState() != 3) {
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > 2000L) {
                    this.openPrinter();
                    Set<BluetoothDevice> binds = this.getBondedDevices();
                    for (BluetoothDevice device : binds) {
                        address = device.getAddress();
                        this.connect(address);
                    }
                    Thread.sleep(800L);
                    if (this.getPrinterState() != 3) {
                        return -11;
                    }
                }
                Thread.sleep(200L);
            }
            JSONArray arry = new JSONArray(msg);
            if (arry.length() > 0) {
                byte[] tail = new byte[]{10, 13, 0};
                for (int i = 0; i < arry.length(); ++i) {
                    JSONObject json = arry.getJSONObject(i);
                    this.mService.write(new byte[]{27, 77, BTPrint.translate(2)});
                    if (json.getInt("type") == 1) {
                        this.mService.write(json.getString("text").getBytes("GBK"));
                        this.mService.write(new byte[]{29, 107, 65, 12});
                        continue;
                    }
                    if (json.getInt("type") == 2) {
                        this.mService.write(json.getString("text").getBytes("GBK"));
                        this.mService.write(new byte[]{27, 90, 3, 3, 8, 0, 0});
                        continue;
                    }
                    if (json.getInt("type") == 3) {
                        String mssssg = json.getString("text") + "\n";
                        this.mService.write(mssssg.getBytes("GBK"));
                        continue;
                    }
                    if (json.getInt("type") == 4) {
                        String unit = json.getString("unit");
                        if (unit.equals("pixel")) {
                            char n = (char)json.getInt("value");
                            this.mService.write(new byte[]{27, 74, BTPrint.translate(n)});
                            continue;
                        }
                        if (!unit.equals("line")) continue;
                        char n = (char)json.getInt("value");
                        this.mService.write(new byte[]{27, 100, BTPrint.translate(n)});
                        continue;
                    }
                    if (json.getInt("type") != 5) continue;
                    if (json.has("align")) {
                        String align = json.getString("align");
                        if (align.equals("center")) {
                            this.mService.write(new byte[]{27, 97, 1});
                        } else if (align.equals("left")) {
                            this.mService.write(new byte[]{27, 97, 0});
                        } else if (align.equals("right")) {
                            this.mService.write(new byte[]{27, 97, 2});
                        }
                    }
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = false;
                    String filePath = json.getString("url");
                    Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options).copy(Bitmap.Config.ARGB_8888, true);
                    Bitmap bmp = Other.createAppIconText((Bitmap)bitmap, (String)"", (float)25.0f, (boolean)true, (int)200);
                    this.mService.write(PrintPicture.POS_PrintBMP(bitmap, 384, 0));
                }
                this.mService.write(tail);
            }
            Thread.sleep(200L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    @Override
    public boolean closePrinter() {
        if (this.mService != null) {
            this.mService.stop();
        }
        if (this.mBtAdapter != null) {
            this.mBtAdapter.cancelDiscovery();
        }
        return true;
    }
}

