/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.orm;

import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;

public class Column {
    public static String normalizeType(String type) {
        String tp = type.toLowerCase();
        if (tp.equals("string") || tp.equals("date") || tp.equals("time")) {
            return "TEXT";
        }
        if (tp.equals("integer")) {
            return "INTEGER";
        }
        if (tp.equals("boolean")) {
            return "NUMERIC";
        }
        if (tp.equals("double") || tp.equals("big_decimal")) {
            return "REAL";
        }
        if (tp.equals("blob")) {
            return "BLOB";
        }
        return "TEXT";
    }

    public static String normalizeValue(String type, String value) {
        if (value == null) {
            return "NULL";
        }
        if ((type = type.toLowerCase()).equals("string") || type.equals("date") || type.equals("time")) {
            return "'" + value + "'";
        }
        return value;
    }

    public static Object normalizeValue(Cursor cursor, int idx) {
        SQLiteCursor sqLiteCursor = (SQLiteCursor)cursor;
        CursorWindow cursorWindow = sqLiteCursor.getWindow();
        int pos = cursor.getPosition();
        int type = -1;
        if (cursorWindow.isNull(pos, idx)) {
            return null;
        }
        if (cursorWindow.isString(pos, idx)) {
            return cursor.getString(idx);
        }
        if (cursorWindow.isFloat(pos, idx)) {
            return Float.valueOf(cursor.getFloat(idx));
        }
        if (cursorWindow.isLong(pos, idx)) {
            return cursor.getInt(idx);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\u3002");
    }

    public static boolean isCompatible(String type, String type2) {
        return true;
    }
}

