/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.orm;

import android.content.Context;
import com.af.util.Pair;
import com.aofeng.hybrid.util.LogUtil;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class DBMeta
implements Serializable {
    private static HashMap<String, HashMap<String, Object>> metaMap = null;
    public static HashMap<String, String> entityLiftMap = null;

    public static HashMap<String, HashMap<String, Object>> getMeta(Context context) {
        if (metaMap == null) {
            DBMeta.reaDBMeta(context);
            return metaMap;
        }
        return metaMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMeta(Context context) throws Exception {
        String path = context.getFilesDir().getAbsolutePath() + File.separator + "orm.json";
        Gson gson = new Gson();
        String json = gson.toJson(metaMap);
        try (BufferedWriter bw = null;){
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path)));
            bw.write(json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reaDBMeta(Context context) {
        try {
            String path = context.getFilesDir().getAbsolutePath() + File.separator + "orm.json";
            File file = new File(path);
            if (!file.exists()) {
                return;
            }
            try (BufferedReader br = null;){
                String line;
                br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String json = "";
                while ((line = br.readLine()) != null) {
                    json = json + line;
                }
                DBMeta.str2Map(json);
            }
        }
        catch (Exception e) {
            LogUtil.d("DBMeta", "\u8bfborm\u914d\u7f6e\u5f02\u5e38\u3002");
        }
    }

    public static void str2Map(String lump) throws JSONException {
        metaMap = new HashMap();
        JSONObject jo = new JSONObject(lump);
        Iterator itr = jo.keys();
        while (itr.hasNext()) {
            HashMap<String, Object> map;
            String attr = (String)itr.next();
            if (attr.equals("_entityLiftMap_")) {
                map = new HashMap<String, Object>();
                metaMap.put(attr, map);
                entityLiftMap = new HashMap();
                JSONObject lift = jo.getJSONObject(attr);
                Iterator liftItr = lift.keys();
                while (liftItr.hasNext()) {
                    String key = (String)liftItr.next();
                    entityLiftMap.put(key, lift.getString(key));
                    map.put(key, lift.getString(key));
                }
                continue;
            }
            map = new HashMap();
            metaMap.put(attr, map);
            DBMeta.str2Map(map, jo.getJSONObject(attr));
        }
    }

    private static void str2Map(HashMap<String, Object> map, JSONObject jo) throws JSONException {
        Iterator itr = jo.keys();
        while (itr.hasNext()) {
            HashMap<String, Object> cols;
            String attr = (String)itr.next();
            if (attr.equals("entityName") || attr.equals("idName") || attr.equals("idColName") || attr.equals("idType") || attr.equals("verName") || attr.equals("verColName") || attr.equals("verType")) {
                map.put(attr, jo.getString(attr));
                continue;
            }
            if (attr.equals("idGenerator")) {
                String v = jo.getString(attr);
                if (v.equals("ID_SEQ")) {
                    map.put("idGenerator", "ID_AUTO");
                    continue;
                }
                map.put("idGenerator", v);
                continue;
            }
            if (attr.equals("sequence")) {
                map.put("sequence", jo.getString(attr));
                continue;
            }
            if (attr.equals("tableName")) {
                String tn = jo.getString(attr);
                if (tn.contains(".")) {
                    map.put(attr, tn.substring(tn.indexOf(46) + 1));
                    continue;
                }
                map.put(attr, jo.getString(attr));
                continue;
            }
            if (attr.equals("columns") || attr.equals("links") || attr.equals("onetoone") || attr.equals("onetomany") || attr.equals("associations") || attr.equals("inverseid") || attr.equals("subclasses")) {
                cols = new HashMap<String, Pair>();
                map.put(attr, cols);
                if (jo.isNull(attr)) continue;
                DBMeta.addPairs(cols, jo.getJSONObject(attr));
                continue;
            }
            if (!attr.equals("inverses")) continue;
            cols = new HashMap();
            map.put(attr, cols);
            if (jo.isNull(attr)) continue;
            DBMeta.addInverse(cols, jo.getJSONObject(attr));
        }
    }

    private static void addPairs(HashMap<String, Pair> map, JSONObject jo) throws JSONException {
        Iterator itr = jo.keys();
        while (itr.hasNext()) {
            Pair pair;
            String attr = (String)itr.next();
            if (jo.get(attr) instanceof JSONObject) {
                JSONObject p = jo.getJSONObject(attr);
                pair = new Pair(p.getString("col"), p.getString("type"));
                map.put(attr, pair);
                continue;
            }
            String[] v = jo.getString(attr).substring(1).split(":");
            pair = new Pair(v[0], v[1].substring(0, v[1].length() - 1));
            map.put(attr, pair);
        }
    }

    private static void addInverse(HashMap<String, String> map, JSONObject jo) throws JSONException {
        Iterator itr = jo.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            map.put(attr, jo.getString(attr));
        }
    }
}

