/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.utils;

import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteUtils {
    private static final Logger log = LoggerFactory.getLogger(ByteUtils.class);

    public static byte[] getBytes(short data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8)};
        return bytes;
    }

    public static byte[] getBytes(char data) {
        byte[] bytes = new byte[]{(byte)data, (byte)(data >> 8)};
        return bytes;
    }

    public static byte[] getBytes(int data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8), (byte)((data & 0xFF0000) >> 16), (byte)((data & 0xFF000000) >> 24)};
        return bytes;
    }

    public static byte[] getBytes(long data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
        return bytes;
    }

    public static byte[] getBytes(float data) {
        int intBits = Float.floatToIntBits(data);
        return ByteUtils.getBytes(intBits);
    }

    public static byte[] getBytes(double data) {
        long intBits = Double.doubleToLongBits(data);
        return ByteUtils.getBytes(intBits);
    }

    public static byte[] getBytes(String data, String charsetName) {
        Charset charset = Charset.forName(charsetName);
        return data.getBytes(charset);
    }

    public static byte[] getBytes(String data) {
        return ByteUtils.getBytes(data, "GBK");
    }

    public static short getShort(byte[] bytes) {
        return (short)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
    }

    public static char getChar(byte[] bytes) {
        return (char)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
    }

    public static int getInt(byte[] bytes) {
        return 0xFF & bytes[0] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[2] << 16 | 0xFF000000 & bytes[3] << 24;
    }

    public static long getLong(byte[] bytes) {
        return 0xFFL & (long)bytes[0] | 0xFF00L & (long)bytes[1] << 8 | 0xFF0000L & (long)bytes[2] << 16 | 0xFF000000L & (long)bytes[3] << 24 | 0xFF00000000L & (long)bytes[4] << 32 | 0xFF0000000000L & (long)bytes[5] << 40 | 0xFF000000000000L & (long)bytes[6] << 48 | 0xFF00000000000000L & (long)bytes[7] << 56;
    }

    public static float getFloat(byte[] bytes) {
        return Float.intBitsToFloat(ByteUtils.getInt(bytes));
    }

    public static double getDouble(byte[] bytes) {
        long l = ByteUtils.getLong(bytes);
        return Double.longBitsToDouble(l);
    }

    public static String getString(byte[] bytes, String charsetName) {
        return new String(bytes, Charset.forName(charsetName));
    }

    public static String getString(byte[] bytes) {
        return ByteUtils.getString(bytes, "GBK");
    }

    public static String bytesToHexStr(byte[] src) {
        return ByteUtils.bytesToHexStr(src, 0, src.length, false, null);
    }

    public static String bytesToHexStr(byte[] src, String separator) {
        return ByteUtils.bytesToHexStr(src, 0, src.length, false, separator);
    }

    public static String bytesToHexStr(byte[] src, boolean reverse) {
        return ByteUtils.bytesToHexStr(src, 0, src.length, reverse, null);
    }

    public static String bytesToHexStringReverse(byte[] src) {
        StringBuilder sb = new StringBuilder(ByteUtils.bytesToHexStr(src, 0, src.length, false, null));
        return sb.reverse().toString();
    }

    public static String bytesToHexStr(byte[] src, int index, int length, boolean reverse) {
        return ByteUtils.bytesToHexStr(src, index, length, reverse, null);
    }

    public static String bytesToHexStr(byte[] src, int index, int length, boolean reverse, String separator) {
        if (src == null || src.length < index + length) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (separator == null) {
            separator = "";
        }
        if (reverse) {
            for (int i = index + length - 1; i >= index; --i) {
                String hv = Integer.toHexString(src[i] & 0xFF);
                if (hv.length() < 2) {
                    sb.append("0");
                }
                sb.append(hv);
                sb.append(separator);
            }
        } else {
            for (int i = index; i < index + length; ++i) {
                String hv = Integer.toHexString(src[i] & 0xFF);
                if (hv.length() < 2) {
                    sb.append("0");
                }
                sb.append(hv);
                sb.append(separator);
            }
        }
        if (separator.length() > 0) {
            sb.delete(sb.lastIndexOf(separator), sb.length());
        }
        return sb.toString().toUpperCase();
    }

    public static String byteToHexStr(byte src) {
        String s = Integer.toHexString(0xFF & src);
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s.toUpperCase();
    }

    public static byte[] hexStrToBytes(String srcStr, boolean reverse) {
        if (srcStr == null || srcStr.equals("")) {
            return null;
        }
        String hexString = srcStr;
        if ((hexString = hexString.replace(" ", "").toUpperCase()).length() % 2 == 1) {
            log.error("HEX\u5b57\u7b26\u4e32\u957f\u5ea6\u5fc5\u987b\u4e3a\u5076\u6570\uff01");
            return null;
        }
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        if (reverse) {
            for (int i = 0; i < length; ++i) {
                int pos = (length - i) * 2;
                d[i] = (byte)(ByteUtils.charToByte(hexChars[pos - 2]) << 4 | ByteUtils.charToByte(hexChars[pos - 1]));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                int pos = i * 2;
                d[i] = (byte)(ByteUtils.charToByte(hexChars[pos]) << 4 | ByteUtils.charToByte(hexChars[pos + 1]));
            }
        }
        return d;
    }

    public static byte[] hexStrToBytes(String srcStr) {
        return ByteUtils.hexStrToBytes(srcStr, false);
    }

    public static byte hexStrToByte(String src) {
        if (src.length() > 2) {
            log.error("=========\u5b57\u7b26\u4e32\u957f\u5ea6\u9700\u5c0f\u4e8e2");
            return -1;
        }
        char[] hexChars = src.toCharArray();
        if (hexChars.length < 2) {
            return ByteUtils.charToByte(hexChars[0]);
        }
        return (byte)(ByteUtils.charToByte(hexChars[0]) << 4 | ByteUtils.charToByte(hexChars[1]));
    }

    public static boolean isBcdByte(byte bcd) {
        return (bcd & 0xF) <= 9 && (bcd & 0xF0) >> 4 <= 9;
    }

    public static boolean isBcdByte(int bcd) {
        return (bcd & 0xF) <= 9 && (bcd & 0xF0) >> 4 <= 9;
    }

    public static int bcdByteToInt(byte bcdByte) {
        if (ByteUtils.isBcdByte(bcdByte)) {
            return ((bcdByte & 0xF0) >> 4) * 10 + (bcdByte & 0xF);
        }
        throw new IllegalArgumentException("\u975e\u6cd5BCD\u5b57\u7b26:" + ByteUtils.byteToHexStr(bcdByte));
    }

    public static int bcdBytesToInt(byte[] bcdBytes, boolean reverse) {
        return ByteUtils.bcdBytesToInt(bcdBytes, 0, bcdBytes.length, reverse);
    }

    public static int bcdBytesToInt(byte[] bcdBytes, int index, int length, boolean reverse) {
        int value = 0;
        if (reverse) {
            for (int i = length - 1; i >= 0; --i) {
                value = value * 100 + ByteUtils.bcdByteToInt(bcdBytes[index + i]);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                value = value * 100 + ByteUtils.bcdByteToInt(bcdBytes[index + i]);
            }
        }
        return value;
    }

    public static byte intToBcdByte(int bcdInt) {
        if (bcdInt <= 99) {
            return (byte)(bcdInt / 10 * 16 + bcdInt % 10);
        }
        throw new IllegalArgumentException("\u8d85\u8fc7\u5355\u5b57\u8282BCD\u7801\u8868\u793a\u4e0a\u9650:" + bcdInt);
    }

    public static byte[] intToBcdBytes(long value, int length, boolean reverse) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            if (reverse) {
                bytes[i] = ByteUtils.intToBcdByte((int)(value % 100L));
            } else {
                bytes[length - 1 - i] = ByteUtils.intToBcdByte((int)(value % 100L));
            }
            value /= 100L;
        }
        return bytes;
    }

    public static Date bcdToDate(byte[] bcdArray, String format, int beginPosition) {
        int ssindex;
        int miindex;
        int hhindex;
        int ddindex;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        String uformat = format.toUpperCase();
        int yyyyidx = uformat.indexOf("YYYY");
        if (yyyyidx != -1) {
            calendar.set(1, ByteUtils.bcdBytesToInt(bcdArray, beginPosition + yyyyidx / 2, 2, true));
        } else {
            int yyindex = uformat.indexOf("YY");
            if (yyindex != -1) {
                calendar.set(1, calendar.get(1) / 100 * 100 + ByteUtils.bcdByteToInt(bcdArray[beginPosition + yyindex / 2]));
            }
        }
        int mmindex = uformat.indexOf("MM");
        if (mmindex != -1) {
            calendar.set(2, ByteUtils.bcdByteToInt(bcdArray[beginPosition + mmindex / 2]) - 1);
        }
        if ((ddindex = uformat.indexOf("DD")) != -1) {
            calendar.set(5, ByteUtils.bcdByteToInt(bcdArray[beginPosition + ddindex / 2]));
        }
        if ((hhindex = uformat.indexOf("HH")) != -1) {
            calendar.set(11, ByteUtils.bcdByteToInt(bcdArray[beginPosition + hhindex / 2]));
        }
        if ((miindex = uformat.indexOf("MI")) != -1) {
            calendar.set(12, ByteUtils.bcdByteToInt(bcdArray[beginPosition + miindex / 2]));
        }
        if ((ssindex = uformat.indexOf("SS")) != -1) {
            calendar.set(13, ByteUtils.bcdByteToInt(bcdArray[beginPosition + ssindex / 2]));
        }
        return calendar.getTime();
    }

    public static byte[] dateToBcd(Date date, String format) {
        int ssindex;
        int miindex;
        int hhindex;
        int ddindex;
        byte[] result = new byte[format.length() / 2];
        String uformat = format.toUpperCase();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int yyyyidx = uformat.indexOf("YYYY");
        if (yyyyidx != -1) {
            byte[] years = ByteUtils.intToBcdBytes(calendar.get(1), 2, false);
            result[yyyyidx / 2] = years[0];
            result[yyyyidx / 2 + 1] = years[1];
        } else {
            int yyindex = uformat.indexOf("YY");
            if (yyindex != -1) {
                result[yyindex / 2] = ByteUtils.intToBcdByte((byte)(calendar.get(1) % 100));
            }
        }
        int mmindex = uformat.indexOf("MM");
        if (mmindex != -1) {
            result[mmindex / 2] = ByteUtils.intToBcdByte((byte)(calendar.get(2) + 1));
        }
        if ((ddindex = uformat.indexOf("DD")) != -1) {
            result[ddindex / 2] = ByteUtils.intToBcdByte((byte)calendar.get(5));
        }
        if ((hhindex = uformat.indexOf("HH")) != -1) {
            result[hhindex / 2] = ByteUtils.intToBcdByte((byte)calendar.get(11));
        }
        if ((miindex = uformat.indexOf("MI")) != -1) {
            result[miindex / 2] = ByteUtils.intToBcdByte((byte)calendar.get(12));
        }
        if ((ssindex = uformat.indexOf("SS")) != -1) {
            result[ssindex / 2] = ByteUtils.intToBcdByte((byte)calendar.get(13));
        }
        return result;
    }

    public static int bitSetOfByte(byte b) {
        if (b == 1) {
            return 1;
        }
        if (b == 2) {
            return 2;
        }
        if (b == 4) {
            return 3;
        }
        if (b == 8) {
            return 4;
        }
        if (b == 16) {
            return 5;
        }
        if (b == 32) {
            return 6;
        }
        if (b == 64) {
            return 7;
        }
        if (b == -128) {
            return 8;
        }
        throw new IllegalArgumentException();
    }

    public static byte[] bitSetStringToBytes(String src, boolean lowbitBefore) {
        String bitStr = src.replaceAll(" ", "");
        if (lowbitBefore) {
            bitStr = new StringBuilder(bitStr).reverse().toString();
        }
        int strLen = bitStr.length();
        int len = strLen / 8 + (strLen % 8 > 0 ? 1 : 0);
        return ByteUtils.intToBytes(Integer.parseInt(bitStr, 2), len, false);
    }

    public static String bytesToBitSetString(byte[] bytes, boolean lowBitBefore) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            for (int j = 0; j < 8; ++j) {
                if ((b & 1 << 7 - j) == 1 << 7 - j) {
                    sb.append('1');
                    continue;
                }
                sb.append('0');
            }
        }
        if (lowBitBefore) {
            sb.reverse();
        }
        return sb.toString();
    }

    public static String bytesToBitSetString(byte[] bytes, int bytePos, int bitPos, int bitLen, boolean lowBitBefor) {
        StringBuilder sb = new StringBuilder();
        String zeroStr = "00000000";
        String rs = "";
        int bitEnd = bitPos + bitLen;
        int byteLen = bitEnd / 8 + (bitEnd % 8 > 0 ? 1 : 0);
        for (int i = bytePos; i < bytePos + byteLen; ++i) {
            String bitStr = Integer.toBinaryString(bytes[i] & 0xFF);
            if (bitStr.length() < 8) {
                sb.append(zeroStr.substring(bitStr.length()));
            }
            sb.append(bitStr);
        }
        rs = sb.substring(bitPos, bitPos + bitLen);
        if (lowBitBefor) {
            rs = new StringBuilder(rs).reverse().toString();
        }
        return rs;
    }

    public static String byteToBitSetStr(byte b, boolean lowBitBefore) {
        StringBuilder sb = new StringBuilder();
        String result = "";
        for (int j = 7; j >= 0; --j) {
            if ((b & 1 << j) == 1 << j) {
                sb.append("1");
                continue;
            }
            sb.append("0");
        }
        result = lowBitBefore ? sb.reverse().toString() : sb.toString();
        return result;
    }

    public static String byteToBitSetStr(byte objByte, int beginIndex, int length, boolean lowBitBefore) {
        StringBuilder sb = new StringBuilder();
        String result = "";
        if (lowBitBefore) {
            for (int j = 0; j < 8; ++j) {
                if ((objByte & 1 << j) == 1 << j) {
                    sb.append("1");
                    continue;
                }
                sb.append("0");
            }
            result = sb.toString();
        } else {
            for (int j = 0; j < 8; ++j) {
                if ((objByte & 1 << j) == 1 << j) {
                    sb.append("1");
                    continue;
                }
                sb.append("0");
            }
            result = sb.reverse().toString();
        }
        return result.substring(beginIndex, beginIndex + length);
    }

    public static String intToBitSetStr(int intValue, int bitLen, boolean lowBitBefore) {
        String bitStr = "0000000000000000000000000000000" + Integer.toBinaryString(intValue);
        bitStr = bitStr.substring(bitStr.length() - bitLen);
        if (lowBitBefore) {
            bitStr = new StringBuilder(bitStr).reverse().toString();
        }
        return bitStr;
    }

    public static byte BitSetStrToByte(String bitSetStr) {
        byte result = 0;
        if (bitSetStr.length() <= 8) {
            int i = 0;
            int j = bitSetStr.length() - 1;
            while (i <= bitSetStr.length() - 1) {
                result = (byte)((double)result + (double)Byte.parseByte(bitSetStr.charAt(i) + "") * Math.pow(2.0, j));
                ++i;
                --j;
            }
            return result;
        }
        return -1;
    }

    public static String BitSetStrToByteStr(String bitSetStr) {
        return String.format("%d", ByteUtils.BitSetStrToByte(bitSetStr));
    }

    public static byte[] IPStringToBytes(String ipString) {
        String[] strs = ipString.split("[.]");
        byte[] b = new byte[strs.length];
        int index = 0;
        for (String str : strs) {
            b[index++] = (byte)Integer.parseInt(str);
        }
        return b;
    }

    public static byte[] IpPortStringToBytes(String ipportString) {
        String[] strs = ipportString.substring(0, ipportString.indexOf(":")).split("[.]");
        byte[] b = new byte[strs.length + 2];
        int index = 0;
        for (String str : strs) {
            b[index++] = (byte)Integer.parseInt(str);
        }
        String[] port = ipportString.split("[:]");
        b[index++] = (byte)(Integer.parseInt(port[1] + 128) & 0xFF);
        b[index++] = (byte)((Integer.parseInt(port[1] + 128) & 0xFF00) >> 8);
        return b;
    }

    public static byte[] TelStringToBytes(String telString) {
        String StrValue = telString.replace(",", "A");
        if ((StrValue = StrValue.replace("#", "B")).length() > 16) {
            StrValue = StrValue.substring(0, 15);
        } else if (StrValue.length() < 16) {
            StrValue = StrValue + ByteUtils.dupeString("F", 16 - StrValue.length());
        }
        return ByteUtils.hexStrToBytes(StrValue, false);
    }

    public static String bytesToTelString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int valueLower = 0;
        for (int i = 0; i <= bytes.length - 1; ++i) {
            int valueHigh = (bytes[i] & 0xF0) >> 4;
            valueLower = bytes[i] & 0xF;
            if (valueHigh < 10) {
                sb.append(valueHigh);
            } else if (valueHigh == 10) {
                sb.append(",");
            } else if (valueHigh == 11) {
                sb.append("#");
            }
            if (valueLower < 10) {
                sb.append(valueLower);
                continue;
            }
            if (valueLower == 10) {
                sb.append(",");
                continue;
            }
            if (valueLower != 11) continue;
            sb.append("#");
        }
        return sb.toString();
    }

    public static String bytesToIpPortString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int Ip = 0;
            Ip = bytes[i] < 0 ? bytes[i] + 256 : bytes[i];
            sb.append(String.valueOf(Ip));
            if (i < 3) {
                sb.append(".");
                continue;
            }
            sb.append(":");
        }
        int portHigh = bytes[5] >= 0 ? bytes[5] : bytes[5] + 256;
        int portLow = bytes[4] >= 0 ? bytes[4] : bytes[4] + 256;
        int port = portHigh * 256 + portLow;
        sb.append(String.valueOf(port));
        return sb.toString();
    }

    public static String bytesToIpString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int Ip = 0;
            Ip = bytes[i] < 0 ? bytes[i] + 256 : bytes[i];
            sb.append(String.valueOf(Ip));
            if (i < 3) {
                sb.append(".");
                continue;
            }
            sb.append("");
        }
        return sb.toString();
    }

    public static String IntToBitSetString(int value, int bitCnt, boolean lowbitBefore) {
        StringBuilder sb = new StringBuilder();
        String result = "0";
        if (value > 0) {
            while (value > 0) {
                sb.append(value % 2);
                value >>= 1;
            }
            result = !lowbitBefore ? sb.reverse().toString() : sb.toString();
        }
        int len = result.length();
        if (result.length() < bitCnt) {
            for (int i = 0; i < bitCnt - len; ++i) {
                result = "0" + result;
            }
        }
        return result;
    }

    public static char byteToChar(int b) {
        char ch = b < 10 ? (char)(48 + b) : (char)(65 + b - 10);
        return ch;
    }

    public static byte charToByte(char ch) {
        return ch >= '0' && ch <= '9' ? (byte)(ch - 48) : (byte)(Character.toUpperCase(ch) - 65 + 10);
    }

    public static boolean isHexChar(char ch) {
        return ch >= '0' && ch <= '9' || Character.toUpperCase(ch) >= 'A' && Character.toUpperCase(ch) <= 'F';
    }

    public static byte[] reverseBytes(byte[] bytes) {
        int len = bytes.length;
        byte[] reverseBytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            reverseBytes[i] = bytes[len - i - 1];
        }
        return reverseBytes;
    }

    public static String dupeString(String str, int repeats) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < repeats; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static int byteToUnsigned(byte b) {
        return (256 + b) % 256;
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat sDateFormat = new SimpleDateFormat(format);
        return sDateFormat.format(date);
    }

    public static byte[] longToByteArray(long s, int bytes, boolean lowByteBefore) {
        byte[] targets = new byte[bytes];
        for (int i = 0; i < bytes; ++i) {
            int offset;
            if (lowByteBefore) {
                offset = i * 8;
                targets[i] = (byte)(s >>> offset & 0xFFL);
                continue;
            }
            offset = (targets.length - 1 - i) * 8;
            targets[i] = (byte)(s >>> offset & 0xFFL);
        }
        return targets;
    }

    public static long BytesToLong(byte[] buf, int pos, boolean lowByteBefore) {
        long value = 0L;
        for (int i = 0; i < buf.length; ++i) {
            if (lowByteBefore) {
                value |= (long)((buf[buf.length - 1 - i] & 0xFF) << (buf.length - 1 - i) * 8);
                continue;
            }
            value |= (long)((buf[i] & 0xFF) << i * 8);
        }
        return value;
    }

    public static void putFloat(byte[] bb, float x, int index, boolean lowByteBefore) {
        int l = Float.floatToIntBits(x);
        if (lowByteBefore) {
            for (int i = 0; i < 4; ++i) {
                bb[index + i] = new Integer(l).byteValue();
                l >>= 8;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                bb[3 - index - i] = new Integer(l).byteValue();
                l >>= 8;
            }
        }
    }

    public static float getFloat(byte[] b, int index, boolean lowByteBefore) {
        int l;
        if (lowByteBefore) {
            l = b[index + 0];
            l &= 0xFF;
            l = (int)((long)l | (long)b[index + 1] << 8);
            l &= 0xFFFF;
            l = (int)((long)l | (long)b[index + 2] << 16);
            l &= 0xFFFFFF;
            l = (int)((long)l | (long)b[index + 3] << 24);
        } else {
            l = b[index + 3];
            l &= 0xFF;
            l = (int)((long)l | (long)b[index + 2] << 8);
            l &= 0xFFFF;
            l = (int)((long)l | (long)b[index + 1] << 16);
            l &= 0xFFFFFF;
            l = (int)((long)l | (long)b[index + 0] << 24);
        }
        return Float.intBitsToFloat(l);
    }

    public static byte[] copyBytes(byte[] src, int begin, int len) {
        byte[] b = new byte[len];
        System.arraycopy(src, begin, b, 0, len);
        return b;
    }

    public static byte[] concatBytes(byte[] first, byte[] ... rest) {
        int totalLength = first.length;
        for (byte[] array : rest) {
            totalLength += array.length;
        }
        byte[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (byte[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static byte[] pasteBytes(byte[] target, int tIndex, byte[] src, int sIndex, int length) {
        System.arraycopy(src, sIndex, target, tIndex, length);
        return target;
    }

    public static byte[] dateToBytes(Date date, String format) {
        int ssindex;
        int miindex;
        int hhindex;
        int ddindex;
        byte[] result = new byte[format.length() / 2];
        String uformat = format.toUpperCase();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int yyyyidx = uformat.indexOf("YYYY");
        if (yyyyidx != -1) {
            int years = calendar.get(1);
            result[0] = (byte)(years >> 8);
            result[1] = (byte)(years & 0xFF);
        } else {
            int yyindex = uformat.indexOf("YY");
            if (yyindex != -1) {
                int years = calendar.get(1) % 100;
                result[0] = (byte)(years & 0xFF);
            }
        }
        int mmindex = uformat.indexOf("MM");
        if (mmindex != -1) {
            result[mmindex / 2] = (byte)(calendar.get(2) + 1 & 0xFF);
        }
        if ((ddindex = uformat.indexOf("DD")) != -1) {
            result[ddindex / 2] = (byte)(calendar.get(5) & 0xFF);
        }
        if ((hhindex = uformat.indexOf("HH")) != -1) {
            result[hhindex / 2] = (byte)(calendar.get(11) & 0xFF);
        }
        if ((miindex = uformat.indexOf("MI")) != -1) {
            result[miindex / 2] = (byte)(calendar.get(12) & 0xFF);
        }
        if ((ssindex = uformat.indexOf("SS")) != -1) {
            result[ssindex / 2] = (byte)(calendar.get(13) & 0xFF);
        }
        return result;
    }

    public static String bytesToDateStr(byte[] value, String format, int beginPosition) {
        try {
            int ssindex;
            int miindex;
            int hhindex;
            int ddindex;
            String date = "";
            int yyyyidx = format.indexOf("YYYY");
            if (yyyyidx != -1) {
                date = (value[beginPosition + yyyyidx / 2] << 8 | value[beginPosition + yyyyidx / 2 + 1] & 0xFF) + "";
            } else {
                int yyindex = format.indexOf("YY");
                if (yyindex != -1) {
                    date = (value[beginPosition + yyindex / 2] & 0xFF) + "";
                }
            }
            int mmindex = format.indexOf("MM");
            if (mmindex != -1) {
                date = date + "-" + (value[beginPosition + mmindex / 2] & 0xFF);
            }
            if ((ddindex = format.indexOf("DD")) != -1) {
                date = date + "-" + (value[beginPosition + ddindex / 2] & 0xFF);
            }
            if ((hhindex = format.indexOf("HH")) != -1) {
                date = date + " " + (value[beginPosition + hhindex / 2] & 0xFF);
            }
            if ((miindex = format.indexOf("MI")) != -1) {
                date = date + ":" + (value[beginPosition + miindex / 2] & 0xFF);
            }
            if ((ssindex = format.indexOf("SS")) != -1) {
                date = date + ":" + (value[beginPosition + ssindex / 2] & 0xFF);
            }
            return date;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return null;
        }
    }

    public static long bytesToInt(byte[] b, int index, int length, boolean lowByteBefore) {
        long result = 0L;
        if (length > 8) {
            length = 8;
        }
        if (lowByteBefore) {
            for (int i = index + length - 1; i >= index; --i) {
                result <<= 8;
                result |= (long)(b[i] & 0xFF);
            }
        } else {
            for (int i = index; i < index + length; ++i) {
                result <<= 8;
                result |= (long)(b[i] & 0xFF);
            }
        }
        return result;
    }

    public static byte[] intToBytes(long iSource, int iArrayLen, boolean lowByteBefore) {
        byte[] bLocalArr = new byte[iArrayLen];
        if (lowByteBefore) {
            for (int i = 0; i < 8 && i < iArrayLen; ++i) {
                bLocalArr[i] = (byte)(iSource >> 8 * i & 0xFFL);
            }
        } else {
            for (int i = 0; i < 8 && i < iArrayLen; ++i) {
                bLocalArr[iArrayLen - i - 1] = (byte)(iSource >> 8 * i & 0xFFL);
            }
        }
        return bLocalArr;
    }

    public static void main(String[] args) {
        byte[] bytes = new byte[]{1, -86};
        System.out.println(ByteUtils.bytesToHexStr(bytes, 0, 2, true));
    }
}

