/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.utils;

import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtil {
    private static final Logger log = LoggerFactory.getLogger(AESUtil.class);

    public static byte[] concatArrays(byte[] first, byte[] second) {
        byte[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        String hex = hexStr.trim().replaceAll(" ", "");
        if (hex.length() < 1) {
            return null;
        }
        byte[] result = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length() / 2; ++i) {
            int high = Integer.parseInt(hex.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hex.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String parseByte2HexStr(byte[] buf, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase() + separator);
        }
        return sb.toString();
    }

    public static byte[] encrypt(String content, String password) {
        try {
            log.info("\u52a0\u5bc6\u524d\u5185\u5bb9\uff1a" + content);
            String thisPassword = (password + "00000000000000000000000000000000").substring(0, 32);
            SecretKeySpec key = new SecretKeySpec(AESUtil.parseHexStr2Byte(thisPassword), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            byte[] byteContent = AESUtil.parseHexStr2Byte(content);
            int len = byteContent.length;
            int zeroNum = 16 - len % 16;
            byte[] zero = new byte[zeroNum];
            if (zeroNum > 0) {
                zero[0] = -128;
            }
            ArrayList<byte[]> srcArrays = new ArrayList<byte[]>();
            srcArrays.add(byteContent);
            srcArrays.add(zero);
            byte[] thisContent = AESUtil.concatArrays(byteContent, zero);
            cipher.init(1, key);
            byte[] result = cipher.doFinal(thisContent);
            log.info("\u52a0\u5bc6\u540e\u5185\u5bb9\uff1a" + AESUtil.parseByte2HexStr(result));
            return result;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return null;
        }
    }

    public static byte[] encrypt(byte[] byteContent, String password) {
        try {
            log.info("\u52a0\u5bc6\u524d\u5185\u5bb9\uff1a" + AESUtil.parseByte2HexStr(byteContent));
            String thisPassword = (password + "00000000000000000000000000000000").substring(0, 32);
            SecretKeySpec key = new SecretKeySpec(AESUtil.parseHexStr2Byte(thisPassword), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            int len = byteContent.length;
            int zeroNum = 16 - len % 16;
            byte[] zero = new byte[zeroNum];
            if (zeroNum > 0) {
                zero[0] = -128;
            }
            ArrayList<byte[]> srcArrays = new ArrayList<byte[]>();
            srcArrays.add(byteContent);
            srcArrays.add(zero);
            byte[] thisContent = AESUtil.concatArrays(byteContent, zero);
            cipher.init(1, key);
            byte[] result = cipher.doFinal(thisContent);
            log.info("\u52a0\u5bc6\u540e\u5185\u5bb9\uff1a" + AESUtil.parseByte2HexStr(result));
            return result;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return null;
        }
    }

    public static byte[] encrypt_2(byte[] byteContent, String password) {
        try {
            log.info("\u52a0\u5bc6\u524d\u5185\u5bb9\uff1a" + AESUtil.parseByte2HexStr(byteContent));
            String thisPassword = (password + "00000000000000000000000000000000").substring(0, 32);
            SecretKeySpec key = new SecretKeySpec(AESUtil.parseHexStr2Byte(thisPassword), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            int len = byteContent.length;
            int zeroNum = 16 - len % 16;
            byte[] thisContent = null;
            if (zeroNum == 16) {
                thisContent = byteContent;
            } else {
                byte[] zero = new byte[zeroNum];
                ArrayList<byte[]> srcArrays = new ArrayList<byte[]>();
                srcArrays.add(byteContent);
                srcArrays.add(zero);
                thisContent = AESUtil.concatArrays(byteContent, zero);
            }
            cipher.init(1, key);
            byte[] result = cipher.doFinal(thisContent);
            log.info("\u52a0\u5bc6\u540e\u5185\u5bb9\uff1a" + AESUtil.parseByte2HexStr(result));
            return result;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return null;
        }
    }

    public static byte[] encryptPKCS7(byte[] byteContent, String password) {
        try {
            log.info("\u52a0\u5bc6\u524d\u5185\u5bb9\uff1a" + AESUtil.parseByte2HexStr(byteContent));
            String thisPassword = (password + "00000000000000000000000000000000").substring(0, 32);
            SecretKeySpec key = new SecretKeySpec(AESUtil.parseHexStr2Byte(thisPassword), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            int len = byteContent.length;
            int num = 16 - len % 16;
            byte[] numArr = new byte[num];
            for (int i = 0; i < numArr.length; ++i) {
                numArr[i] = (byte)num;
            }
            byte[] thisContent = AESUtil.concatArrays(byteContent, numArr);
            cipher.init(1, key);
            byte[] result = cipher.doFinal(thisContent);
            log.info("\u52a0\u5bc6\u540e\u5185\u5bb9\uff1a" + AESUtil.parseByte2HexStr(result));
            return result;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return null;
        }
    }

    public static byte[] encryptPKCS7_2(byte[] byteContent, String password) {
        try {
            log.info("\u52a0\u5bc6\u524d\u5185\u5bb9\uff1a" + AESUtil.parseByte2HexStr(byteContent));
            String thisPassword = (password + "00000000000000000000000000000000").substring(0, 32);
            SecretKeySpec key = new SecretKeySpec(AESUtil.parseHexStr2Byte(thisPassword), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            int len = byteContent.length;
            int num = 16 - len % 16;
            if (num == 16) {
                num = 0;
            }
            byte[] numArr = new byte[num];
            for (int i = 0; i < numArr.length; ++i) {
                numArr[i] = (byte)num;
            }
            byte[] thisContent = AESUtil.concatArrays(byteContent, numArr);
            cipher.init(1, key);
            byte[] result = cipher.doFinal(thisContent);
            log.info("\u52a0\u5bc6\u540e\u5185\u5bb9\uff1a" + AESUtil.parseByte2HexStr(result));
            return result;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return null;
        }
    }

    public static byte[] decrypt(byte[] content, String password) {
        try {
            log.info("\u89e3\u5bc6\u524d\u6570\u636e\uff1a" + AESUtil.parseByte2HexStr(content));
            log.info("\u5bc6\u94a5\uff1a" + password);
            String thisPassword = (password + "00000000000000000000000000000000").substring(0, 32);
            SecretKeySpec key = new SecretKeySpec(AESUtil.parseHexStr2Byte(thisPassword), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(2, key);
            byte[] result = cipher.doFinal(content);
            log.info("\u89e3\u5bc6\u540e\u6570\u636e\uff1a" + AESUtil.parseByte2HexStr(result, " "));
            return result;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return null;
        }
    }

    public static byte[] decrypt2(byte[] content, String password) {
        try {
            log.info("\u89e3\u5bc6\u524d\u6570\u636e\uff1a" + AESUtil.parseByte2HexStr(content));
            log.info("\u5bc6\u94a5\uff1a" + password);
            String thisPassword = (password + "00000000000000000000000000000000").substring(0, 32);
            SecretKeySpec key = new SecretKeySpec(AESUtil.parseHexStr2Byte(thisPassword), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, key);
            byte[] result = cipher.doFinal(content);
            log.info("\u89e3\u5bc6\u540e\u6570\u636e\uff1a" + AESUtil.parseByte2HexStr(result, " "));
            return result;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String content = "4F FA E2 11 95 EB 05 8A 18 B9 56 15 53 B5 2C B5".replaceAll(" ", "");
        String password = "0102030405060708";
        byte[] decryptFrom = AESUtil.parseHexStr2Byte(content);
        byte[] decryptResult = AESUtil.decrypt(decryptFrom, password);
    }
}

