/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine.datatype;

import com.viewshine.codec.engine.datatype.DataType;
import com.viewshine.codec.utils.ByteUtils;
import com.viewshine.codec.utils.StringUtils;

public class DataTypeIP
extends DataType {
    private boolean isNull = true;
    private String value;
    private boolean lowByteBefore = false;

    @Override
    public void setParams(String params) {
        if (StringUtils.isEmpty(params)) {
            return;
        }
        if (!"0".equals(params)) {
            this.lowByteBefore = true;
        }
    }

    @Override
    public void setBytes(byte[] src, int pos) {
        if (src != null && src.length > 0) {
            StringBuilder sb = new StringBuilder();
            if (this.lowByteBefore) {
                sb.append(src[pos + 3] & 0xFF);
                sb.append(".");
                sb.append(src[pos + 2] & 0xFF);
                sb.append(".");
                sb.append(src[pos + 1] & 0xFF);
                sb.append(".");
                sb.append(src[pos] & 0xFF);
            } else {
                sb.append(src[pos] & 0xFF);
                sb.append(".");
                sb.append(src[pos + 1] & 0xFF);
                sb.append(".");
                sb.append(src[pos + 2] & 0xFF);
                sb.append(".");
                sb.append(src[pos + 3] & 0xFF);
            }
            this.value = sb.toString();
            this.isNull = false;
        }
    }

    @Override
    public byte[] getBytes() {
        if (!this.isNull) {
            byte[] bytes = new byte[4];
            String[] ss = this.value.split("\\.");
            if (this.lowByteBefore) {
                bytes[0] = (byte)Integer.parseInt(ss[3]);
                bytes[1] = (byte)Integer.parseInt(ss[2]);
                bytes[2] = (byte)Integer.parseInt(ss[1]);
                bytes[3] = (byte)Integer.parseInt(ss[0]);
            } else {
                bytes[0] = (byte)Integer.parseInt(ss[0]);
                bytes[1] = (byte)Integer.parseInt(ss[1]);
                bytes[2] = (byte)Integer.parseInt(ss[2]);
                bytes[3] = (byte)Integer.parseInt(ss[3]);
            }
            return bytes;
        }
        return null;
    }

    @Override
    public String toHexString() {
        if (!this.isNull) {
            return ByteUtils.bytesToHexStr(this.getBytes(), " ");
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.isNull = false;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static void main(String[] args) {
        DataTypeIP dt = new DataTypeIP();
        dt.setLength(4);
        dt.setParams("1");
        dt.setValue("115.236.33.164");
        byte[] bytes = dt.getBytes();
        System.out.println(dt.getValue() + "~~" + dt.toHexString());
        DataTypeIP dt1 = new DataTypeIP();
        dt1.setLength(4);
        dt1.setParams("1");
        dt1.setBytes(bytes);
        System.out.println(dt1.getValue() + "~~" + dt1.toHexString());
    }
}

