/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine.datatype;

import com.viewshine.codec.engine.datatype.DataType;
import com.viewshine.codec.utils.ByteUtils;
import com.viewshine.codec.utils.StringUtils;

public class DataTypeIEEE754
extends DataType {
    private float value;
    private boolean lowByteBefore = false;

    @Override
    public void setParams(String params) {
        if (StringUtils.isEmpty(params)) {
            return;
        }
        String[] items = params.split(",");
        if (items.length > 0) {
            this.lowByteBefore = !"0".equals(items[0]);
        }
    }

    @Override
    public void setBytes(byte[] src, int pos) {
        for (int i = pos; i < pos + this.length && src[i] == -1; ++i) {
            if (i != pos + this.length - 1) continue;
            return;
        }
        int intValue = (int)ByteUtils.bytesToInt(src, pos, this.length, this.lowByteBefore);
        this.value = Float.intBitsToFloat(intValue);
        this.isNull = false;
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull) {
            return null;
        }
        int intValue = Float.floatToIntBits(this.value);
        return ByteUtils.intToBytes(intValue, this.length, this.lowByteBefore);
    }

    @Override
    public String toHexString() {
        byte[] bytes = this.getBytes();
        return ByteUtils.bytesToHexStr(bytes, 0, bytes.length, false, " ");
    }

    @Override
    public void setValue(String value) {
        if (!StringUtils.isEmpty(value)) {
            this.value = Float.parseFloat(value);
            this.isNull = false;
        }
    }

    @Override
    public String getValue() {
        if (this.isNull) {
            return null;
        }
        return String.valueOf(this.value);
    }

    public static void main(String[] args) {
        DataTypeIEEE754 dt = new DataTypeIEEE754();
        dt.setLength(4);
        dt.setParams("0");
        dt.setValue("15.0");
        byte[] bytes = dt.getBytes();
        System.out.println(dt.getValue() + "~~" + dt.toHexString());
        DataTypeIEEE754 dt1 = new DataTypeIEEE754();
        dt1.setLength(4);
        dt1.setParams("0");
        dt1.setBytes(bytes);
        System.out.println(dt1.getValue() + "~~" + dt1.toHexString());
    }
}

