/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine.datatype;

import com.viewshine.codec.engine.datatype.DataType;
import com.viewshine.codec.utils.ByteUtils;

public class DataTypeHEX_STR
extends DataType {
    private boolean isNull = true;
    private String value;
    private boolean lowByteBefore = false;

    @Override
    public void setParams(String params) {
        if (!"0".equals(params)) {
            this.lowByteBefore = true;
        }
    }

    @Override
    public void setBytes(byte[] src, int pos) {
        if (src != null && src.length > 0) {
            this.value = ByteUtils.bytesToHexStr(src, pos, this.length, this.lowByteBefore, null);
            this.isNull = false;
        }
    }

    @Override
    public byte[] getBytes() {
        if (!this.isNull) {
            return ByteUtils.hexStrToBytes(this.value, this.lowByteBefore);
        }
        return null;
    }

    @Override
    public String toHexString() {
        if (!this.isNull) {
            return ByteUtils.bytesToHexStr(this.getBytes(), " ");
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        int k = this.length * 2 - this.value.length();
        if (k > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.value);
            for (int i = 0; i < k; ++i) {
                sb.append("0");
            }
            this.value = sb.toString();
        } else if (k < 0) {
            this.value = this.value.substring(0, this.length * 2);
        }
        this.isNull = false;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static void main(String[] args) {
        DataTypeHEX_STR dt = new DataTypeHEX_STR();
        dt.setLength(10);
        dt.setValue("DFCE12346");
        byte[] bytes = dt.getBytes();
        System.out.println(dt.getValue() + "~~" + dt.toHexString());
        DataTypeHEX_STR dt1 = new DataTypeHEX_STR();
        dt1.setLength(10);
        dt1.setBytes(bytes);
        System.out.println(dt1.getValue() + "~~" + dt1.toHexString());
    }
}

