/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine.datatype;

import com.viewshine.codec.engine.datatype.DataType;
import com.viewshine.codec.utils.ByteUtils;
import com.viewshine.codec.utils.StringUtils;
import java.math.BigDecimal;

public class DataTypeHEX
extends DataType {
    private long value;
    private int decimalLen;
    private boolean lowByteBefore = true;
    private boolean signed = false;

    @Override
    public void setLength(int length) {
        this.length = length;
        if (this.length > 8) {
            this.length = 8;
        }
    }

    @Override
    public void setParams(String params) {
        if (StringUtils.isEmpty(params)) {
            return;
        }
        String[] items = params.split(",");
        if (items.length > 0) {
            this.decimalLen = Integer.parseInt(items[0]);
            if (items.length > 1) {
                boolean bl = this.lowByteBefore = !"0".equals(items[1]);
                if (items.length > 2) {
                    this.signed = !"0".equals(items[2]);
                }
            }
        }
    }

    @Override
    public void setBytes(byte[] src, int pos) {
        int i;
        int index = pos;
        byte[] b = new byte[8];
        int k = b.length - 1;
        if (this.lowByteBefore) {
            for (i = index; i < index + this.length; ++i) {
                b[k] = src[i];
                --k;
            }
        } else {
            for (i = index + this.length - 1; i >= index; --i) {
                b[k] = src[i];
                --k;
            }
        }
        if (this.signed && (b[b.length - this.length] & 0x80) == 128) {
            for (int j = 0; j < b.length - this.length; ++j) {
                b[j] = -1;
            }
        }
        for (int l = 0; l < b.length; ++l) {
            this.value <<= 8;
            this.value |= (long)(b[l] & 0xFF);
        }
        this.isNull = false;
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull) {
            return null;
        }
        byte[] bytes = new byte[this.length];
        if (this.lowByteBefore) {
            for (int i = 0; i < this.length; ++i) {
                bytes[i] = (byte)(this.value >> 8 * i & 0xFFL);
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                bytes[this.length - i - 1] = (byte)(this.value >> 8 * i & 0xFFL);
            }
        }
        return bytes;
    }

    @Override
    public String toHexString() {
        byte[] bytes = this.getBytes();
        return ByteUtils.bytesToHexStr(bytes, 0, bytes.length, false, " ");
    }

    @Override
    public void setValue(String value) {
        this.value = Math.round(Double.parseDouble(value) * Math.pow(10.0, this.decimalLen));
        this.isNull = false;
    }

    @Override
    public String getValue() {
        if (this.isNull) {
            return null;
        }
        String rs = this.value + "";
        if (this.decimalLen > 0) {
            double d = Math.pow(10.0, this.decimalLen);
            double d1 = new BigDecimal((double)this.value / d).setScale(this.decimalLen, 4).doubleValue();
            rs = d1 + "";
        }
        return rs;
    }

    public static void main(String[] args) {
        DataTypeHEX dt = new DataTypeHEX();
        dt.setLength(4);
        dt.setParams("2,0");
        dt.setValue("128.95");
        byte[] bytes = dt.getBytes();
        System.out.println(dt.getValue() + "~~" + dt.toHexString());
        DataTypeHEX dt1 = new DataTypeHEX();
        dt1.setLength(4);
        dt1.setParams("2,0");
        dt1.setBytes(bytes);
        System.out.println(dt1.getValue() + "~~" + dt1.toHexString());
    }
}

