/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine.datatype;

import com.viewshine.codec.engine.datatype.DataType;
import com.viewshine.codec.utils.ByteUtils;
import com.viewshine.codec.utils.StringUtils;

public class DataTypeBitSet
extends DataType {
    private boolean isNull = true;
    private String value;
    private boolean lowBitBefore = false;
    private boolean isInt = true;

    @Override
    public void setParams(String params) {
        if (StringUtils.isEmpty(params)) {
            return;
        }
        String[] items = params.split(",");
        if (items.length > 0) {
            boolean bl = this.isInt = !"0".equals(items[0]);
            if (items.length > 1) {
                this.lowBitBefore = !"0".equals(items[1]);
            }
        }
    }

    @Override
    public void setBytes(byte[] src, int pos) {
        if (src != null && src.length > 0) {
            this.value = ByteUtils.bytesToBitSetString(src, pos, this.bitPos, this.length, this.lowBitBefore);
            this.isNull = false;
        }
    }

    @Override
    public byte[] getBytes() {
        if (!this.isNull) {
            return ByteUtils.bitSetStringToBytes(this.value, this.lowBitBefore);
        }
        return null;
    }

    @Override
    public String toHexString() {
        if (!this.isNull) {
            return ByteUtils.bytesToHexStr(this.getBytes(), " ");
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        if (!StringUtils.isEmpty(value)) {
            if (this.isInt) {
                int intValue = Integer.parseInt(value);
                this.value = ByteUtils.intToBitSetStr(intValue, this.length, this.lowBitBefore);
            } else {
                this.value = value.length() > this.length ? value.substring(0, this.length) : value;
            }
            this.isNull = false;
        }
    }

    @Override
    public String getValue() {
        if (this.isInt) {
            return Integer.parseInt(this.value, 2) + "";
        }
        return this.value;
    }

    public String getBitSetStr() {
        String bitsetStr = this.value;
        if (this.lowBitBefore) {
            bitsetStr = new StringBuilder(bitsetStr).reverse().toString();
        }
        return bitsetStr;
    }

    @Override
    public boolean isEmpty() {
        return this.isNull;
    }

    public static void main(String[] args) {
        DataTypeBitSet dt = new DataTypeBitSet();
        dt.setLength(16);
        dt.setParams("1");
        dt.setValue("42768");
        byte[] bytes = dt.getBytes();
        System.out.println(dt.getValue() + "~~" + dt.toHexString());
        DataTypeBitSet dt1 = new DataTypeBitSet();
        dt1.setLength(16);
        dt1.setParams("1");
        dt1.setBytes(bytes);
        System.out.println(dt1.getValue() + "~~" + dt1.toHexString());
    }
}

