/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine.datatype;

import com.viewshine.codec.engine.datatype.DataType;
import com.viewshine.codec.utils.ByteUtils;
import com.viewshine.codec.utils.StringUtils;
import java.math.BigDecimal;

public class DataTypeBCD
extends DataType {
    private long value;
    private boolean isNull = true;
    private int decimalLen;
    private boolean lowByteBefore = false;
    private boolean isNegative = false;

    @Override
    public void setParams(String params) {
        if (StringUtils.isEmpty(params)) {
            return;
        }
        String[] items = params.split(",");
        if (items.length > 0) {
            this.decimalLen = Integer.parseInt(items[0]);
            if (items.length > 1) {
                this.lowByteBefore = "1".equals(items[1]);
            }
        }
    }

    @Override
    public void setBytes(byte[] src, int pos) {
        if (src != null && src.length > 0) {
            int firstIndex = pos;
            if (this.lowByteBefore) {
                firstIndex = pos + this.length - 1;
            }
            if ((src[firstIndex] & 0xF0) == 240) {
                this.isNegative = true;
                byte[] bytes = ByteUtils.copyBytes(src, pos, this.length);
                bytes[firstIndex - pos] = (byte)(bytes[firstIndex - pos] & 0xF);
                this.value = ByteUtils.bcdBytesToInt(bytes, 0, this.length, this.lowByteBefore);
            } else {
                this.value = ByteUtils.bcdBytesToInt(src, pos, this.length, this.lowByteBefore);
            }
            this.isNull = false;
        }
    }

    @Override
    public byte[] getBytes() {
        if (!this.isNull) {
            byte[] bytes = ByteUtils.intToBcdBytes(this.value, this.length, this.lowByteBefore);
            if (this.isNegative) {
                if (this.lowByteBefore) {
                    bytes[bytes.length - 1] = (byte)(bytes[bytes.length - 1] | 0xF0);
                } else {
                    bytes[0] = (byte)(bytes[0] | 0xF0);
                }
            }
            return bytes;
        }
        return null;
    }

    @Override
    public String toHexString() {
        byte[] bytes = this.getBytes();
        return ByteUtils.bytesToHexStr(bytes, 0, bytes.length, false, " ");
    }

    @Override
    public void setValue(String value) {
        double dv = Double.parseDouble(value);
        if (dv < 0.0) {
            this.isNegative = true;
            dv *= -1.0;
        }
        this.value = (long)(dv * Math.pow(10.0, this.decimalLen));
        this.isNull = false;
    }

    @Override
    public String getValue() {
        if (this.isNull) {
            return null;
        }
        String rs = this.value + "";
        if (this.decimalLen > 0) {
            double d = Math.pow(10.0, this.decimalLen);
            double f1 = new BigDecimal((double)this.value / d).setScale(this.decimalLen, 4).doubleValue();
            if (this.isNegative) {
                f1 *= -1.0;
            }
            rs = f1 + "";
        }
        return rs;
    }

    public static void main(String[] args) {
        DataTypeBCD dt = new DataTypeBCD();
        dt.setLength(4);
        dt.setParams("2,0");
        dt.setValue("1234.56");
        byte[] bytes = dt.getBytes();
        System.out.println(dt.getValue() + "~~" + dt.toHexString());
        DataTypeBCD dt1 = new DataTypeBCD();
        dt1.setLength(4);
        dt1.setParams("2,0");
        dt1.setBytes(bytes);
        System.out.println(dt1.getValue() + "~~" + dt1.toHexString());
    }
}

