/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine.datatype;

import com.viewshine.codec.engine.datatype.DataType;
import com.viewshine.codec.utils.ByteUtils;

public class DataTypeASCII
extends DataType {
    private boolean isNull = true;
    private String value;
    private String charset = "utf-8";

    @Override
    public void setParams(String params) {
        if ("gbk".equals(params.toLowerCase()) || "gb2312".equals(params.toLowerCase())) {
            this.charset = params;
        }
    }

    @Override
    public void setBytes(byte[] src, int pos) {
        if (src != null && src.length > 0) {
            int i;
            byte[] bytes = null;
            int startIndex = pos;
            int endIndex = pos + this.length;
            for (i = pos; i < pos + this.length; ++i) {
                if (src[i] == 0) continue;
                startIndex = i;
                break;
            }
            for (i = pos + this.length - 1; i >= pos; --i) {
                if (src[i] == 0) continue;
                endIndex = i;
                break;
            }
            bytes = ByteUtils.copyBytes(src, startIndex, endIndex - startIndex + 1);
            this.value = ByteUtils.getString(bytes, this.charset);
            this.isNull = false;
        }
    }

    @Override
    public byte[] getBytes() {
        if (!this.isNull) {
            byte[] bytes = ByteUtils.getBytes(this.value, this.charset);
            if (bytes.length < this.length) {
                byte[] b = new byte[this.length - bytes.length];
                bytes = ByteUtils.concatBytes(bytes, new byte[][]{b});
            }
            return bytes;
        }
        return null;
    }

    @Override
    public String toHexString() {
        if (!this.isNull) {
            return ByteUtils.bytesToHexStr(this.getBytes(), " ");
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.isNull = false;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static void main(String[] args) {
        DataTypeASCII dt = new DataTypeASCII();
        dt.setLength(16);
        dt.setValue(" ABC123  ");
        byte[] bytes = dt.getBytes();
        System.out.println(dt.getValue() + "~~" + dt.toHexString());
        DataTypeASCII dt1 = new DataTypeASCII();
        dt1.setLength(16);
        dt1.setBytes(bytes);
        System.out.println(dt1.getValue() + "~~" + dt1.toHexString());
    }
}

