/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine.datatype;

import com.viewshine.codec.engine.datatype.DataType;
import com.viewshine.codec.utils.ByteUtils;

public class DataTypeA2
extends DataType {
    private boolean isNull = true;
    private String value;
    private boolean lowByteBefore = false;

    @Override
    public void setParams(String params) {
        if (!"0".equals(params)) {
            this.lowByteBefore = true;
        }
    }

    @Override
    public void setBytes(byte[] src, int pos) {
        if (src != null && src.length > 0) {
            this.value = "";
            if (this.lowByteBefore) {
                for (int i = this.length - 1; i >= 0; --i) {
                    this.value = this.value + Integer.toHexString(src[pos + i] & 0xFF);
                }
            } else {
                for (int i = 0; i < this.length; ++i) {
                    this.value = this.value + Integer.toHexString(src[pos + i] & 0xFF);
                }
            }
            this.isNull = false;
        }
    }

    @Override
    public byte[] getBytes() {
        if (!this.isNull) {
            int len;
            byte[] bytes = new byte[this.length];
            int n = len = this.length < this.value.length() ? this.length : this.value.length();
            if (this.lowByteBefore) {
                for (int i = 0; i < len; ++i) {
                    bytes[bytes.length - 1 - i] = ByteUtils.hexStrToByte(this.value.charAt(i) + "");
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    bytes[i] = ByteUtils.hexStrToByte(this.value.charAt(i) + "");
                }
            }
            return bytes;
        }
        return null;
    }

    @Override
    public String toHexString() {
        if (!this.isNull) {
            return ByteUtils.bytesToHexStr(this.getBytes(), " ");
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.isNull = false;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static void main(String[] args) {
        DataTypeA2 dt = new DataTypeA2();
        dt.setLength(4);
        dt.setParams("1");
        dt.setValue("1234");
        byte[] bytes = dt.getBytes();
        System.out.println(dt.getValue() + "~~" + dt.toHexString());
        DataTypeA2 dt1 = new DataTypeA2();
        dt1.setLength(4);
        dt1.setParams("1");
        dt1.setBytes(bytes);
        System.out.println(dt1.getValue() + "~~" + dt1.toHexString());
    }
}

