/*
 * Decompiled with CFR 0.152.
 */
package com.viewshine.codec.engine.datatype;

import com.viewshine.codec.engine.datatype.DataType;
import com.viewshine.codec.utils.ByteUtils;
import com.viewshine.codec.utils.StringUtils;
import java.math.BigDecimal;

public class DataTypeA1
extends DataType {
    private long intValue;
    private double decimalValue;
    private int intByteLen;
    private int decimalByteLen;
    private boolean lowByteBefore = true;
    private boolean decimalByteBefor = true;
    private boolean signed = false;
    private boolean isNegative = false;

    @Override
    public void setLength(int length) {
        this.length = length;
        this.intByteLen = length;
    }

    @Override
    public void setParams(String params) {
        if (StringUtils.isEmpty(params)) {
            return;
        }
        String[] items = params.split(",");
        if (items.length > 0) {
            this.decimalByteLen = Integer.parseInt(items[0]);
            this.intByteLen = this.length - this.decimalByteLen;
            if (items.length > 1) {
                boolean bl = this.signed = !"0".equals(items[1]);
                if (items.length > 2) {
                    boolean bl2 = this.lowByteBefore = !"0".equals(items[2]);
                    if (items.length > 3) {
                        this.decimalByteBefor = !"0".equals(items[3]);
                    }
                }
            }
        }
    }

    @Override
    public void setBytes(byte[] src, int pos) {
        for (int i = pos; i < pos + this.length && src[i] == -1; ++i) {
            if (i != pos + this.length - 1) continue;
            return;
        }
        byte[] intBytes = new byte[this.intByteLen];
        byte[] decimalBytes = new byte[this.decimalByteLen];
        if (this.lowByteBefore) {
            int i;
            if (this.decimalByteBefor) {
                for (i = 0; i < this.decimalByteLen; ++i) {
                    decimalBytes[this.decimalByteLen - 1 - i] = src[pos + i];
                }
                for (i = 0; i < this.intByteLen; ++i) {
                    intBytes[this.intByteLen - 1 - i] = src[pos + this.decimalByteLen + i];
                }
            } else {
                for (i = 0; i < this.intByteLen; ++i) {
                    intBytes[this.intByteLen - 1 - i] = src[pos + i];
                }
                for (i = 0; i < this.decimalByteLen; ++i) {
                    decimalBytes[this.decimalByteLen - 1 - i] = src[pos + this.intByteLen + i];
                }
            }
        } else if (this.decimalByteBefor) {
            System.arraycopy(src, pos, decimalBytes, 0, decimalBytes.length);
            System.arraycopy(src, pos + decimalBytes.length, intBytes, 0, intBytes.length);
        } else {
            System.arraycopy(src, pos, intBytes, 0, intBytes.length);
            System.arraycopy(src, pos + intBytes.length, decimalBytes, 0, decimalBytes.length);
        }
        if (this.signed && (intBytes[0] & 0x80) == 128) {
            this.isNegative = true;
            intBytes[0] = (byte)(intBytes[0] & 0x7F);
        }
        for (byte b : intBytes) {
            this.intValue <<= 8;
            this.intValue |= (long)(b & 0xFF);
        }
        long decimal = 0L;
        for (byte b : decimalBytes) {
            decimal <<= 8;
            decimal |= (long)(b & 0xFF);
        }
        this.decimalValue = (double)decimal / Math.pow(100.0, this.decimalByteLen);
        this.isNull = false;
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull) {
            return null;
        }
        byte[] intBytes = new byte[this.intByteLen];
        byte[] decimalBytes = new byte[this.decimalByteLen];
        long decimal = Math.round(this.decimalValue * Math.pow(100.0, this.decimalByteLen));
        if (this.lowByteBefore) {
            int i;
            for (i = 0; i < this.intByteLen; ++i) {
                intBytes[i] = (byte)(this.intValue >> 8 * i & 0xFFL);
            }
            for (i = 0; i < this.decimalByteLen; ++i) {
                decimalBytes[i] = (byte)(decimal >> 8 * i & 0xFFL);
            }
            if (this.isNegative) {
                intBytes[this.intByteLen - 1] = (byte)(intBytes[this.intByteLen - 1] | 0x80);
            }
        } else {
            int i;
            for (i = 0; i < this.intByteLen; ++i) {
                intBytes[intBytes.length - i - 1] = (byte)(this.intValue >> 8 * i & 0xFFL);
            }
            for (i = 0; i < this.decimalByteLen; ++i) {
                decimalBytes[decimalBytes.length - i - 1] = (byte)(decimal >> 8 * i & 0xFFL);
            }
            if (this.isNegative) {
                intBytes[0] = (byte)(intBytes[this.intByteLen - 1] | 0x80);
            }
        }
        if (this.decimalByteBefor) {
            return ByteUtils.concatBytes(decimalBytes, new byte[][]{intBytes});
        }
        return ByteUtils.concatBytes(intBytes, new byte[][]{decimalBytes});
    }

    @Override
    public String toHexString() {
        byte[] bytes = this.getBytes();
        return ByteUtils.bytesToHexStr(bytes, 0, bytes.length, false, " ");
    }

    @Override
    public void setValue(String value) {
        Double d = Double.parseDouble(value);
        this.intValue = d.longValue();
        if (this.intValue < 0L) {
            this.isNegative = true;
            this.intValue *= -1L;
        }
        if (this.decimalByteLen > 0) {
            this.decimalValue = d - (double)d.longValue();
        }
        this.isNull = false;
    }

    @Override
    public String getValue() {
        if (this.isNull) {
            return null;
        }
        BigDecimal dd = new BigDecimal((double)this.intValue + this.decimalValue).setScale(this.decimalByteLen * 2, 4);
        return (this.isNegative ? "-" : "") + dd;
    }

    public static void main(String[] args) {
        String hex = "10 12 12 11";
        DataTypeA1 dt1 = new DataTypeA1();
        dt1.setLength(4);
        dt1.setParams("2,0");
        dt1.setBytes(ByteUtils.hexStrToBytes(hex));
        System.out.println(dt1.getValue() + "~~" + dt1.toHexString());
    }
}

